/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.ux.extension.xxd.ui.internal.validation;

import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.eclipse.chemclipse.support.text.ValueFormat;
import org.eclipse.core.databinding.validation.IValidator;
import org.eclipse.core.databinding.validation.ValidationStatus;
import org.eclipse.core.runtime.IStatus;

public class TraceValidator
implements IValidator {
    private static final String ERROR = "Please enter valid traces, e.g.: 320.1 400";
    private static final String ERROR_VALUE = "The trace value can't be parsed: ";
    private DecimalFormat decimalFormat = ValueFormat.getDecimalFormatEnglish((String)"0.#");
    private Set<Double> traces = new TreeSet<Double>();

    public IStatus validate(Object value) {
        this.traces.clear();
        String message = null;
        if (value == null) {
            message = ERROR;
        } else if (value instanceof String) {
            String[] values;
            String text = (String)value;
            String[] stringArray = values = text.split(" ");
            int n = values.length;
            int n2 = 0;
            while (n2 < n) {
                String val = stringArray[n2];
                try {
                    this.traces.add(Double.parseDouble(val));
                }
                catch (NumberFormatException e) {
                    message = ERROR_VALUE + val;
                    break;
                }
                ++n2;
            }
        } else {
            message = ERROR;
        }
        if (message != null) {
            return ValidationStatus.error((String)message);
        }
        return ValidationStatus.ok();
    }

    public List<Double> getTraces() {
        return new ArrayList<Double>(this.traces);
    }

    public String getTracesAsString() {
        StringBuilder builder = new StringBuilder();
        Iterator<Double> iterator = this.traces.iterator();
        while (iterator.hasNext()) {
            builder.append(this.decimalFormat.format(iterator.next()));
            if (!iterator.hasNext()) continue;
            builder.append(" ");
        }
        return builder.toString();
    }
}

