/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.ux.extension.xxd.ui.internal.support;

import org.eclipse.chemclipse.csd.model.core.IChromatogramCSD;
import org.eclipse.chemclipse.csd.model.core.IChromatogramPeakCSD;
import org.eclipse.chemclipse.csd.model.core.support.PeakBuilderCSD;
import org.eclipse.chemclipse.model.exceptions.PeakException;
import org.eclipse.chemclipse.model.support.BackgroundAbundanceRange;
import org.eclipse.chemclipse.model.support.IBackgroundAbundanceRange;
import org.eclipse.chemclipse.model.support.IScanRange;
import org.eclipse.chemclipse.model.support.ScanRange;
import org.eclipse.chemclipse.msd.model.core.IChromatogramMSD;
import org.eclipse.chemclipse.msd.model.core.IChromatogramPeakMSD;
import org.eclipse.chemclipse.msd.model.core.support.PeakBuilderMSD;
import org.eclipse.chemclipse.wsd.model.core.IChromatogramPeakWSD;
import org.eclipse.chemclipse.wsd.model.core.IChromatogramWSD;
import org.eclipse.chemclipse.wsd.model.core.support.PeakBuilderWSD;

public class ManualPeakDetector {
    private static final String DETECTOR_DESCRIPTION = "Manual";

    public IChromatogramPeakMSD calculatePeak(IChromatogramMSD chromatogram, int startRetentionTime, int stopRetentionTime, float startAbundance, float stopAbundance) throws PeakException {
        BackgroundAbundanceRange backgroundAbundanceRange;
        int stopScan;
        if (chromatogram == null) {
            throw new PeakException("The chromatogram instance must be not null.");
        }
        int startScan = chromatogram.getScanNumber(startRetentionTime);
        ScanRange scanRange = new ScanRange(startScan, stopScan = chromatogram.getScanNumber(stopRetentionTime));
        IChromatogramPeakMSD peak = PeakBuilderMSD.createPeak((IChromatogramMSD)chromatogram, (IScanRange)scanRange, (IBackgroundAbundanceRange)(backgroundAbundanceRange = new BackgroundAbundanceRange(startAbundance, stopAbundance)), (boolean)true);
        if (peak != null) {
            peak.setDetectorDescription(DETECTOR_DESCRIPTION);
        }
        return peak;
    }

    public IChromatogramPeakCSD calculatePeak(IChromatogramCSD chromatogram, int startRetentionTime, int stopRetentionTime, float startAbundance, float stopAbundance) throws PeakException {
        BackgroundAbundanceRange backgroundAbundanceRange;
        int stopScan;
        if (chromatogram == null) {
            throw new PeakException("The chromatogram instance must be not null.");
        }
        int startScan = chromatogram.getScanNumber(startRetentionTime);
        ScanRange scanRange = new ScanRange(startScan, stopScan = chromatogram.getScanNumber(stopRetentionTime));
        IChromatogramPeakCSD peak = PeakBuilderCSD.createPeak((IChromatogramCSD)chromatogram, (IScanRange)scanRange, (IBackgroundAbundanceRange)(backgroundAbundanceRange = new BackgroundAbundanceRange(startAbundance, stopAbundance)), (boolean)true);
        if (peak != null) {
            peak.setDetectorDescription(DETECTOR_DESCRIPTION);
        }
        return peak;
    }

    public IChromatogramPeakWSD calculatePeak(IChromatogramWSD chromatogram, int startRetentionTime, int stopRetentionTime, float startAbundance, float stopAbundance) throws PeakException {
        BackgroundAbundanceRange backgroundAbundanceRange;
        int stopScan;
        if (chromatogram == null) {
            throw new PeakException("The chromatogram instance must be not null.");
        }
        int startScan = chromatogram.getScanNumber(startRetentionTime);
        ScanRange scanRange = new ScanRange(startScan, stopScan = chromatogram.getScanNumber(stopRetentionTime));
        IChromatogramPeakWSD peak = PeakBuilderWSD.createPeak((IChromatogramWSD)chromatogram, (IScanRange)scanRange, (IBackgroundAbundanceRange)(backgroundAbundanceRange = new BackgroundAbundanceRange(startAbundance, stopAbundance)), (boolean)true);
        if (peak != null) {
            peak.setDetectorDescription(DETECTOR_DESCRIPTION);
        }
        return peak;
    }
}

