/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.ux.extension.xxd.ui.internal.provider;

import org.eclipse.chemclipse.converter.model.reports.ISequenceRecord;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;

public class SequenceListFilter
extends ViewerFilter {
    private String searchText;
    private boolean caseSensitive;

    public void setSearchText(String searchText, boolean caseSensitive) {
        this.searchText = ".*" + searchText + ".*";
        this.caseSensitive = caseSensitive;
    }

    public boolean select(Viewer viewer, Object parentElement, Object element) {
        if (this.searchText == null || this.searchText.equals("")) {
            return true;
        }
        if (element instanceof ISequenceRecord) {
            ISequenceRecord sequenceRecord = (ISequenceRecord)element;
            String dataFile = sequenceRecord.getDataFile();
            String processMethod = sequenceRecord.getProcessMethod();
            String reportMethod = sequenceRecord.getReportMethod();
            String sampleName = sequenceRecord.getSampleName();
            String substance = sequenceRecord.getSubstance();
            String description = sequenceRecord.getDescription();
            if (!this.caseSensitive) {
                this.searchText = this.searchText.toLowerCase();
                dataFile = dataFile.toLowerCase();
                processMethod = processMethod.toLowerCase();
                reportMethod = reportMethod.toLowerCase();
                sampleName = sampleName.toLowerCase();
                substance = substance.toLowerCase();
                description = description.toLowerCase();
            }
            if (dataFile.matches(this.searchText)) {
                return true;
            }
            if (sequenceRecord.getDescription().matches(this.searchText)) {
                return true;
            }
            if (processMethod.matches(this.searchText)) {
                return true;
            }
            if (reportMethod.matches(this.searchText)) {
                return true;
            }
            if (sampleName.matches(this.searchText)) {
                return true;
            }
            if (substance.matches(this.searchText)) {
                return true;
            }
            if (description.matches(this.searchText)) {
                return true;
            }
        }
        return false;
    }
}

