/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.ux.extension.xxd.ui.internal.provider;

import java.util.ArrayList;
import java.util.Collections;
import org.eclipse.chemclipse.csd.model.core.IChromatogramPeakCSD;
import org.eclipse.chemclipse.model.comparator.TargetExtendedComparator;
import org.eclipse.chemclipse.model.core.IPeak;
import org.eclipse.chemclipse.model.core.IPeakModel;
import org.eclipse.chemclipse.model.core.IScan;
import org.eclipse.chemclipse.model.core.ITargetSupplier;
import org.eclipse.chemclipse.model.identifier.IIdentificationTarget;
import org.eclipse.chemclipse.msd.model.core.IChromatogramPeakMSD;
import org.eclipse.chemclipse.support.comparator.SortOrder;
import org.eclipse.chemclipse.support.ui.swt.AbstractRecordTableComparator;
import org.eclipse.chemclipse.support.ui.swt.IRecordTableComparator;
import org.eclipse.jface.viewers.Viewer;

public class PeakTableTargetComparator
extends AbstractRecordTableComparator
implements IRecordTableComparator {
    private TargetExtendedComparator targetExtendedComparator = new TargetExtendedComparator(SortOrder.DESC);

    public int compare(Viewer viewer, Object e1, Object e2) {
        int sortOrder = 0;
        if (e1 instanceof IPeak && e2 instanceof IPeak) {
            IPeak peak1 = (IPeak)e1;
            IPeakModel peakModel1 = peak1.getPeakModel();
            IScan peakMaximum1 = peakModel1.getPeakMaximum();
            ArrayList peakTargets1 = new ArrayList();
            if (peak1 instanceof ITargetSupplier) {
                IPeak targetSupplier = peak1;
                peakTargets1.addAll(targetSupplier.getTargets());
            }
            String peakTarget1 = "";
            if (peakTargets1 != null && peakTargets1.size() > 0) {
                Collections.sort(peakTargets1, this.targetExtendedComparator);
                peakTarget1 = ((IIdentificationTarget)peakTargets1.get(0)).getLibraryInformation().getName();
            }
            IPeak peak2 = (IPeak)e2;
            IPeakModel peakModel2 = peak2.getPeakModel();
            IScan peakMaximum2 = peakModel2.getPeakMaximum();
            ArrayList peakTargets2 = new ArrayList();
            if (peak2 instanceof ITargetSupplier) {
                IPeak targetSupplier = peak2;
                peakTargets2.addAll(targetSupplier.getTargets());
            }
            String peakTarget2 = "";
            if (peakTargets2 != null && peakTargets2.size() > 0) {
                Collections.sort(peakTargets2, this.targetExtendedComparator);
                peakTarget2 = ((IIdentificationTarget)peakTargets2.get(0)).getLibraryInformation().getName();
            }
            switch (this.getPropertyIndex()) {
                case 0: {
                    sortOrder = Integer.compare(peakMaximum2.getRetentionTime(), peakMaximum1.getRetentionTime());
                    break;
                }
                case 1: {
                    sortOrder = peakTarget2.compareTo(peakTarget1);
                    break;
                }
                case 2: {
                    if (peak1 instanceof IChromatogramPeakMSD && peak2 instanceof IChromatogramPeakMSD) {
                        sortOrder = Float.compare(((IChromatogramPeakMSD)peak2).getSignalToNoiseRatio(), ((IChromatogramPeakMSD)peak1).getSignalToNoiseRatio());
                        break;
                    }
                    if (!(peak1 instanceof IChromatogramPeakCSD) || !(peak2 instanceof IChromatogramPeakCSD)) break;
                    sortOrder = Float.compare(((IChromatogramPeakCSD)peak2).getSignalToNoiseRatio(), ((IChromatogramPeakCSD)peak1).getSignalToNoiseRatio());
                    break;
                }
                case 3: {
                    sortOrder = Double.compare(peak2.getIntegratedArea(), peak1.getIntegratedArea());
                }
            }
        }
        if (this.getDirection() == 0) {
            sortOrder = -sortOrder;
        }
        return sortOrder;
    }
}

