/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.ux.extension.xxd.ui.internal.provider;

import org.eclipse.chemclipse.model.quantitation.IInternalStandard;
import org.eclipse.chemclipse.support.ui.swt.ExtendedTableViewer;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.TableItem;

public class InternalStandardEditingSupport
extends EditingSupport {
    private CellEditor cellEditor;
    private ExtendedTableViewer tableViewer;
    private String column;

    public InternalStandardEditingSupport(ExtendedTableViewer tableViewer, String column) {
        super((ColumnViewer)tableViewer);
        this.column = column;
        this.cellEditor = new TextCellEditor((Composite)tableViewer.getTable());
        this.tableViewer = tableViewer;
    }

    protected CellEditor getCellEditor(Object element) {
        return this.cellEditor;
    }

    protected boolean canEdit(Object element) {
        return this.tableViewer.isEditEnabled();
    }

    protected Object getValue(Object element) {
        String object;
        block10: {
            object = null;
            if (!(element instanceof IInternalStandard)) break block10;
            IInternalStandard internalStandard = (IInternalStandard)element;
            switch (this.column) {
                case "Name": {
                    object = internalStandard.getName();
                    break;
                }
                case "Chemical Class": {
                    object = internalStandard.getChemicalClass();
                }
            }
        }
        return object;
    }

    protected void setValue(Object element, Object value) {
        block10: {
            if (!(element instanceof IInternalStandard)) break block10;
            IInternalStandard internalStandard = (IInternalStandard)element;
            switch (this.column) {
                case "Name": {
                    String name = ((String)value).trim();
                    if (!this.isRenameAllowed(name)) break;
                    internalStandard.setName(name);
                    break;
                }
                case "Chemical Class": {
                    String chemicalClass = ((String)value).trim();
                    internalStandard.setChemicalClass(chemicalClass);
                }
            }
            this.tableViewer.refresh();
        }
    }

    private boolean isRenameAllowed(String name) {
        TableItem[] tableItemArray = this.tableViewer.getTable().getItems();
        int n = tableItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            IInternalStandard internalStandard;
            TableItem tableItem = tableItemArray[n2];
            Object object = tableItem.getData();
            if (object instanceof IInternalStandard && (internalStandard = (IInternalStandard)object).getName().equals(name)) {
                return false;
            }
            ++n2;
        }
        return true;
    }
}

