/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.ux.extension.xxd.ui.editors;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import java.util.Map;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import org.eclipse.chemclipse.logging.core.Logger;
import org.eclipse.chemclipse.support.ui.addons.ModelSupportAddon;
import org.eclipse.chemclipse.support.ui.workbench.DisplayUtils;
import org.eclipse.chemclipse.ux.extension.ui.editors.IScanEditorXIR;
import org.eclipse.chemclipse.ux.extension.xxd.ui.internal.runnables.ScanXIRImportRunnable;
import org.eclipse.chemclipse.ux.extension.xxd.ui.part.support.AbstractDataUpdateSupport;
import org.eclipse.chemclipse.ux.extension.xxd.ui.part.support.IDataUpdateSupport;
import org.eclipse.chemclipse.ux.extension.xxd.ui.swt.editors.ExtendedXIRScanUI;
import org.eclipse.chemclipse.xir.model.core.IScanXIR;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.ui.di.Focus;
import org.eclipse.e4.ui.di.Persist;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.ui.MDirtyable;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.model.application.ui.basic.MPartStack;
import org.eclipse.e4.ui.workbench.modeling.EModelService;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;

public class ScanEditorXIR
extends AbstractDataUpdateSupport
implements IScanEditorXIR,
IDataUpdateSupport {
    private static final Logger logger = Logger.getLogger(ScanEditorXIR.class);
    public static final String ID = "org.eclipse.chemclipse.ux.extension.xxd.ui.part.scanEditorXIR";
    public static final String CONTRIBUTION_URI = "bundleclass://org.eclipse.chemclipse.ux.extension.xxd.ui/org.eclipse.chemclipse.ux.extension.xxd.ui.editors.ScanEditorXIR";
    public static final String ICON_URI = "platform:/plugin/org.eclipse.chemclipse.rcp.ui.icons/icons/16x16/scan-xir.gif";
    public static final String TOOLTIP = "FTIR/NIR/MIR Editor";
    private final MPart part;
    private final MDirtyable dirtyable;
    private final IEventBroker eventBroker;
    private File scanFile;
    private ExtendedXIRScanUI extendedScanXIREditorUI;
    private IScanXIR scanXIR = null;
    private final Shell shell;

    @Inject
    public ScanEditorXIR(Composite parent, MPart part, MDirtyable dirtyable, Shell shell) {
        super(part);
        this.part = part;
        this.dirtyable = dirtyable;
        this.eventBroker = ModelSupportAddon.getEventBroker();
        this.shell = shell;
        this.initialize(parent);
    }

    @Override
    public void registerEvents() {
        this.registerEvent("scan/xir/update/selection", "org.eclipse.e4.data");
    }

    @Override
    public void updateObjects(List<Object> objects, String topic) {
        objects.size();
    }

    @Focus
    public void setFocus() {
    }

    @Override
    @PreDestroy
    protected void preDestroy() {
        super.preDestroy();
        this.eventBroker.send("scan/xir/unload/selection", null);
        EModelService modelService = ModelSupportAddon.getModelService();
        if (modelService != null) {
            MApplication application = ModelSupportAddon.getApplication();
            final MPartStack partStack = (MPartStack)modelService.find("org.eclipse.e4.primaryDataStack", (MUIElement)application);
            this.part.setToBeRendered(false);
            this.part.setVisible(false);
            DisplayUtils.getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    partStack.getChildren().remove(ScanEditorXIR.this.part);
                }
            });
        }
        System.gc();
    }

    @Persist
    public void save() {
        System.out.println(this.scanFile);
        this.dirtyable.setDirty(false);
    }

    public boolean saveAs() {
        return true;
    }

    public IScanXIR getScanSelection() {
        return this.scanXIR;
    }

    private void initialize(Composite parent) {
        this.scanXIR = this.loadScan();
        this.createEditorPages(parent);
        this.extendedScanXIREditorUI.update(this.scanXIR);
    }

    private synchronized IScanXIR loadScan() {
        IScanXIR scanXIR = null;
        try {
            Object object = this.part.getObject();
            if (object instanceof Map) {
                Map map = (Map)object;
                File file = new File((String)map.get("File"));
                boolean batch = (Boolean)map.get("Batch");
                scanXIR = this.loadScan(file, batch);
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getLocalizedMessage(), (Throwable)e);
        }
        return scanXIR;
    }

    private IScanXIR loadScan(File file, boolean batch) {
        ProgressMonitorDialog dialog = new ProgressMonitorDialog(this.shell);
        ScanXIRImportRunnable runnable = new ScanXIRImportRunnable(file);
        try {
            boolean fork = !batch;
            dialog.run(fork, false, (IRunnableWithProgress)runnable);
        }
        catch (InvocationTargetException e) {
            logger.warn((Object)e);
        }
        catch (InterruptedException e) {
            logger.warn((Object)e);
        }
        this.scanFile = file;
        return runnable.getScanXIR();
    }

    private void createEditorPages(Composite parent) {
        this.createScanPage(parent);
    }

    private void createScanPage(Composite parent) {
        this.extendedScanXIREditorUI = new ExtendedXIRScanUI(parent);
    }
}

