/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.ux.extension.xxd.ui.calibration;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.chemclipse.model.columns.IRetentionIndexEntry;
import org.eclipse.chemclipse.model.columns.RetentionIndexEntry;
import org.eclipse.chemclipse.rcp.ui.icons.core.ApplicationImageFactory;
import org.eclipse.chemclipse.ux.extension.xxd.ui.calibration.ICalibrationEditListener;
import org.eclipse.chemclipse.ux.extension.xxd.ui.internal.validation.CalibrationNameValidator;
import org.eclipse.chemclipse.ux.extension.xxd.ui.internal.validation.RetentionIndexValidator;
import org.eclipse.chemclipse.ux.extension.xxd.ui.internal.validation.RetentionTimeValidator;
import org.eclipse.core.databinding.validation.IValidator;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.fieldassist.FieldDecorationRegistry;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class CalibrationEditUI
extends Composite {
    private static final String ACTION_INITIALIZE = "ACTION_INITIALIZE";
    private static final String ACTION_CANCEL = "ACTION_CANCEL";
    private static final String ACTION_DELETE = "ACTION_DELETE";
    private static final String ACTION_ADD = "ACTION_ADD";
    private static final String ACTION_SELECT = "ACTION_SELECT";
    private Text textRetentionTime;
    private Text textRetentionIndex;
    private Combo comboReferences;
    private Button buttonSet;
    private Button buttonCancel;
    private Button buttonDelete;
    private Button buttonAdd;
    private RetentionTimeValidator retentionTimeValidator;
    private ControlDecoration controlDecorationRetentionTime;
    private RetentionIndexValidator retentionIndexValidator;
    private ControlDecoration controlDecorationRetentionIndex;
    private CalibrationNameValidator calibrationNameValidator;
    private ControlDecoration controlDecorationName;
    private ICalibrationEditListener calibrationEditListener = null;
    private List<IRetentionIndexEntry> retentionIndexEntries = new ArrayList<IRetentionIndexEntry>();

    public CalibrationEditUI(Composite parent, int style) {
        super(parent, style);
        this.createControl();
    }

    public void setCalibrationEditListener(ICalibrationEditListener calibrationEditListener) {
        this.calibrationEditListener = calibrationEditListener;
    }

    public void clearRetentionIndexEntries() {
        this.retentionIndexEntries.clear();
    }

    public void addRetentionIndexEntries(List<IRetentionIndexEntry> retentionIndexEntries) {
        this.retentionIndexEntries.addAll(retentionIndexEntries);
    }

    public void selectRetentionIndices() {
        this.enableButtonFields(ACTION_SELECT);
    }

    private void createControl() {
        this.setLayout((Layout)new FillLayout());
        Composite composite = new Composite((Composite)this, 0);
        GridLayout gridLayout = new GridLayout(7, false);
        gridLayout.marginLeft = 0;
        gridLayout.marginRight = 0;
        composite.setLayout((Layout)gridLayout);
        this.textRetentionTime = this.createTextRetentionTime(composite);
        this.textRetentionIndex = this.createTextRetentionIndex(composite);
        this.comboReferences = this.createComboReferences(composite);
        this.buttonSet = this.createButtonSet(composite);
        this.buttonCancel = this.createButtonCancel(composite);
        this.buttonDelete = this.createButtonDelete(composite);
        this.buttonAdd = this.createButtonAdd(composite);
        this.enableButtonFields(ACTION_INITIALIZE);
    }

    private Text createTextRetentionTime(Composite parent) {
        Text text = new Text(parent, 2048);
        text.setText("");
        text.setToolTipText("Set the retention time in minutes.");
        text.setLayoutData((Object)new GridData(768));
        this.retentionTimeValidator = new RetentionTimeValidator();
        this.controlDecorationRetentionTime = new ControlDecoration((Control)text, 16512);
        text.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                CalibrationEditUI.this.validate();
            }
        });
        return text;
    }

    private Text createTextRetentionIndex(Composite parent) {
        Text text = new Text(parent, 2048);
        text.setText("");
        text.setToolTipText("Set the retention index.");
        text.setLayoutData((Object)new GridData(768));
        this.retentionIndexValidator = new RetentionIndexValidator();
        this.controlDecorationRetentionIndex = new ControlDecoration((Control)text, 16512);
        text.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                CalibrationEditUI.this.validate();
            }
        });
        return text;
    }

    private Combo createComboReferences(Composite parent) {
        final Combo combo = new Combo(parent, 2048);
        combo.setText("");
        combo.setItems(this.getAvailableStandards());
        combo.setLayoutData((Object)new GridData(768));
        this.calibrationNameValidator = new CalibrationNameValidator();
        this.controlDecorationName = new ControlDecoration((Control)combo, 16512);
        combo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String name = combo.getText().trim();
                IRetentionIndexEntry retentionIndexEntry = CalibrationEditUI.this.getRetentionIndexEntry(name);
                if (retentionIndexEntry != null) {
                    CalibrationEditUI.this.textRetentionIndex.setText(Float.toString(retentionIndexEntry.getRetentionIndex()));
                } else {
                    CalibrationEditUI.this.textRetentionIndex.setText("");
                }
                CalibrationEditUI.this.validate();
            }
        });
        combo.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                CalibrationEditUI.this.validate();
            }
        });
        return combo;
    }

    private Button createButtonSet(Composite parent) {
        Button button = new Button(parent, 8);
        button.setText("");
        button.setToolTipText("Set the retention index.");
        button.setImage(ApplicationImageFactory.getInstance().getImage("org.eclipse.chemclipse.rcp.ui.icons/execute_add.gif", "16x16"));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IRetentionIndexEntry retentionIndexEntry = CalibrationEditUI.this.createRetentionIndexEntry();
                if (retentionIndexEntry != null) {
                    CalibrationEditUI.this.fireUpdateAdd(retentionIndexEntry);
                    CalibrationEditUI.this.clearFields();
                    CalibrationEditUI.this.enableButtonFields(CalibrationEditUI.ACTION_INITIALIZE);
                }
            }
        });
        return button;
    }

    private Button createButtonCancel(Composite parent) {
        Button button = new Button(parent, 8);
        button.setText("");
        button.setToolTipText("Cancel the current operation.");
        button.setImage(ApplicationImageFactory.getInstance().getImage("org.eclipse.chemclipse.rcp.ui.icons/cancel.gif", "16x16"));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CalibrationEditUI.this.clearFields();
                CalibrationEditUI.this.enableButtonFields(CalibrationEditUI.ACTION_CANCEL);
            }
        });
        return button;
    }

    private Button createButtonDelete(Composite parent) {
        Button button = new Button(parent, 8);
        button.setText("");
        button.setToolTipText("Delete the selected calibration entrie(s).");
        button.setImage(ApplicationImageFactory.getInstance().getImage("org.eclipse.chemclipse.rcp.ui.icons/delete.gif", "16x16"));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CalibrationEditUI.this.fireUpdateDelete();
            }
        });
        return button;
    }

    private Button createButtonAdd(Composite parent) {
        Button button = new Button(parent, 8);
        button.setText("");
        button.setToolTipText("Activate the add operation.");
        button.setImage(ApplicationImageFactory.getInstance().getImage("org.eclipse.chemclipse.rcp.ui.icons/add.gif", "16x16"));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CalibrationEditUI.this.enableButtonFields(CalibrationEditUI.ACTION_ADD);
            }
        });
        return button;
    }

    private String[] getAvailableStandards() {
        int size = this.retentionIndexEntries.size();
        String[] availableStandards = new String[size];
        int i = 0;
        while (i < size) {
            availableStandards[i] = this.retentionIndexEntries.get(i).getName();
            ++i;
        }
        return availableStandards;
    }

    private IRetentionIndexEntry getRetentionIndexEntry(String name) {
        for (IRetentionIndexEntry retentionIndexEntry : this.retentionIndexEntries) {
            if (!retentionIndexEntry.getName().equals(name)) continue;
            return retentionIndexEntry;
        }
        return null;
    }

    private void enableButtonFields(String action) {
        this.enableFields(false);
        switch (action) {
            case "ACTION_INITIALIZE": {
                this.buttonAdd.setEnabled(true);
                break;
            }
            case "ACTION_CANCEL": {
                this.buttonAdd.setEnabled(true);
                this.hideControlDecorations();
                break;
            }
            case "ACTION_DELETE": {
                this.buttonAdd.setEnabled(true);
                break;
            }
            case "ACTION_ADD": {
                this.buttonCancel.setEnabled(true);
                this.comboReferences.setEnabled(true);
                this.textRetentionTime.setEnabled(true);
                this.textRetentionIndex.setEnabled(true);
                this.validate();
                break;
            }
            case "ACTION_SELECT": {
                this.buttonAdd.setEnabled(true);
                this.buttonDelete.setEnabled(true);
            }
        }
    }

    private void enableFields(boolean enabled) {
        this.textRetentionTime.setEnabled(enabled);
        this.textRetentionIndex.setEnabled(enabled);
        this.comboReferences.setEnabled(enabled);
        this.buttonSet.setEnabled(enabled);
        this.buttonCancel.setEnabled(enabled);
        this.buttonDelete.setEnabled(enabled);
        this.buttonAdd.setEnabled(enabled);
    }

    private void clearFields() {
        this.textRetentionTime.setText("");
        this.textRetentionIndex.setText("");
        this.comboReferences.setText("");
    }

    private boolean validate() {
        this.buttonSet.setEnabled(false);
        if (this.validate(this.retentionTimeValidator, this.controlDecorationRetentionTime, this.textRetentionTime.getText()) && this.validate(this.retentionIndexValidator, this.controlDecorationRetentionIndex, this.textRetentionIndex.getText()) && this.validate(this.calibrationNameValidator, this.controlDecorationName, this.comboReferences.getText())) {
            this.buttonSet.setEnabled(true);
            return true;
        }
        return false;
    }

    private IRetentionIndexEntry createRetentionIndexEntry() {
        RetentionIndexEntry retentionIndexEntry = null;
        if (this.validate()) {
            int retentionTime = (int)(this.retentionTimeValidator.getRetentionTime() * 60000.0);
            float retentionIndex = this.retentionIndexValidator.getRetentionIndex();
            String name = this.calibrationNameValidator.getName();
            retentionIndexEntry = new RetentionIndexEntry(retentionTime, retentionIndex, name);
        }
        return retentionIndexEntry;
    }

    private boolean validate(IValidator validator, ControlDecoration controlDecoration, String text) {
        IStatus status = validator.validate((Object)text);
        if (status.isOK()) {
            controlDecoration.hide();
            return true;
        }
        controlDecoration.setImage(FieldDecorationRegistry.getDefault().getFieldDecoration("DEC_CONTENT_PROPOSAL").getImage());
        controlDecoration.showHoverText(status.getMessage());
        controlDecoration.show();
        return false;
    }

    private void hideControlDecorations() {
        this.controlDecorationRetentionTime.hide();
        this.controlDecorationRetentionIndex.hide();
        this.controlDecorationName.hide();
    }

    private void fireUpdateDelete() {
        this.enableButtonFields(ACTION_DELETE);
        if (this.calibrationEditListener != null) {
            this.calibrationEditListener.delete();
        }
    }

    private void fireUpdateAdd(IRetentionIndexEntry retentionIndexEntry) {
        if (this.calibrationEditListener != null) {
            this.calibrationEditListener.add(retentionIndexEntry);
        }
    }
}

