/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.ux.extension.msd.ui.internal.support;

import java.io.File;
import java.util.List;
import org.eclipse.chemclipse.msd.converter.peak.PeakConverterMSD;
import org.eclipse.chemclipse.processing.converter.ISupplier;

public class PeakIdentifier {
    private static List<ISupplier> suppliers;

    public static boolean isPeak(File file) {
        String extension = file.toString().toLowerCase();
        if (file.isDirectory()) {
            return false;
        }
        if (suppliers == null) {
            suppliers = PeakConverterMSD.getPeakConverterSupport().getSupplier();
        } else {
            for (ISupplier supplier : suppliers) {
                String supplierExtension = supplier.getFileExtension().toLowerCase();
                if (supplierExtension == "" || !extension.endsWith(supplierExtension)) continue;
                return supplier.isImportable();
            }
        }
        return false;
    }

    public static boolean isPeakDirectory(File file) {
        String directory = file.toString().toUpperCase();
        if (!file.isDirectory()) {
            return false;
        }
        if (suppliers == null) {
            suppliers = PeakConverterMSD.getPeakConverterSupport().getSupplier();
        } else {
            for (ISupplier supplier : suppliers) {
                String directoryExtension = supplier.getDirectoryExtension().toUpperCase();
                if (directoryExtension == "" || !directory.endsWith(directoryExtension)) continue;
                return supplier.isImportable();
            }
        }
        return false;
    }
}

