/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.ux.extension.msd.ui.editors;

import java.io.File;
import java.io.FileNotFoundException;
import java.lang.reflect.InvocationTargetException;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import org.eclipse.chemclipse.converter.exceptions.FileIsEmptyException;
import org.eclipse.chemclipse.converter.exceptions.FileIsNotReadableException;
import org.eclipse.chemclipse.converter.exceptions.NoChromatogramConverterAvailableException;
import org.eclipse.chemclipse.converter.exceptions.NoConverterAvailableException;
import org.eclipse.chemclipse.logging.core.Logger;
import org.eclipse.chemclipse.model.exceptions.ChromatogramIsNullException;
import org.eclipse.chemclipse.model.updates.IUpdateListener;
import org.eclipse.chemclipse.msd.converter.database.DatabaseConverter;
import org.eclipse.chemclipse.msd.converter.exceptions.NoMassSpectrumConverterAvailableException;
import org.eclipse.chemclipse.msd.model.core.IMassSpectra;
import org.eclipse.chemclipse.msd.swt.ui.support.DatabaseFileSupport;
import org.eclipse.chemclipse.processing.core.IProcessingInfo;
import org.eclipse.chemclipse.processing.core.exceptions.TypeCastException;
import org.eclipse.chemclipse.support.ui.workbench.DisplayUtils;
import org.eclipse.chemclipse.ux.extension.msd.ui.internal.support.DatabaseImportRunnable;
import org.eclipse.chemclipse.ux.extension.msd.ui.swt.MassSpectrumLibraryUI;
import org.eclipse.chemclipse.ux.extension.ui.editors.IChemClipseEditor;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.ui.di.Focus;
import org.eclipse.e4.ui.di.Persist;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.ui.MDirtyable;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.model.application.ui.basic.MPartStack;
import org.eclipse.e4.ui.workbench.modeling.EModelService;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;

public class DatabaseEditor
implements IChemClipseEditor {
    public static final String ID = "org.eclipse.chemclipse.ux.extension.msd.ui.part.massSpectrumLibraryEditor";
    public static final String CONTRIBUTION_URI = "bundleclass://org.eclipse.chemclipse.ux.extension.msd.ui/org.eclipse.chemclipse.ux.extension.msd.ui.editors.DatabaseEditor";
    public static final String ICON_URI = "platform:/plugin/org.eclipse.chemclipse.rcp.ui.icons/icons/16x16/massSpectrumDatabase.gif";
    public static final String TOOLTIP = "Mass Spectrum Library - Detector Type: MSD";
    private static final Logger logger = Logger.getLogger(DatabaseEditor.class);
    @Inject
    private MPart part;
    @Inject
    private MDirtyable dirtyable;
    @Inject
    private MApplication application;
    @Inject
    private EModelService modelService;
    @Inject
    private IEventBroker eventBroker;
    private MassSpectrumLibraryUI massSpectrumLibraryUI;
    private File massSpectrumFile = null;
    private IMassSpectra massSpectra = null;
    private TabFolder tabFolder;

    @PostConstruct
    private void createControl(Composite parent) {
        this.loadMassSpectra();
        this.createPages(parent);
    }

    @Focus
    public void setFocus() {
        this.eventBroker.post("library/msd/update/selection", (Object)this.massSpectra);
    }

    @PreDestroy
    private void preDestroy() {
        this.eventBroker.post("library/msd/unload/selection", null);
        if (this.modelService != null) {
            MPartStack partStack = (MPartStack)this.modelService.find("org.eclipse.e4.primaryDataStack", (MUIElement)this.application);
            this.part.setToBeRendered(false);
            this.part.setVisible(false);
            partStack.getChildren().remove(this.part);
        }
        System.gc();
    }

    @Persist
    public void save() {
        ProgressMonitorDialog dialog = new ProgressMonitorDialog(DisplayUtils.getShell());
        IRunnableWithProgress runnable = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                try {
                    monitor.beginTask("Save Mass Spectra", -1);
                    try {
                        DatabaseEditor.this.saveMassSpectra(monitor, DisplayUtils.getShell());
                    }
                    catch (NoMassSpectrumConverterAvailableException e) {
                        throw new InvocationTargetException(e);
                    }
                }
                finally {
                    monitor.done();
                }
            }
        };
        try {
            dialog.run(true, false, runnable);
        }
        catch (InvocationTargetException e) {
            this.saveAs();
        }
        catch (InterruptedException e) {
            logger.warn((Object)e);
        }
    }

    private void saveMassSpectra(IProgressMonitor monitor, Shell shell) throws NoMassSpectrumConverterAvailableException {
        if (this.massSpectrumFile != null && this.massSpectra != null && shell != null) {
            String converterId = this.massSpectra.getConverterId();
            if (converterId != null && !converterId.equals("")) {
                monitor.subTask("Save Mass Spectra");
                IProcessingInfo processingInfo = DatabaseConverter.convert((File)this.massSpectrumFile, (IMassSpectra)this.massSpectra, (boolean)false, (String)converterId, (IProgressMonitor)monitor);
                try {
                    processingInfo.getProcessingResult(File.class);
                    this.dirtyable.setDirty(false);
                }
                catch (TypeCastException e) {
                    logger.warn((Object)e);
                }
            } else {
                throw new NoMassSpectrumConverterAvailableException();
            }
        }
    }

    public boolean saveAs() {
        boolean saveSuccessful = false;
        if (this.massSpectra != null) {
            try {
                saveSuccessful = DatabaseFileSupport.saveMassSpectra((IMassSpectra)this.massSpectra);
                this.dirtyable.setDirty(!saveSuccessful);
            }
            catch (NoConverterAvailableException e) {
                logger.warn((Object)e);
            }
        }
        return saveSuccessful;
    }

    private void loadMassSpectra() {
        try {
            Object object = this.part.getObject();
            if (object instanceof Map) {
                Map map = (Map)object;
                File file = new File((String)map.get("File"));
                boolean batch = (Boolean)map.get("Batch");
                this.importMassSpectra(file, batch);
            } else if (object instanceof String) {
                File file = new File((String)object);
                this.importMassSpectra(file, true);
            }
        }
        catch (Exception e) {
            logger.warn((Object)e);
        }
    }

    private void importMassSpectra(File file, boolean batch) throws FileNotFoundException, NoChromatogramConverterAvailableException, FileIsNotReadableException, FileIsEmptyException, ChromatogramIsNullException {
        ProgressMonitorDialog dialog = new ProgressMonitorDialog(DisplayUtils.getShell());
        DatabaseImportRunnable runnable = new DatabaseImportRunnable(file);
        try {
            boolean fork = !batch;
            dialog.run(fork, false, (IRunnableWithProgress)runnable);
        }
        catch (InvocationTargetException e) {
            logger.warn((Object)e);
        }
        catch (InterruptedException e) {
            logger.warn((Object)e);
        }
        this.dirtyable.setDirty(true);
        this.massSpectra = runnable.getMassSpectra();
        this.massSpectrumFile = file;
        this.massSpectra.addUpdateListener(new IUpdateListener(){

            public void update() {
                DatabaseEditor.this.updateMassSpectrumListUI();
            }
        });
    }

    private void createPages(Composite parent) {
        if (this.massSpectra != null && this.massSpectra.getMassSpectrum(1) != null) {
            String label = "".equals(this.massSpectra.getName()) ? this.massSpectrumFile.getName() : this.massSpectra.getName();
            this.part.setLabel(label);
            this.tabFolder = new TabFolder(parent, 1024);
            this.createEditorPage();
        } else {
            this.createErrorMessagePage(parent);
        }
    }

    private void createEditorPage() {
        TabItem tabItem = new TabItem(this.tabFolder, 0);
        tabItem.setText("Library");
        this.massSpectrumLibraryUI = new MassSpectrumLibraryUI((Composite)this.tabFolder, 0);
        this.massSpectrumLibraryUI.setLayout((Layout)new FillLayout());
        this.updateMassSpectrumListUI();
        tabItem.setControl((Control)this.massSpectrumLibraryUI);
    }

    private void createErrorMessagePage(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new FillLayout());
        Label label = new Label(composite, 0);
        label.setText("The mass spectrum couldn't be loaded.");
    }

    private void updateMassSpectrumListUI() {
        this.massSpectrumLibraryUI.update(this.massSpectrumFile, this.massSpectra);
    }
}

