/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.swt.ui.support;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.chemclipse.support.ui.workbench.DisplayUtils;
import org.eclipse.chemclipse.swt.ui.support.ColorScheme;
import org.eclipse.chemclipse.swt.ui.support.IColorScheme;
import org.eclipse.chemclipse.swt.ui.support.UnlimitedColorSchema;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;

public class Colors {
    public static final Color WHITE = DisplayUtils.getDisplay().getSystemColor(1);
    public static final Color RED = DisplayUtils.getDisplay().getSystemColor(3);
    public static final Color BLACK = DisplayUtils.getDisplay().getSystemColor(2);
    public static final Color DARK_RED = DisplayUtils.getDisplay().getSystemColor(4);
    public static final Color GREEN = DisplayUtils.getDisplay().getSystemColor(5);
    public static final Color GRAY = DisplayUtils.getDisplay().getSystemColor(15);
    public static final Color DARK_GRAY = DisplayUtils.getDisplay().getSystemColor(16);
    public static final Color CYAN = DisplayUtils.getDisplay().getSystemColor(13);
    public static final Color DARK_CYAN = DisplayUtils.getDisplay().getSystemColor(14);
    public static final Color DARK_YELLOW = DisplayUtils.getDisplay().getSystemColor(8);
    public static final Color DARK_GREEN = DisplayUtils.getDisplay().getSystemColor(6);
    public static final Color BLUE = DisplayUtils.getDisplay().getSystemColor(9);
    public static final Color MAGENTA = DisplayUtils.getDisplay().getSystemColor(11);
    public static final Color YELLOW = DisplayUtils.getDisplay().getSystemColor(7);
    public static final String COLOR_SCHEME_RED = "Red";
    private static final int[] colorIdsGradientRed;
    private static List<Color> colorsGradientRed;
    public static final String COLOR_SCHEME_GRADIENT = "Gradient";
    private static final int[] colorIdsGradient;
    private static List<Color> colorsGradient;
    public static final String COLOR_SCHEME_RED_CONTRAST = "Red Contrast";
    private static final int[] colorIdsGradientRedContrast;
    private static List<Color> colorsGradientRedContrast;
    public static final String COLOR_SCHEME_HIGH_CONTRAST = "High Contrast";
    private static final int[] colorIdsGradientHighContrast;
    private static List<Color> colorsGradientHighContrast;
    public static final String COLOR_SCHEME_PUBLICATION = "Publication";
    private static final RGB[] colorIdsGradientPublication;
    private static List<Color> colorsGradientPublication;
    public static final String COLOR_SCHEME_PRINT = "Print";
    private static final RGB[] colorIdsGradientPrint;
    private static List<Color> colorsGradientPrint;
    public static final String COLOR_SCHEME_UNLIMITED = "Unlimited";
    public static final int ALPHA_OPAQUE = 255;
    public static final int ALPHA_TRANSPARENT = 0;
    private static Map<Integer, Map<RGB, Color>> colorMap;

    static {
        int[] nArray = new int[7];
        nArray[0] = 255;
        nArray[2] = 45;
        nArray[3] = 85;
        nArray[4] = 125;
        nArray[5] = 165;
        nArray[6] = 205;
        colorIdsGradientRed = nArray;
        colorIdsGradient = new int[]{3, 2, 16, 6, 14, 8, 12, 10};
        int[] nArray2 = new int[4];
        nArray2[0] = 255;
        nArray2[2] = 85;
        nArray2[3] = 165;
        colorIdsGradientRedContrast = nArray2;
        colorIdsGradientHighContrast = new int[]{9, 13, 15, 11, 5, 2, 8, 3};
        colorIdsGradientPublication = new RGB[]{new RGB(255, 0, 0), new RGB(0, 255, 0), new RGB(0, 0, 255), new RGB(150, 0, 0), new RGB(0, 150, 0), new RGB(0, 0, 150)};
        colorIdsGradientPrint = new RGB[]{new RGB(0, 69, 134), new RGB(255, 66, 14), new RGB(255, 211, 32), new RGB(87, 157, 28), new RGB(126, 0, 33), new RGB(131, 202, 255), new RGB(49, 64, 4), new RGB(174, 207, 0), new RGB(75, 31, 111), new RGB(255, 149, 14)};
        Colors.initializeColors();
    }

    public static String[][] getAvailableColorSchemes() {
        String[][] elements = new String[7][2];
        elements[0][0] = COLOR_SCHEME_RED;
        elements[0][1] = COLOR_SCHEME_RED;
        elements[1][0] = COLOR_SCHEME_RED_CONTRAST;
        elements[1][1] = COLOR_SCHEME_RED_CONTRAST;
        elements[2][0] = COLOR_SCHEME_GRADIENT;
        elements[2][1] = COLOR_SCHEME_GRADIENT;
        elements[3][0] = COLOR_SCHEME_HIGH_CONTRAST;
        elements[3][1] = COLOR_SCHEME_HIGH_CONTRAST;
        elements[4][0] = COLOR_SCHEME_PUBLICATION;
        elements[4][1] = COLOR_SCHEME_PUBLICATION;
        elements[5][0] = COLOR_SCHEME_PRINT;
        elements[5][1] = COLOR_SCHEME_PRINT;
        elements[6][0] = COLOR_SCHEME_UNLIMITED;
        elements[6][1] = COLOR_SCHEME_UNLIMITED;
        return elements;
    }

    public static IColorScheme getColorScheme(String colorScheme) {
        if (COLOR_SCHEME_GRADIENT.equals(colorScheme)) {
            return new ColorScheme(colorsGradient);
        }
        if (COLOR_SCHEME_RED_CONTRAST.equals(colorScheme)) {
            return new ColorScheme(colorsGradientRedContrast);
        }
        if (COLOR_SCHEME_HIGH_CONTRAST.equals(colorScheme)) {
            return new ColorScheme(colorsGradientHighContrast);
        }
        if (COLOR_SCHEME_PUBLICATION.equals(colorScheme)) {
            return new ColorScheme(colorsGradientPublication);
        }
        if (COLOR_SCHEME_PRINT.equals(colorScheme)) {
            return new ColorScheme(colorsGradientPrint);
        }
        if (COLOR_SCHEME_UNLIMITED.equals(colorScheme)) {
            return new UnlimitedColorSchema();
        }
        return new ColorScheme(colorsGradientRed);
    }

    public static Color getColor(RGB rgb) {
        return Colors.getColor(rgb, 255);
    }

    public static Color getColor(RGB rgb, int alpha) {
        Color color;
        Map<RGB, Color> alphaColors = colorMap.get(alpha);
        if (alphaColors == null) {
            alphaColors = new HashMap<RGB, Color>();
            colorMap.put(alpha, alphaColors);
        }
        if ((color = alphaColors.get(rgb)) == null) {
            Display display = DisplayUtils.getDisplay();
            color = new Color((Device)display, rgb, alpha);
            alphaColors.put(rgb, color);
        }
        return color;
    }

    public static Color getColor(int red, int green, int blue) {
        return Colors.getColor(red, green, blue, 255);
    }

    public static Color getColor(int red, int green, int blue, int alpha) {
        RGB rgb = new RGB(red, green, blue);
        return Colors.getColor(rgb, alpha);
    }

    public static String getColor(Color color) {
        if (color != null) {
            return String.valueOf(color.getRed()) + "," + color.getGreen() + "," + color.getBlue();
        }
        return "255,255,255";
    }

    public static Color getColor(String rgb) {
        return Colors.getColor(rgb, 255);
    }

    public static Color getColor(int color) {
        return Colors.getColor(Colors.getColorRGB(color), 255);
    }

    public static Color getColor(String rgb, int alpha) {
        try {
            String[] values = rgb.split(",");
            int red = Integer.parseInt(values[0]);
            int green = Integer.parseInt(values[1]);
            int blue = Integer.parseInt(values[2]);
            return Colors.getColor(new RGB(red, green, blue), alpha);
        }
        catch (Exception e) {
            return WHITE;
        }
    }

    private static void initializeColors() {
        Color color;
        int colorId;
        Display display = DisplayUtils.getDisplay();
        colorMap = new HashMap<Integer, Map<RGB, Color>>();
        colorsGradientRed = new ArrayList<Color>();
        Object[] objectArray = colorIdsGradientRed;
        int n = colorIdsGradientRed.length;
        int n2 = 0;
        while (n2 < n) {
            colorId = objectArray[n2];
            color = Colors.getColor(colorId, 0, 0);
            colorsGradientRed.add(color);
            ++n2;
        }
        colorsGradient = new ArrayList<Color>();
        objectArray = colorIdsGradient;
        n = colorIdsGradient.length;
        n2 = 0;
        while (n2 < n) {
            colorId = objectArray[n2];
            color = display.getSystemColor(colorId);
            colorsGradient.add(color);
            ++n2;
        }
        colorsGradientRedContrast = new ArrayList<Color>();
        objectArray = colorIdsGradientRedContrast;
        n = colorIdsGradientRedContrast.length;
        n2 = 0;
        while (n2 < n) {
            colorId = objectArray[n2];
            color = Colors.getColor(colorId, 0, 0);
            colorsGradientRedContrast.add(color);
            ++n2;
        }
        colorsGradientHighContrast = new ArrayList<Color>();
        objectArray = colorIdsGradientHighContrast;
        n = colorIdsGradientHighContrast.length;
        n2 = 0;
        while (n2 < n) {
            colorId = objectArray[n2];
            color = display.getSystemColor(colorId);
            colorsGradientHighContrast.add(color);
            ++n2;
        }
        colorsGradientPublication = new ArrayList<Color>();
        objectArray = colorIdsGradientPublication;
        n = colorIdsGradientPublication.length;
        n2 = 0;
        while (n2 < n) {
            int rgb = objectArray[n2];
            color = Colors.getColor((RGB)rgb);
            colorsGradientPublication.add(color);
            ++n2;
        }
        colorsGradientPrint = new ArrayList<Color>();
        objectArray = colorIdsGradientPrint;
        n = colorIdsGradientPrint.length;
        n2 = 0;
        while (n2 < n) {
            int rgb = objectArray[n2];
            color = Colors.getColor((RGB)rgb);
            colorsGradientPrint.add(color);
            ++n2;
        }
    }

    public static int[] getColorRgba(int color) {
        int[] rgba = new int[4];
        int value = color;
        int r = value >> 16 & 0xFF;
        int g = value >> 8 & 0xFF;
        int b = value >> 0 & 0xFF;
        int alpha = value >> 24 & 0xFF;
        rgba[0] = r;
        rgba[1] = g;
        rgba[2] = b;
        rgba[3] = alpha;
        return rgba;
    }

    public static RGB getColorRGB(int color) {
        int[] rgba = Colors.getColorRgba(color);
        return new RGB(rgba[0], rgba[1], rgba[2]);
    }

    public static int getColorRgba(int r, int g, int b, double alpha) {
        int a = (int)(alpha * 255.0);
        int value = (a & 0xFF) << 24 | (r & 0xFF) << 16 | (g & 0xFF) << 8 | (b & 0xFF) << 0;
        return value;
    }

    public static String getColorRgbaHtml(int color) {
        int value = color;
        int r = value >> 16 & 0xFF;
        int g = value >> 8 & 0xFF;
        int b = value >> 0 & 0xFF;
        double alpha = (value >> 24 & 0xFF) / 255;
        return "rgba(" + r + " ," + g + ", " + b + ", " + alpha + ")";
    }

    public static String getColorRgbHtml(int color) {
        int value = color;
        int r = value >> 16 & 0xFF;
        int g = value >> 8 & 0xFF;
        int b = value >> 0 & 0xFF;
        return "rgb(" + r + " ," + g + ", " + b + ")";
    }
}

