/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.pcr.model.core;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.TreeSet;
import org.eclipse.chemclipse.model.core.AbstractMeasurementInfo;
import org.eclipse.chemclipse.pcr.model.core.IChannelSpecification;
import org.eclipse.chemclipse.pcr.model.core.IDetectionFormat;
import org.eclipse.chemclipse.pcr.model.core.IPlate;
import org.eclipse.chemclipse.pcr.model.core.IWell;

public class Plate
extends AbstractMeasurementInfo
implements IPlate {
    private static final long serialVersionUID = -7209280707411376156L;
    private String name = "";
    private IDetectionFormat detectionFormat = null;
    private List<IDetectionFormat> detectionFormats = new ArrayList<IDetectionFormat>();
    private TreeSet<IWell> wells = new TreeSet();

    @Override
    public List<String> getActiveChannels() {
        ArrayList<String> channels = new ArrayList<String>();
        if (this.detectionFormat != null) {
            for (IChannelSpecification channelSpecification : this.detectionFormat.getChannelSpecifications()) {
                channels.add(channelSpecification.getName());
            }
        }
        return channels;
    }

    @Override
    public void setActiveChannel(int activeChannel) {
        if (activeChannel < 0) {
            for (IWell well : this.wells) {
                well.clearActiveChannel();
            }
        } else {
            for (IWell well : this.wells) {
                well.setActiveChannel(activeChannel);
            }
        }
    }

    @Override
    public List<String> getSampleSubsets() {
        HashSet<String> subsets = new HashSet<String>();
        for (IWell well : this.wells) {
            subsets.add(well.getSampleSubset());
        }
        ArrayList<String> sampleSubsets = new ArrayList<String>(subsets);
        Collections.sort(sampleSubsets);
        if (sampleSubsets.size() == 0 || !((String)sampleSubsets.get(0)).equals("All Subsets")) {
            sampleSubsets.set(0, "All Subsets");
        }
        return sampleSubsets;
    }

    @Override
    public void setActiveSubset(String activeSubset) {
        activeSubset = "All Subsets".equals(activeSubset) ? "" : activeSubset;
        for (IWell well : this.wells) {
            well.setActiveSubset(activeSubset);
        }
    }

    @Override
    public IDetectionFormat getDetectionFormat() {
        return this.detectionFormat;
    }

    @Override
    public void setDetectionFormat(IDetectionFormat detectionFormat) {
        this.detectionFormat = detectionFormat;
        for (IWell well : this.wells) {
            well.applyDetectionFormat(detectionFormat);
        }
    }

    @Override
    public List<IDetectionFormat> getDetectionFormats() {
        return this.detectionFormats;
    }

    @Override
    public TreeSet<IWell> getWells() {
        return this.wells;
    }

    @Override
    public IWell getWell(int id) {
        for (IWell well : this.wells) {
            if (well.getPosition().getId() != id) continue;
            return well;
        }
        return null;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getName() {
        return this.name;
    }
}

