/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.msd.swt.ui.components.peak;

import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import org.eclipse.chemclipse.converter.exceptions.NoConverterAvailableException;
import org.eclipse.chemclipse.logging.core.Logger;
import org.eclipse.chemclipse.model.comparator.TargetExtendedComparator;
import org.eclipse.chemclipse.model.core.IPeaks;
import org.eclipse.chemclipse.model.identifier.IIdentificationTarget;
import org.eclipse.chemclipse.model.identifier.ILibraryInformation;
import org.eclipse.chemclipse.model.selection.IChromatogramSelection;
import org.eclipse.chemclipse.msd.model.core.IChromatogramMSD;
import org.eclipse.chemclipse.msd.model.core.IChromatogramPeakMSD;
import org.eclipse.chemclipse.msd.model.core.IPeakMSD;
import org.eclipse.chemclipse.msd.model.core.IPeakModelMSD;
import org.eclipse.chemclipse.msd.model.core.selection.ChromatogramSelectionMSD;
import org.eclipse.chemclipse.msd.model.core.selection.IChromatogramSelectionMSD;
import org.eclipse.chemclipse.msd.swt.ui.internal.provider.PeakCheckBoxEditingSupport;
import org.eclipse.chemclipse.msd.swt.ui.internal.provider.PeakListContentProvider;
import org.eclipse.chemclipse.msd.swt.ui.internal.provider.PeakListLabelProvider;
import org.eclipse.chemclipse.msd.swt.ui.internal.provider.PeakListTableComparator;
import org.eclipse.chemclipse.msd.swt.ui.support.DatabaseFileSupport;
import org.eclipse.chemclipse.rcp.ui.icons.core.ApplicationImageFactory;
import org.eclipse.chemclipse.support.comparator.SortOrder;
import org.eclipse.chemclipse.support.text.ValueFormat;
import org.eclipse.chemclipse.support.ui.swt.ExtendedTableViewer;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;

public class PeakListUI {
    private static final Logger logger = Logger.getLogger(PeakListUI.class);
    private IChromatogramSelection chromatogramSelection;
    private final DecimalFormat decimalFormat;
    private ExtendedTableViewer tableViewer;
    private Label labelSelectedPeak;
    private Label labelPeaks;
    private PeakListTableComparator peakListTableComparator;
    private static final String PEAK_IS_ACTIVE_FOR_ANALYSIS = "Active for Analysis";
    private final String[] titles = new String[]{"Active for Analysis", "RT (min)", "RI", "Area", "Start RT", "Stop RT", "Width", "Scan# at Peak Maximum", "S/N", "Leading", "Tailing", "Model Description", "Suggested Components", "Name"};
    private final int[] bounds = new int[]{30, 100, 60, 100, 100, 100, 100, 100, 100, 100, 100, 100, 100, 100};
    private final TargetExtendedComparator targetExtendedComparator;

    public PeakListUI(Composite parent, int style) {
        this.decimalFormat = ValueFormat.getDecimalFormatEnglish();
        this.targetExtendedComparator = new TargetExtendedComparator(SortOrder.DESC);
        this.initialize(parent);
    }

    public void setChromatogramSelection(IChromatogramSelection chromatogramSelection) {
        this.chromatogramSelection = chromatogramSelection;
    }

    public void setFocus() {
        this.tableViewer.getControl().setFocus();
    }

    public void update(IPeaks<?> peaks, boolean forceReload) {
        if (peaks != null) {
            if (this.chromatogramSelection != null && this.chromatogramSelection.getChromatogram() != null) {
                this.labelPeaks.setText(String.valueOf(this.chromatogramSelection.getChromatogram().getNumberOfPeaks()) + " chromatogram peaks - " + peaks.size() + " displayed peaks");
            } else {
                this.labelPeaks.setText(String.valueOf(peaks.size()) + " displayed peaks");
            }
            this.tableViewer.setInput(peaks);
        } else {
            this.clear();
        }
    }

    public void setLabelSelectedPeak(IChromatogramPeakMSD selectedPeakMSD) {
        if (selectedPeakMSD != null && selectedPeakMSD.getPeakModel() != null) {
            IPeakModelMSD peakModel = selectedPeakMSD.getPeakModel();
            String name = this.getName(selectedPeakMSD.getTargets());
            this.labelSelectedPeak.setText("Selected Peak: " + this.decimalFormat.format((double)peakModel.getRetentionTimeAtPeakMaximum() / 60000.0) + " min - Name: " + name);
        } else {
            this.labelSelectedPeak.setText("Selected Peak: none selected yet");
        }
    }

    public void clear() {
        this.labelSelectedPeak.setText("");
        this.labelPeaks.setText("");
        this.tableViewer.setInput(null);
    }

    public ExtendedTableViewer getTableViewer() {
        return this.tableViewer;
    }

    public String[] getTitles() {
        return this.titles;
    }

    public void deleteSelectedPeaks(IChromatogramSelectionMSD chromatogramSelection) {
        if (chromatogramSelection != null) {
            Table table = this.tableViewer.getTable();
            int[] indices = table.getSelectionIndices();
            List<IPeakMSD> peaksToDelete = this.getPeakList(table, indices);
            ArrayList<IChromatogramPeakMSD> chromatogramPeaksToDelete = new ArrayList<IChromatogramPeakMSD>();
            for (IPeakMSD peakMSD : peaksToDelete) {
                if (!(peakMSD instanceof IChromatogramPeakMSD)) continue;
                chromatogramPeaksToDelete.add((IChromatogramPeakMSD)peakMSD);
            }
            table.remove(indices);
            IChromatogramMSD chromatogram = chromatogramSelection.getChromatogramMSD();
            chromatogram.removePeaks(chromatogramPeaksToDelete);
            if (chromatogramSelection instanceof ChromatogramSelectionMSD) {
                ChromatogramSelectionMSD chromSelection = (ChromatogramSelectionMSD)chromatogramSelection;
                List peaks = chromatogram.getPeaks();
                if (peaks.size() > 0) {
                    chromSelection.setSelectedPeak((IChromatogramPeakMSD)peaks.get(0));
                }
                chromSelection.update(true);
            }
        }
    }

    public void setActiveStatusSelectedPeaks(IChromatogramSelectionMSD chromatogramSelection, boolean activeForAnalysis) {
        Table table = this.tableViewer.getTable();
        int[] indices = table.getSelectionIndices();
        List<IPeakMSD> peaks = this.getPeakList(table, indices);
        for (IPeakMSD peak : peaks) {
            peak.setActiveForAnalysis(activeForAnalysis);
        }
        this.tableViewer.refresh();
        chromatogramSelection.update(true);
    }

    public void exportSelectedPeaks(IChromatogramSelectionMSD chromatogramSelection) {
        try {
            Table table = this.tableViewer.getTable();
            int[] indices = table.getSelectionIndices();
            List<IPeakMSD> peaks = this.getPeakList(table, indices);
            DatabaseFileSupport.saveMassSpectra(peaks);
        }
        catch (NoConverterAvailableException e1) {
            logger.warn((Object)e1);
        }
    }

    private void initialize(Composite parent) {
        parent.setLayout((Layout)new FillLayout());
        Composite composite = new Composite(parent, 4);
        GridLayout layout = new GridLayout();
        layout.makeColumnsEqualWidth = true;
        layout.numColumns = 1;
        composite.setLayout((Layout)layout);
        this.createButtons(composite);
        this.createTable(composite);
        this.createInfos(composite);
    }

    private void createButtons(Composite composite) {
        Composite compositeButtons = new Composite(composite, 0);
        GridData gridDataComposite = new GridData(768);
        gridDataComposite.horizontalAlignment = 0x1000008;
        compositeButtons.setLayoutData((Object)gridDataComposite);
        compositeButtons.setLayout((Layout)new GridLayout(3, false));
        this.createUncheckAllButton(compositeButtons);
        this.createCheckAllButton(compositeButtons);
        this.createSaveButton(compositeButtons);
    }

    private void createUncheckAllButton(Composite parent) {
        Button button = new Button(parent, 8);
        button.setToolTipText("Uncheck the selected peaks.");
        button.setImage(ApplicationImageFactory.getInstance().getImage("org.eclipse.chemclipse.rcp.ui.icons/uncheckAll.gif", "16x16"));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PeakListUI.this.setActiveForAnalysis(false);
            }
        });
    }

    private void createCheckAllButton(Composite parent) {
        Button button = new Button(parent, 8);
        button.setToolTipText("Check the selected peaks.");
        button.setImage(ApplicationImageFactory.getInstance().getImage("org.eclipse.chemclipse.rcp.ui.icons/checkAll.gif", "16x16"));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PeakListUI.this.setActiveForAnalysis(true);
            }
        });
    }

    private void createSaveButton(Composite parent) {
        Button button = new Button(parent, 8);
        button.setToolTipText("Save the peaks");
        button.setImage(ApplicationImageFactory.getInstance().getImage("org.eclipse.chemclipse.rcp.ui.icons/saveas.gif", "16x16"));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                try {
                    List peaks = PeakListUI.this.getPeakList();
                    DatabaseFileSupport.saveMassSpectra(peaks);
                }
                catch (NoConverterAvailableException e1) {
                    logger.warn((Object)e1);
                }
            }
        });
    }

    private void createTable(Composite composite) {
        this.tableViewer = new ExtendedTableViewer(composite, 68354);
        this.tableViewer.getTable().setLayoutData((Object)new GridData(1808));
        this.tableViewer.createColumns(this.titles, this.bounds);
        this.tableViewer.setContentProvider((IContentProvider)new PeakListContentProvider());
        this.tableViewer.setLabelProvider((IBaseLabelProvider)new PeakListLabelProvider());
        this.peakListTableComparator = new PeakListTableComparator();
        this.tableViewer.setComparator((ViewerComparator)this.peakListTableComparator);
        this.setEditingSupport();
    }

    private void createInfos(Composite composite) {
        this.labelSelectedPeak = new Label(composite, 0);
        this.labelSelectedPeak.setText("");
        this.labelSelectedPeak.setLayoutData((Object)new GridData(768));
        this.labelPeaks = new Label(composite, 0);
        this.labelPeaks.setText("");
        this.labelPeaks.setLayoutData((Object)new GridData(768));
    }

    private void setActiveForAnalysis(boolean activeForAnalysis) {
        List<IPeakMSD> peaks = this.getPeakList();
        for (IPeakMSD peak : peaks) {
            peak.setActiveForAnalysis(activeForAnalysis);
        }
        this.tableViewer.refresh();
        this.chromatogramSelection.update(true);
    }

    private List<IPeakMSD> getPeakList() {
        ArrayList<IPeakMSD> peakList = new ArrayList<IPeakMSD>();
        Table table = this.tableViewer.getTable();
        TableItem[] tableItemArray = table.getItems();
        int n = tableItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TableItem tableItem = tableItemArray[n2];
            Object object = tableItem.getData();
            if (object instanceof IPeakMSD) {
                IPeakMSD peak = (IPeakMSD)object;
                peakList.add(peak);
            }
            ++n2;
        }
        return peakList;
    }

    private List<IPeakMSD> getPeakList(Table table, int[] indices) {
        ArrayList<IPeakMSD> peakList = new ArrayList<IPeakMSD>();
        int[] nArray = indices;
        int n = indices.length;
        int n2 = 0;
        while (n2 < n) {
            int index = nArray[n2];
            TableItem tableItem = table.getItem(index);
            Object object = tableItem.getData();
            if (object instanceof IPeakMSD) {
                IPeakMSD peak = (IPeakMSD)object;
                peakList.add(peak);
            }
            ++n2;
        }
        return peakList;
    }

    private void setEditingSupport() {
        ExtendedTableViewer tableViewer = this.getTableViewer();
        List tableViewerColumns = this.tableViewer.getTableViewerColumns();
        int i = 0;
        while (i < tableViewerColumns.size()) {
            TableViewerColumn tableViewerColumn = (TableViewerColumn)tableViewerColumns.get(i);
            String label = tableViewerColumn.getColumn().getText();
            if (label.equals(PEAK_IS_ACTIVE_FOR_ANALYSIS)) {
                tableViewerColumn.setEditingSupport((EditingSupport)new PeakCheckBoxEditingSupport((TableViewer)tableViewer));
            }
            ++i;
        }
    }

    private String getName(Set<IIdentificationTarget> targets) {
        ILibraryInformation libraryInformation = IIdentificationTarget.getBestLibraryInformation(targets, (Comparator)this.targetExtendedComparator);
        if (libraryInformation != null) {
            return libraryInformation.getName();
        }
        return "Peak is not identified yet.";
    }
}

