/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.msd.identifier.supplier.nist.internal.results;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.chemclipse.logging.core.Logger;
import org.eclipse.chemclipse.msd.identifier.supplier.nist.internal.results.Compound;
import org.eclipse.chemclipse.msd.identifier.supplier.nist.internal.results.Compounds;
import org.eclipse.chemclipse.msd.identifier.supplier.nist.internal.results.Hit;

public class NistResultFileParser {
    private static final Logger logger = Logger.getLogger(NistResultFileParser.class);
    private static final String DELIMITER = "\n";
    private static final String COMPOUND_PATTERN = "(Unknown:.*)(Compound in Library Factor)( = )(.*?\\n)((Hit.*\\n)*)";
    private static final String IDENTIFIER_PATTERN = "(Unknown:)(\\s*)(.*)(\\s*)";
    private static final String HIT_PATTERN = "(Hit.*?)(\\n)";
    private static final String NAME_FORMULA_PATTERN = "(<<)(.*?)(>>;<<)(.*?)(>>)";
    private static final String MATCH_FACTOR_PATTERN = "(MF:\\s*)(.*?)(;\\s*RMF:\\s*)(.*?)(;\\s*Prob:\\s*)(.*?)(;)";
    private static final String CAS_PATTERN = "(CAS:\\s*)(.*?)(;)";
    private static final String LIB_PATTERN = "(Mw:\\s*)(.*)(;\\s*Lib:.*<<)(.*)(>>;\\s*Id:\\s*)(.*)(\\.)";
    private static final String DEFAULT_ID = "-1";
    private static final String DEFAULT_RI = "0";
    private static final String RI_MARKER = "; RI:";
    private Pattern compoundPattern = Pattern.compile("(Unknown:.*)(Compound in Library Factor)( = )(.*?\\n)((Hit.*\\n)*)");
    private Pattern identifierPattern = Pattern.compile("(Unknown:)(\\s*)(.*)(\\s*)");
    private Pattern hitPattern = Pattern.compile("(Hit.*?)(\\n)");
    private Pattern nameFormulaPattern = Pattern.compile("(<<)(.*?)(>>;<<)(.*?)(>>)");
    private Pattern matchFactorPattern = Pattern.compile("(MF:\\s*)(.*?)(;\\s*RMF:\\s*)(.*?)(;\\s*Prob:\\s*)(.*?)(;)");
    private Pattern casPattern = Pattern.compile("(CAS:\\s*)(.*?)(;)");
    private Pattern libPattern = Pattern.compile("(Mw:\\s*)(.*)(;\\s*Lib:.*<<)(.*)(>>;\\s*Id:\\s*)(.*)(\\.)");

    public Compounds getCompounds(File results) {
        String content = this.getResultFileContent(results);
        return this.extractCompounds(content);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String getResultFileContent(File results) {
        String content = "";
        BufferedReader reader = null;
        try {
            try {
                String line;
                reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(results), "ISO8859_1"));
                StringBuilder builder = new StringBuilder();
                while ((line = reader.readLine()) != null) {
                    builder.append(line);
                    builder.append(DELIMITER);
                }
                content = builder.toString();
                return content;
            }
            catch (FileNotFoundException e) {
                logger.warn((Object)e);
                if (reader == null) return content;
                try {
                    reader.close();
                    return content;
                }
                catch (IOException e2) {
                    logger.warn((Object)e2);
                }
                return content;
            }
            catch (IOException e) {
                logger.warn((Object)e);
                if (reader == null) return content;
                try {
                    reader.close();
                    return content;
                }
                catch (IOException e3) {
                    logger.warn((Object)e3);
                }
                return content;
            }
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException e) {
                    logger.warn((Object)e);
                }
            }
        }
    }

    private Compounds extractCompounds(String input) {
        Compounds compounds = new Compounds();
        Matcher matcher = this.compoundPattern.matcher(input);
        while (matcher.find()) {
            Compound compound = new Compound();
            this.extractAndAddIdentifier(matcher.group(1), compound);
            this.extractAndAddInLibFactor(matcher.group(4), compound);
            this.extractAndAddHits(matcher.group(5), compound);
            compounds.add(compound);
        }
        return compounds;
    }

    private void extractAndAddIdentifier(String input, Compound compound) {
        Matcher matcher = this.identifierPattern.matcher(input);
        while (matcher.find()) {
            String identifier = matcher.group(3).trim();
            compound.setIdentifier(identifier);
        }
    }

    private void extractAndAddInLibFactor(String input, Compound compound) {
        if (input != null) {
            compound.setCompoundInLibraryFactor(input.replace(DELIMITER, ""));
        }
    }

    private void extractAndAddHits(String input, Compound compound) {
        Matcher matcher = this.hitPattern.matcher(input);
        while (matcher.find()) {
            Hit hit = this.extractHit(matcher.group(1));
            compound.add(hit);
        }
    }

    private Hit extractHit(String input) {
        Hit hit = new Hit();
        this.addNameAndFormula(input, hit);
        this.addMatchFactor(input, hit);
        this.addCAS(input, hit);
        this.addLib(input, hit);
        return hit;
    }

    private void addNameAndFormula(String input, Hit hit) {
        Matcher matcher = this.nameFormulaPattern.matcher(input);
        if (matcher.find()) {
            hit.setName(matcher.group(2));
            hit.setFormula(matcher.group(4));
        }
    }

    private void addMatchFactor(String input, Hit hit) {
        Matcher matcher = this.matchFactorPattern.matcher(input);
        if (matcher.find()) {
            hit.setMatchFactor((float)Integer.valueOf(matcher.group(2)).intValue() / 10.0f);
            hit.setReverseMatchFactor((float)Integer.valueOf(matcher.group(4)).intValue() / 10.0f);
            hit.setProbability(Float.valueOf(matcher.group(6)).floatValue());
        }
    }

    private void addCAS(String input, Hit hit) {
        Matcher matcher = this.casPattern.matcher(input);
        if (matcher.find()) {
            hit.setCAS(matcher.group(2));
        }
    }

    private void addLib(String input, Hit hit) {
        Matcher matcher = this.libPattern.matcher(input);
        if (matcher.find()) {
            hit.setMolecularWeight(Integer.valueOf(matcher.group(2)));
            hit.setLib(matcher.group(4));
            String value = matcher.group(6);
            String id = DEFAULT_ID;
            String ri = DEFAULT_RI;
            if (value.contains(RI_MARKER)) {
                String[] values = value.split(RI_MARKER);
                id = values.length > 0 ? values[0].trim() : DEFAULT_ID;
                ri = values.length > 1 ? values[1].trim() : DEFAULT_RI;
            } else {
                id = value;
            }
            try {
                hit.setId(Integer.valueOf(id));
            }
            catch (NumberFormatException e) {
                logger.warn((Object)e);
            }
            try {
                hit.setRetentionIndex(Integer.valueOf(ri));
            }
            catch (NumberFormatException e) {
                logger.warn((Object)e);
            }
        }
    }
}

