/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.msd.converter.io;

import org.eclipse.chemclipse.converter.io.AbstractFileHelper;
import org.eclipse.chemclipse.logging.core.Logger;
import org.eclipse.chemclipse.model.core.RetentionIndexType;
import org.eclipse.chemclipse.model.identifier.ILibraryInformation;
import org.eclipse.chemclipse.model.support.LibraryInformationSupport;
import org.eclipse.chemclipse.msd.converter.io.IMassSpectraReader;
import org.eclipse.chemclipse.msd.model.core.IRegularLibraryMassSpectrum;

public abstract class AbstractMassSpectraReader
extends AbstractFileHelper
implements IMassSpectraReader {
    private static final Logger logger = Logger.getLogger(AbstractMassSpectraReader.class);
    private LibraryInformationSupport libraryInformationSupport = new LibraryInformationSupport();

    @Override
    public void extractNameAndReferenceIdentifier(IRegularLibraryMassSpectrum massSpectrum, String value, String referenceIdentifierMarker, String referenceIdentifierPrefix) {
        ILibraryInformation libraryInformation = massSpectrum.getLibraryInformation();
        this.libraryInformationSupport.extractNameAndReferenceIdentifier(value, libraryInformation, referenceIdentifierMarker, referenceIdentifierPrefix);
    }

    @Override
    public void extractRetentionIndices(IRegularLibraryMassSpectrum massSpectrum, String value, String delimiter) {
        if (value != null && delimiter != null) {
            String[] values;
            boolean setRetentionIndexTraditionally = true;
            if (value.contains(delimiter) && (values = value.split(", ")).length >= 2) {
                setRetentionIndexTraditionally = false;
                float retentionIndex = this.parseFloat(values[0]);
                massSpectrum.setRetentionIndex(retentionIndex);
                massSpectrum.setRetentionIndex(RetentionIndexType.APOLAR, retentionIndex);
                massSpectrum.setRetentionIndex(RetentionIndexType.POLAR, this.parseFloat(values[1]));
            }
            if (setRetentionIndexTraditionally) {
                massSpectrum.setRetentionIndex(this.parseFloat(value));
            }
        }
    }

    private float parseFloat(String value) {
        float result = 0.0f;
        try {
            result = Float.parseFloat(value.trim());
        }
        catch (Exception e) {
            logger.warn((Object)e);
        }
        return result;
    }
}

