/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.msd.converter.database;

import java.io.File;
import org.eclipse.chemclipse.converter.core.AbstractExportConverter;
import org.eclipse.chemclipse.msd.converter.database.IDatabaseExportConverter;
import org.eclipse.chemclipse.msd.model.core.IMassSpectra;
import org.eclipse.chemclipse.msd.model.core.IScanMSD;
import org.eclipse.chemclipse.processing.core.IProcessingInfo;
import org.eclipse.chemclipse.processing.core.IProcessingMessage;
import org.eclipse.chemclipse.processing.core.MessageType;
import org.eclipse.chemclipse.processing.core.ProcessingInfo;
import org.eclipse.chemclipse.processing.core.ProcessingMessage;

public abstract class AbstractDatabaseExportConverter
extends AbstractExportConverter
implements IDatabaseExportConverter {
    @Override
    public IProcessingInfo<File> validate(IScanMSD massSpectrum) {
        ProcessingInfo processingInfo = new ProcessingInfo();
        if (massSpectrum == null) {
            ProcessingMessage processingMessage = new ProcessingMessage(MessageType.ERROR, "Database Export", "The is no mass spectrum to export.");
            processingInfo.addMessage((IProcessingMessage)processingMessage);
        }
        return processingInfo;
    }

    @Override
    public IProcessingInfo<File> validate(IMassSpectra massSpectra) {
        ProcessingInfo processingInfo = new ProcessingInfo();
        if (massSpectra == null) {
            ProcessingMessage processingMessage = new ProcessingMessage(MessageType.ERROR, "Database Export", "The are no mass spectra to export.");
            processingInfo.addMessage((IProcessingMessage)processingMessage);
        }
        return processingInfo;
    }
}

