/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.msd.converter.supplier.mzml.converter;

import java.io.File;
import org.eclipse.chemclipse.converter.chromatogram.AbstractChromatogramImportConverter;
import org.eclipse.chemclipse.logging.core.Logger;
import org.eclipse.chemclipse.model.core.IChromatogramOverview;
import org.eclipse.chemclipse.msd.converter.supplier.mzml.converter.io.ChromatogramReader;
import org.eclipse.chemclipse.msd.converter.supplier.mzml.internal.converter.SpecificationValidator;
import org.eclipse.chemclipse.msd.model.core.IChromatogramMSD;
import org.eclipse.chemclipse.processing.core.IProcessingInfo;
import org.eclipse.core.runtime.IProgressMonitor;

public class ChromatogramImportConverter
extends AbstractChromatogramImportConverter<IChromatogramMSD> {
    private static final Logger logger = Logger.getLogger(ChromatogramImportConverter.class);
    private static final String DESCRIPTION = "mzML Import Converter";

    public IProcessingInfo<IChromatogramMSD> convert(File file, IProgressMonitor monitor) {
        IProcessingInfo processingInfo = super.validate(file);
        if (!processingInfo.hasErrorMessages()) {
            file = SpecificationValidator.validateSpecification(file);
            ChromatogramReader reader = new ChromatogramReader();
            monitor.subTask("Import mzML Chromatogram");
            try {
                IChromatogramMSD chromatogram = reader.read(file, monitor);
                processingInfo.setProcessingResult((Object)chromatogram);
            }
            catch (Exception e) {
                logger.warn((Object)e);
                processingInfo.addErrorMessage(DESCRIPTION, "Something has definitely gone wrong with the file: " + file.getAbsolutePath());
            }
        }
        return processingInfo;
    }

    public IProcessingInfo<IChromatogramOverview> convertOverview(File file, IProgressMonitor monitor) {
        IProcessingInfo processingInfo = super.validate(file);
        if (!processingInfo.hasErrorMessages()) {
            file = SpecificationValidator.validateSpecification(file);
            ChromatogramReader reader = new ChromatogramReader();
            monitor.subTask("Import mzML Chromatogram Overview");
            try {
                IChromatogramOverview chromatogramOverview = reader.readOverview(file, monitor);
                processingInfo.setProcessingResult((Object)chromatogramOverview);
            }
            catch (Exception e) {
                logger.warn((Object)e);
                processingInfo.addErrorMessage(DESCRIPTION, "Something has definitely gone wrong with the file: " + file.getAbsolutePath());
            }
        }
        return processingInfo;
    }
}

