/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.msd.converter.supplier.excel.io;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFDataFormat;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.eclipse.chemclipse.converter.exceptions.FileIsNotWriteableException;
import org.eclipse.chemclipse.converter.io.AbstractChromatogramWriter;
import org.eclipse.chemclipse.logging.core.Logger;
import org.eclipse.chemclipse.model.exceptions.ChromatogramIsNullException;
import org.eclipse.chemclipse.msd.converter.io.IChromatogramMSDWriter;
import org.eclipse.chemclipse.msd.converter.supplier.excel.internal.io.SpreadsheetWriter;
import org.eclipse.chemclipse.msd.converter.supplier.excel.internal.support.PathHelper;
import org.eclipse.chemclipse.msd.model.core.IChromatogramMSD;
import org.eclipse.chemclipse.msd.model.xic.ExtractedIonSignalExtractor;
import org.eclipse.chemclipse.msd.model.xic.IExtractedIonSignal;
import org.eclipse.chemclipse.msd.model.xic.IExtractedIonSignals;
import org.eclipse.core.runtime.IProgressMonitor;

public class ChromatogramWriter
extends AbstractChromatogramWriter
implements IChromatogramMSDWriter {
    private static final Logger logger = Logger.getLogger(ChromatogramWriter.class);
    public static final String RT_MILLISECONDS_COLUMN = "RT(milliseconds)";
    public static final String RT_MINUTES_COLUMN = "RT(minutes)";
    public static final String RI_COLUMN = "RI";
    private static final String XML_ENCODING = "UTF-8";
    private static final String ABUNDANCE_STYLE = "abundance";

    public void writeChromatogram(File file, IChromatogramMSD chromatogram, IProgressMonitor monitor) throws FileNotFoundException, FileIsNotWriteableException, IOException {
        XSSFWorkbook excelWorkbook = new XSSFWorkbook();
        XSSFSheet excelSheet = excelWorkbook.createSheet(chromatogram.getName());
        Map<String, XSSFCellStyle> styles = this.createStyles(excelWorkbook);
        String excelSheetReferenceName = excelSheet.getPackagePart().getPartName().getName();
        File excelTemplate = new File(PathHelper.getStoragePath() + File.separator + "exceltemplace.xlsx");
        FileOutputStream outputStream = new FileOutputStream(excelTemplate);
        excelWorkbook.write((OutputStream)outputStream);
        outputStream.close();
        File xmlDataFile = new File(PathHelper.getStoragePath() + File.separator + "datafile.xml");
        OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(xmlDataFile), XML_ENCODING);
        try {
            this.writeChromatogram(writer, styles, chromatogram, monitor);
        }
        catch (Exception e) {
            throw new IOException("There has something gone wrong writing the temporary data file.");
        }
        ((Writer)writer).close();
        FileOutputStream resultOutputStream = new FileOutputStream(file);
        this.mergeTemplateAndData(excelTemplate, xmlDataFile, excelSheetReferenceName.substring(1), resultOutputStream);
        resultOutputStream.close();
        excelTemplate.delete();
        xmlDataFile.delete();
    }

    private Map<String, XSSFCellStyle> createStyles(XSSFWorkbook excelWorkbook) {
        HashMap<String, XSSFCellStyle> styles = new HashMap<String, XSSFCellStyle>();
        XSSFDataFormat dataFormat = excelWorkbook.createDataFormat();
        XSSFCellStyle style1 = excelWorkbook.createCellStyle();
        style1.setAlignment((short)2);
        style1.setDataFormat(dataFormat.getFormat("0.000"));
        styles.put(ABUNDANCE_STYLE, style1);
        return styles;
    }

    private void writeChromatogram(Writer writer, Map<String, XSSFCellStyle> styles, IChromatogramMSD chromatogram, IProgressMonitor monitor) throws IOException {
        SpreadsheetWriter spreadsheetWriter = new SpreadsheetWriter(writer, XML_ENCODING);
        spreadsheetWriter.beginSheet();
        try {
            ExtractedIonSignalExtractor extractedIonSignalExtractor = new ExtractedIonSignalExtractor(chromatogram);
            IExtractedIonSignals extractedIonSignals = extractedIonSignalExtractor.getExtractedIonSignals();
            int startIon = extractedIonSignals.getStartIon();
            int stopIon = extractedIonSignals.getStopIon();
            int rownumber = this.writeHeader(spreadsheetWriter, 0, startIon, stopIon, monitor);
            this.writeScans(extractedIonSignals, spreadsheetWriter, styles, rownumber, startIon, stopIon, monitor);
        }
        catch (ChromatogramIsNullException e) {
            logger.warn((Object)e);
        }
        spreadsheetWriter.endSheet();
    }

    private int writeHeader(SpreadsheetWriter spreadsheetWriter, int rowNumber, int startIon, int stopIon, IProgressMonitor monitor) throws IOException {
        monitor.subTask("Write Header");
        int columnNumber = 0;
        spreadsheetWriter.insertRow(rowNumber++);
        spreadsheetWriter.createCell(columnNumber++, RT_MILLISECONDS_COLUMN);
        spreadsheetWriter.createCell(columnNumber++, RT_MINUTES_COLUMN);
        spreadsheetWriter.createCell(columnNumber++, RI_COLUMN);
        int ion = startIon;
        while (ion <= stopIon) {
            spreadsheetWriter.createCell(columnNumber++, ion);
            ++ion;
        }
        spreadsheetWriter.endRow();
        return rowNumber;
    }

    private void writeScans(IExtractedIonSignals extractedIonSignals, SpreadsheetWriter spreadsheetWriter, Map<String, XSSFCellStyle> styles, int rowNumber, int startIon, int stopIon, IProgressMonitor monitor) throws IOException {
        short styleAbundance = styles.get(ABUNDANCE_STYLE).getIndex();
        for (IExtractedIonSignal extractedIonSignal : extractedIonSignals.getExtractedIonSignals()) {
            monitor.subTask("Write Scan " + rowNumber);
            int columnNumber = 0;
            spreadsheetWriter.insertRow(rowNumber++);
            int milliseconds = extractedIonSignal.getRetentionTime();
            spreadsheetWriter.createCell(columnNumber++, milliseconds);
            spreadsheetWriter.createCell(columnNumber++, (double)milliseconds / 60000.0);
            spreadsheetWriter.createCell(columnNumber++, extractedIonSignal.getRetentionIndex());
            int ion = startIon;
            while (ion <= stopIon) {
                spreadsheetWriter.createCell(columnNumber++, extractedIonSignal.getAbundance(ion), (int)styleAbundance);
                ++ion;
            }
            spreadsheetWriter.endRow();
        }
    }

    private void mergeTemplateAndData(File excelTemplate, File xmlDataFile, String excelSheetReferenceName, OutputStream outputStream) throws IOException {
        InputStream inputStream;
        ZipFile zipFile = new ZipFile(excelTemplate);
        ZipOutputStream zipOutputStream = new ZipOutputStream(outputStream);
        Enumeration<? extends ZipEntry> zipEntries = zipFile.entries();
        while (zipEntries.hasMoreElements()) {
            ZipEntry zipEntry = zipEntries.nextElement();
            if (zipEntry.getName().equals(excelSheetReferenceName)) continue;
            zipOutputStream.putNextEntry(new ZipEntry(zipEntry.getName()));
            inputStream = zipFile.getInputStream(zipEntry);
            this.copyDataStream(inputStream, zipOutputStream);
            inputStream.close();
        }
        zipOutputStream.putNextEntry(new ZipEntry(excelSheetReferenceName));
        inputStream = new FileInputStream(xmlDataFile);
        this.copyDataStream(inputStream, zipOutputStream);
        inputStream.close();
        zipOutputStream.close();
        zipFile.close();
    }

    private void copyDataStream(InputStream inputStream, OutputStream outputStream) throws IOException {
        int count;
        byte[] chunk = new byte[1024];
        while ((count = inputStream.read(chunk)) >= 0) {
            outputStream.write(chunk, 0, count);
        }
    }
}

