/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.msd.converter.supplier.csv.io.core;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.text.DecimalFormat;
import java.util.Comparator;
import java.util.Set;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVPrinter;
import org.eclipse.chemclipse.converter.exceptions.FileIsNotWriteableException;
import org.eclipse.chemclipse.logging.core.Logger;
import org.eclipse.chemclipse.model.comparator.TargetExtendedComparator;
import org.eclipse.chemclipse.model.identifier.IIdentificationTarget;
import org.eclipse.chemclipse.model.identifier.ILibraryInformation;
import org.eclipse.chemclipse.msd.converter.io.IMassSpectraWriter;
import org.eclipse.chemclipse.msd.model.core.IMassSpectra;
import org.eclipse.chemclipse.msd.model.core.IRegularLibraryMassSpectrum;
import org.eclipse.chemclipse.msd.model.core.IScanMSD;
import org.eclipse.chemclipse.msd.model.implementation.MassSpectra;
import org.eclipse.chemclipse.support.comparator.SortOrder;
import org.eclipse.chemclipse.support.text.ValueFormat;
import org.eclipse.core.runtime.IProgressMonitor;

public class MassSpectrumExtendedWriter
implements IMassSpectraWriter {
    private static final Logger logger = Logger.getLogger(MassSpectrumExtendedWriter.class);
    private DecimalFormat decimalFormat = ValueFormat.getDecimalFormatEnglish();
    private TargetExtendedComparator targetExtendedComparator = new TargetExtendedComparator(SortOrder.DESC);

    public void writeMassSpectrum(FileWriter fileWriter, IScanMSD massSpectrum, IProgressMonitor monitor) throws IOException {
        MassSpectra massSpectra = new MassSpectra();
        massSpectra.addMassSpectrum(massSpectrum);
        this.writeMassSpectrumToCsv((IMassSpectra)massSpectra, fileWriter);
    }

    public void write(File file, IScanMSD massSpectrum, boolean append, IProgressMonitor monitor) throws FileNotFoundException, FileIsNotWriteableException, IOException {
        FileWriter fileWriter = new FileWriter(file, append);
        MassSpectra massSpectra = new MassSpectra();
        massSpectra.addMassSpectrum(massSpectrum);
        this.writeMassSpectrumToCsv((IMassSpectra)massSpectra, fileWriter);
    }

    public void write(File file, IMassSpectra massSpectra, boolean append, IProgressMonitor monitor) throws FileNotFoundException, FileIsNotWriteableException, IOException {
        FileWriter fileWriter = new FileWriter(file, append);
        this.writeMassSpectrumToCsv(massSpectra, fileWriter);
    }

    private void writeMassSpectrumToCsv(IMassSpectra massSpectra, FileWriter fileWriter) throws IOException {
        if (massSpectra != null) {
            try (CSVPrinter csvFilePrinter = null;){
                csvFilePrinter = new CSVPrinter((Appendable)fileWriter, CSVFormat.EXCEL);
                csvFilePrinter.printRecord(new Object[]{"Retention Time", "Retention Index", "Base Peak", "Base Peak Abundance", "Number of Ions", "Name", "CAS", "MW", "Formula", "Reference Identifier"});
                for (IScanMSD massSpectrum : massSpectra.getList()) {
                    IScanMSD massSpectrumExport;
                    ILibraryInformation libraryInformation = null;
                    if (massSpectrum instanceof IRegularLibraryMassSpectrum) {
                        IRegularLibraryMassSpectrum libraryMassSpectrum = (IRegularLibraryMassSpectrum)massSpectrum;
                        libraryInformation = libraryMassSpectrum.getLibraryInformation();
                    } else {
                        libraryInformation = IIdentificationTarget.getBestLibraryInformation((Set)massSpectrum.getTargets(), (Comparator)this.targetExtendedComparator);
                    }
                    try {
                        massSpectrumExport = massSpectrum.makeDeepCopy();
                        massSpectrumExport.normalize(1000.0f);
                    }
                    catch (CloneNotSupportedException e) {
                        logger.warn((Object)e);
                        massSpectrumExport = massSpectrum;
                    }
                    int retentionIndexNoPrecision = (int)massSpectrum.getRetentionIndex();
                    int basePeakNoPrecision = (int)massSpectrum.getBasePeak();
                    int basePeakAbundanceNoPrecision = (int)massSpectrum.getBasePeakAbundance();
                    String retentionTime = massSpectrum.getRetentionTime() == 0 ? "0" : this.decimalFormat.format((double)massSpectrum.getRetentionTime() / 60000.0);
                    String retentionIndex = (float)retentionIndexNoPrecision == massSpectrum.getRetentionIndex() ? Integer.toString(retentionIndexNoPrecision) : this.decimalFormat.format(massSpectrum.getRetentionIndex());
                    String basePeak = (double)basePeakNoPrecision == massSpectrum.getBasePeak() ? Integer.toString(basePeakNoPrecision) : this.decimalFormat.format(massSpectrum.getBasePeak());
                    String basePeakAbundance = (float)basePeakAbundanceNoPrecision == massSpectrum.getBasePeakAbundance() ? Integer.toString(basePeakAbundanceNoPrecision) : this.decimalFormat.format(massSpectrum.getBasePeakAbundance());
                    String numberOfIons = Integer.toString(massSpectrum.getNumberOfIons());
                    String name = libraryInformation != null ? libraryInformation.getName() : "";
                    String cas = libraryInformation != null ? libraryInformation.getCasNumber() : "";
                    String mw = this.getMolWeight(libraryInformation);
                    String formula = libraryInformation != null ? libraryInformation.getFormula() : "";
                    String referenceIdentifier = libraryInformation != null ? libraryInformation.getReferenceIdentifier() : "";
                    csvFilePrinter.printRecord(new Object[]{retentionTime, retentionIndex, retentionIndex, basePeak, basePeakAbundance, numberOfIons, name, cas, mw, formula, referenceIdentifier});
                }
            }
        }
    }

    private String getMolWeight(ILibraryInformation libraryInformation) {
        if (libraryInformation != null) {
            int molWeightNoPrecision = (int)libraryInformation.getMolWeight();
            if ((double)molWeightNoPrecision == libraryInformation.getMolWeight()) {
                return Integer.toString(molWeightNoPrecision);
            }
            return this.decimalFormat.format(libraryInformation.getMolWeight());
        }
        return "";
    }
}

