/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.model.versioning;

import java.io.File;
import org.eclipse.chemclipse.logging.core.Logger;
import org.eclipse.chemclipse.model.versioning.IVersionManagement;
import org.eclipse.chemclipse.model.versioning.PathHelper;
import org.eclipse.chemclipse.model.versioning.TimeHelper;

public class VersionManagement
implements IVersionManagement {
    private static Logger logger = Logger.getLogger(VersionManagement.class);
    private String identifier;
    private static final String SCAN_DIRECTORY = "scans";
    private static final String SCAN_HIBERNATE_FILE = "dumpScans";
    private static final String XIC_DIRECTORY = "xics";
    private File storageDirectory;
    private File storageDirectoryScans;
    private File storageDirectoryXics;
    private static final String MARKER = "_r";
    private int revision = 0;
    private int operationLimit = 25;
    private boolean baseRevision;

    public VersionManagement() {
        this.initializeStorageDirectories();
        this.baseRevision = true;
    }

    private void initializeStorageDirectories() {
        this.createIdentifier();
        this.storageDirectory = new File(PathHelper.getStoragePath() + File.separator + this.identifier);
        if (!this.storageDirectory.exists() && !this.storageDirectory.mkdir()) {
            logger.warn((Object)("The temporarily chromatogram file directory could not be created: " + this.storageDirectory.getAbsolutePath()));
        }
        this.storageDirectoryScans = new File(String.valueOf(this.storageDirectory.getAbsolutePath()) + File.separator + SCAN_DIRECTORY);
        if (!this.storageDirectoryScans.exists() && !this.storageDirectoryScans.mkdir()) {
            logger.warn((Object)("The temporarily chromatogram scan file directory could not be created: " + this.storageDirectoryScans.getAbsolutePath()));
        }
        this.storageDirectoryXics = new File(String.valueOf(this.storageDirectory.getAbsolutePath()) + File.separator + XIC_DIRECTORY);
        if (!this.storageDirectoryXics.exists() && !this.storageDirectoryXics.mkdir()) {
            logger.warn((Object)("The temporarily chromatogram tic file directory could not be created: " + this.storageDirectoryXics.getAbsolutePath()));
        }
    }

    private void createIdentifier() {
        this.identifier = "chromatogram@" + Integer.toHexString(this.hashCode()) + TimeHelper.getTimeStampId();
    }

    @Override
    public boolean isBaseRevision() {
        return this.baseRevision;
    }

    @Override
    public int getRevision() {
        return this.revision;
    }

    @Override
    public void doOperation() {
        this.revision = this.validateRevision(++this.revision);
        this.baseRevision = false;
    }

    @Override
    public void undoOperation() {
        this.revision = this.validateRevision(--this.revision);
    }

    @Override
    public void redoOperation() {
        this.revision = this.validateRevision(++this.revision);
    }

    @Override
    public File getActualScanRevision() {
        String file = String.valueOf(this.storageDirectoryScans.getAbsolutePath()) + File.separator + SCAN_HIBERNATE_FILE + this.getActualRevisionMarker();
        return new File(file);
    }

    @Override
    public File getPreviousScanRevision() {
        String file = String.valueOf(this.storageDirectoryScans.getAbsolutePath()) + File.separator + SCAN_HIBERNATE_FILE + this.getPreviousRevisionMarker();
        return new File(file);
    }

    @Override
    public File getNextScanRevision() {
        String file = String.valueOf(this.storageDirectoryScans.getAbsolutePath()) + File.separator + SCAN_HIBERNATE_FILE + this.getNextRevisionMarker();
        return new File(file);
    }

    @Override
    public File getStorageDirectory() {
        return this.storageDirectory;
    }

    @Override
    public String getChromatogramIdentifier() {
        return this.identifier;
    }

    private int validateRevision(int revision) {
        if (revision < 0 || revision > this.operationLimit) {
            revision = 0;
        }
        return revision;
    }

    private String getActualRevisionMarker() {
        return MARKER + this.validateRevision(this.revision);
    }

    private String getPreviousRevisionMarker() {
        return MARKER + this.validateRevision(this.revision - 1);
    }

    private String getNextRevisionMarker() {
        return MARKER + this.validateRevision(this.revision + 1);
    }
}

