/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.model.support;

import org.eclipse.chemclipse.model.support.IAnalysisSegment;

public abstract class AnalysisSegment
implements IAnalysisSegment {
    private int startScan = 0;
    private int stopScan = 0;

    public AnalysisSegment(int startScan, int segmentWidth) {
        if (startScan > 0 && segmentWidth > 0) {
            this.startScan = startScan;
            this.stopScan = startScan + segmentWidth - 1;
        }
    }

    @Override
    public int getStartScan() {
        return this.startScan;
    }

    @Override
    public int getStopScan() {
        return this.stopScan;
    }

    public void setStartScan(int startScan) {
        if (startScan <= 0) {
            throw new IllegalArgumentException("start scan must be > 0");
        }
        this.startScan = startScan;
    }

    public void setStopScan(int stopScan) {
        if (stopScan < this.startScan) {
            throw new IllegalArgumentException("stop scan must be >= start scan");
        }
        this.stopScan = stopScan;
    }
}

