/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.model.supplier;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.chemclipse.model.core.IMeasurement;
import org.eclipse.chemclipse.processing.supplier.IProcessSupplier;
import org.eclipse.chemclipse.processing.supplier.ProcessExecutionConsumer;
import org.eclipse.chemclipse.processing.supplier.ProcessExecutionContext;
import org.eclipse.chemclipse.processing.supplier.ProcessorPreferences;

public interface IMeasurementProcessSupplier<ConfigType>
extends IProcessSupplier<ConfigType> {
    public Collection<? extends IMeasurement> applyProcessor(Collection<? extends IMeasurement> var1, ConfigType var2, ProcessExecutionContext var3);

    public static ProcessExecutionConsumer<Collection<? extends IMeasurement>> createConsumer(Collection<? extends IMeasurement> measurements) {
        return new ProcessExecutionConsumer<Collection<? extends IMeasurement>>(measurements){
            AtomicReference<Collection<? extends IMeasurement>> result;
            {
                this.result = new AtomicReference<Collection>(collection);
            }

            public <X> void execute(ProcessorPreferences<X> preferences, ProcessExecutionContext context) throws Exception {
                IProcessSupplier supplier = preferences.getSupplier();
                if (supplier instanceof IMeasurementProcessSupplier) {
                    IMeasurementProcessSupplier measurementProcessSupplier = (IMeasurementProcessSupplier)supplier;
                    this.result.set(measurementProcessSupplier.applyProcessor(this.result.get(), preferences.getSettings(), context));
                }
            }

            public Collection<? extends IMeasurement> getResult() {
                return this.result.get();
            }

            public <X> boolean canExecute(ProcessorPreferences<X> preferences) {
                IProcessSupplier supplier = preferences.getSupplier();
                return supplier instanceof IMeasurementProcessSupplier;
            }

            public ProcessExecutionConsumer<Collection<? extends IMeasurement>> withResult(Object initialResult) {
                if (initialResult instanceof IMeasurement) {
                    return IMeasurementProcessSupplier.createConsumer(Collections.singleton((IMeasurement)initialResult));
                }
                if (initialResult instanceof Iterable) {
                    Iterable iterable = (Iterable)initialResult;
                    ArrayList<IMeasurement> list = new ArrayList<IMeasurement>();
                    for (Object object : iterable) {
                        if (object instanceof IMeasurement) {
                            list.add((IMeasurement)object);
                            continue;
                        }
                        return null;
                    }
                    return IMeasurementProcessSupplier.createConsumer(list);
                }
                return null;
            }
        };
    }
}

