/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.model.results;

import java.util.Collections;
import java.util.List;
import org.eclipse.chemclipse.model.core.IChromatogram;
import org.eclipse.chemclipse.model.results.AnalysisSegmentMeasurementResult;
import org.eclipse.chemclipse.model.support.AnalysisSupport;
import org.eclipse.chemclipse.model.support.ChromatogramSegment;
import org.eclipse.chemclipse.model.support.SegmentWidth;

public class ChromatogramSegmentation
extends AnalysisSegmentMeasurementResult<ChromatogramSegment> {
    private final List<ChromatogramSegment> segments;
    private final SegmentWidth width;

    public ChromatogramSegmentation(IChromatogram<?> chromatogram, SegmentWidth width) {
        this.width = width;
        this.segments = Collections.unmodifiableList(AnalysisSupport.getChromatogramSegments(chromatogram, width));
    }

    @Override
    public String getName() {
        return "Chromatogram Segments";
    }

    @Override
    public List<ChromatogramSegment> getResult() {
        return this.segments;
    }

    public SegmentWidth getWidth() {
        return this.width;
    }

    @Override
    public boolean isVisible() {
        return false;
    }

    @Override
    public Class<ChromatogramSegment> getType() {
        return ChromatogramSegment.class;
    }
}

