/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.converter.quantitation;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.chemclipse.converter.exceptions.NoConverterAvailableException;
import org.eclipse.chemclipse.converter.quantitation.IQuantDBConverterSupport;
import org.eclipse.chemclipse.processing.converter.ISupplier;
import org.eclipse.chemclipse.support.util.FileUtil;

public class QuantDBConverterSupport
implements IQuantDBConverterSupport {
    private List<ISupplier> suppliers = new ArrayList<ISupplier>();

    @Override
    public void add(ISupplier supplier) {
        this.suppliers.add(supplier);
    }

    @Override
    public String getConverterId(int index) throws NoConverterAvailableException {
        this.areConvertersStored();
        if (index < 0 || index > this.suppliers.size() - 1) {
            throw new NoConverterAvailableException("There is no converter available.");
        }
        ISupplier supplier = this.suppliers.get(index);
        return supplier.getId();
    }

    @Override
    public String getConverterId(String name) throws NoConverterAvailableException {
        this.areConvertersStored();
        String id = "";
        for (ISupplier supplier : this.suppliers) {
            if (!supplier.getFilterName().equals(name)) continue;
            id = supplier.getId();
            break;
        }
        if (id.equals("")) {
            throw new NoConverterAvailableException("There is no converter available.");
        }
        return id;
    }

    @Override
    public String[] getFilterExtensions() throws NoConverterAvailableException {
        this.areConvertersStored();
        ArrayList<String> extensions = new ArrayList<String>();
        for (ISupplier supplier : this.suppliers) {
            extensions.add(supplier.getFileExtension());
        }
        return extensions.toArray(new String[extensions.size()]);
    }

    @Override
    public String[] getFilterNames() throws NoConverterAvailableException {
        this.areConvertersStored();
        ArrayList<String> filterNames = new ArrayList<String>();
        for (ISupplier supplier : this.suppliers) {
            filterNames.add(supplier.getFilterName());
        }
        return filterNames.toArray(new String[filterNames.size()]);
    }

    @Override
    public List<String> getAvailableConverterIds(File file) throws NoConverterAvailableException {
        this.areConvertersStored();
        ArrayList<String> availableConverters = new ArrayList<String>();
        String fileName = file.getName();
        for (ISupplier supplier : this.suppliers) {
            String fileExtension;
            if (!FileUtil.fileHasExtension((File)file) || (fileExtension = supplier.getFileExtension()) == null || fileExtension.equals("") || !fileName.endsWith(fileExtension) && !fileName.endsWith(fileExtension.toLowerCase()) && !fileName.endsWith(fileExtension.toUpperCase())) continue;
            availableConverters.add(supplier.getId());
        }
        if (availableConverters.isEmpty()) {
            throw new NoConverterAvailableException("There is no converter available to process the file: " + file.toString());
        }
        return availableConverters;
    }

    @Override
    public List<ISupplier> getSupplier() {
        return this.suppliers;
    }

    @Override
    public ISupplier getSupplier(String id) throws NoConverterAvailableException {
        ISupplier instance = null;
        for (ISupplier supplier : this.suppliers) {
            if (!supplier.getId().equals(id)) continue;
            instance = supplier;
            break;
        }
        if (instance == null) {
            throw new NoConverterAvailableException("There is no converter available with the given id: " + id + ".");
        }
        return instance;
    }

    private void areConvertersStored() throws NoConverterAvailableException {
        if (this.suppliers.size() < 1) {
            throw new NoConverterAvailableException();
        }
    }
}

