/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.chromatogram.xxd.process.supplier.workflows.core;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.chemclipse.chromatogram.msd.identifier.massspectrum.MassSpectrumIdentifier;
import org.eclipse.chemclipse.chromatogram.xxd.process.supplier.workflows.converter.SampleQuantWriter;
import org.eclipse.chemclipse.chromatogram.xxd.process.supplier.workflows.converter.TargetsReader;
import org.eclipse.chemclipse.chromatogram.xxd.process.supplier.workflows.model.ISampleQuantReport;
import org.eclipse.chemclipse.chromatogram.xxd.process.supplier.workflows.model.ISampleQuantSubstance;
import org.eclipse.chemclipse.chromatogram.xxd.process.supplier.workflows.model.SampleQuantSubstance;
import org.eclipse.chemclipse.chromatogram.xxd.process.supplier.workflows.preferences.PreferenceSupplier;
import org.eclipse.chemclipse.converter.model.IReportRowModel;
import org.eclipse.chemclipse.converter.report.ReportConverter;
import org.eclipse.chemclipse.logging.core.Logger;
import org.eclipse.chemclipse.model.core.IChromatogram;
import org.eclipse.chemclipse.model.core.IScan;
import org.eclipse.chemclipse.msd.converter.chromatogram.ChromatogramConverterMSD;
import org.eclipse.chemclipse.msd.model.core.IChromatogramMSD;
import org.eclipse.chemclipse.msd.model.core.IScanMSD;
import org.eclipse.chemclipse.processing.core.IProcessingInfo;
import org.eclipse.chemclipse.processing.core.exceptions.TypeCastException;
import org.eclipse.chemclipse.support.text.ValueFormat;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;

public class SampleQuantProcessor {
    public static final String REPORT_FILE_EXTENSION = ".sqr";
    private static final Logger logger = Logger.getLogger(SampleQuantProcessor.class);
    private static final String EXTENSION_POINT_ID_RTERES = "net.openchrom.msd.converter.supplier.agilent.hp.report.rteres";
    private static final String EXTENSION_POINT_ID_SUMRPT = "net.openchrom.msd.converter.supplier.agilent.hp.report.sumrpt";
    private static final String CHROMATOGRAM_CONVERTER_ID = "org.eclipse.chemclipse.xxd.converter.supplier.chemclipse";
    private static final String CHROMATOGRAM_FILE_EXTENSION = ".ocb";
    private Pattern pattern = Pattern.compile("(\\d+)-(\\d\\d)-(\\d)");

    public void createSampleQuantReport(File sampleQuantReportFile, ISampleQuantReport sampleQuantReport, String pathChromatogramOriginal, IProgressMonitor monitor) {
        try {
            sampleQuantReport.setPathChromatogramOriginal(pathChromatogramOriginal);
            File chromatogramImportFile = new File(pathChromatogramOriginal);
            IProcessingInfo processingInfoImport = ChromatogramConverterMSD.getInstance().convert(chromatogramImportFile, monitor);
            IChromatogramMSD chromatogramMSD = (IChromatogramMSD)processingInfoImport.getProcessingResult(IChromatogramMSD.class);
            sampleQuantReport.setName(chromatogramMSD.getName());
            sampleQuantReport.setDataName(chromatogramMSD.getDataName());
            sampleQuantReport.setDate(ValueFormat.getDateFormatEnglish().format(chromatogramMSD.getDate()));
            sampleQuantReport.setOperator(chromatogramMSD.getOperator());
            sampleQuantReport.setMiscInfo(chromatogramMSD.getMiscInfo());
            ArrayList<IScanMSD> scansToIdentify = new ArrayList<IScanMSD>();
            List<ISampleQuantSubstance> sampleQuantSubstances = sampleQuantReport.getSampleQuantSubstances();
            for (ISampleQuantSubstance sampleQuantSubstance : sampleQuantSubstances) {
                int maxScan = sampleQuantSubstance.getMaxScan();
                IScan scan = chromatogramMSD.getScan(maxScan);
                if (!(scan instanceof IScanMSD)) continue;
                IScanMSD scanMSD = (IScanMSD)scan;
                scansToIdentify.add(scanMSD);
            }
            String identifierId = PreferenceSupplier.INSTANCE().getPreferences().get("samplequantScanIdentifier", "");
            MassSpectrumIdentifier.identify(scansToIdentify, (String)identifierId, (IProgressMonitor)monitor);
            File chromatogramExportFile = new File(sampleQuantReportFile.getAbsolutePath().replace(REPORT_FILE_EXTENSION, CHROMATOGRAM_FILE_EXTENSION));
            IProcessingInfo processingInfoExport = ChromatogramConverterMSD.getInstance().convert(chromatogramExportFile, (IChromatogram)chromatogramMSD, CHROMATOGRAM_CONVERTER_ID, monitor);
            sampleQuantReport.setPathChromatogramEdited(((File)processingInfoExport.getProcessingResult(File.class)).getAbsolutePath());
            SampleQuantWriter sampleQuantWriter = new SampleQuantWriter();
            sampleQuantWriter.write(sampleQuantReportFile, sampleQuantReport, monitor);
        }
        catch (Exception e) {
            logger.warn((Object)e);
        }
    }

    public List<ISampleQuantSubstance> extractSampleQuantSubstances(File fileAdditionalReportData, File fileAreaPercentReport, File fileQuantitationReport) {
        ArrayList<ISampleQuantSubstance> sampleQuantSubstances = new ArrayList<ISampleQuantSubstance>();
        Map<String, String> reportCompoundCasMap = this.extractReportCompoundCasMap(fileAdditionalReportData);
        IReportRowModel reportRowModelAreaPercent = this.extractReportRowModel(fileAreaPercentReport, EXTENSION_POINT_ID_RTERES);
        IReportRowModel reportRowModelQuantitation = this.extractReportRowModel(fileQuantitationReport, EXTENSION_POINT_ID_SUMRPT);
        try {
            int INDEX_RTRERES_RT = this.getRowIndex(reportRowModelAreaPercent, "R.T. min");
            int INDEX_RTRERES_MAX_SCAN = this.getRowIndex(reportRowModelAreaPercent, "max scan");
            int INDEX_SUMRPT_ID = this.getRowIndex(reportRowModelQuantitation, "Id");
            int INDEX_SUMRPT_NAME = this.getRowIndex(reportRowModelQuantitation, "Compound");
            int INDEX_SUMRPT_RT = this.getRowIndex(reportRowModelQuantitation, "R.T.");
            int INDEX_SUMRPT_CONCENTRATION = this.getRowIndex(reportRowModelQuantitation, "Conc");
            int INDEX_SUMRPT_UNITS = this.getRowIndex(reportRowModelQuantitation, "Units");
            int INDEX_SUMRPT_MISC = this.getRowIndex(reportRowModelQuantitation, "Misc");
            int INDEX_SUMRPT_QVALUE = this.getRowIndex(reportRowModelQuantitation, "Qvalue");
            HashMap<Integer, List<String>> areaPercentRowMap = new HashMap<Integer, List<String>>();
            for (List row : reportRowModelAreaPercent) {
                int retentionTime = (int)(this.getValueDouble(((String)row.get(INDEX_RTRERES_RT)).trim()) * 60000.0);
                areaPercentRowMap.put(retentionTime, row);
            }
            int index = 0;
            while (index < reportRowModelQuantitation.size()) {
                if (index != 0) {
                    List row = (List)reportRowModelQuantitation.get(index);
                    String name = ((String)row.get(INDEX_SUMRPT_NAME)).trim();
                    String misc = ((String)row.get(INDEX_SUMRPT_MISC)).trim();
                    String retentionTimeInMinutes = (String)row.get(INDEX_SUMRPT_RT);
                    int retentionTime = (int)(this.getValueDouble(retentionTimeInMinutes) * 60000.0);
                    List<String> rowAreaPercent = this.getRowByCompound(areaPercentRowMap, retentionTime, 1000);
                    SampleQuantSubstance sampleQuantSubstance = new SampleQuantSubstance();
                    sampleQuantSubstance.setId(this.getValueInteger(rowAreaPercent.get(INDEX_SUMRPT_ID)));
                    sampleQuantSubstance.setName(name);
                    Matcher matcher = this.pattern.matcher(name);
                    if (matcher.find()) {
                        sampleQuantSubstance.setCasNumber(matcher.group());
                    } else {
                        sampleQuantSubstance.setCasNumber(this.getCasNumber(name, reportCompoundCasMap));
                    }
                    sampleQuantSubstance.setMaxScan(this.getMaxScan(rowAreaPercent, INDEX_RTRERES_MAX_SCAN));
                    sampleQuantSubstance.setConcentration(this.getValueDouble((String)row.get(INDEX_SUMRPT_CONCENTRATION)));
                    sampleQuantSubstance.setUnit((String)row.get(INDEX_SUMRPT_UNITS));
                    sampleQuantSubstance.setMisc(misc);
                    sampleQuantSubstance.setMatchQuality(this.getValueDouble((String)row.get(INDEX_SUMRPT_QVALUE)));
                    sampleQuantSubstance.setMinMatchQuality(PreferenceSupplier.INSTANCE().getPreferences().getDouble("samplequantMinMatchQuality", 95.0));
                    sampleQuantSubstances.add(sampleQuantSubstance);
                }
                ++index;
            }
        }
        catch (Exception e) {
            logger.warn((Object)e);
        }
        return sampleQuantSubstances;
    }

    private String getCasNumber(String name, Map<String, String> reportCompoundCasMap) {
        return reportCompoundCasMap.get(name) != null ? reportCompoundCasMap.get(name) : "";
    }

    private int getMaxScan(List<String> rowAreaPercent, int INDEX_RTRERES_MAX_SCAN) {
        if (rowAreaPercent != null) {
            return this.getValueInteger(rowAreaPercent.get(INDEX_RTRERES_MAX_SCAN));
        }
        return 0;
    }

    private int getRowIndex(IReportRowModel reportRowModel, String columnName) throws Exception {
        int index = reportRowModel.getColumnIndex(columnName);
        if (index == -1) {
            throw new Exception("The column with the given name could't be found: " + columnName);
        }
        return index;
    }

    private Map<String, String> extractReportCompoundCasMap(File fileAdditionalReportData) {
        Map<String, String> reportCompoundCasMap = new HashMap<String, String>();
        if (fileAdditionalReportData != null && fileAdditionalReportData.exists()) {
            TargetsReader targetsReader = new TargetsReader();
            reportCompoundCasMap = targetsReader.getCompoundCasMap(fileAdditionalReportData);
        }
        return reportCompoundCasMap;
    }

    private IReportRowModel extractReportRowModel(File fileImport, String extensionPointId) {
        IReportRowModel reportRowModel;
        IProcessingInfo processingInfo = ReportConverter.convert((File)fileImport, (String)extensionPointId, (IProgressMonitor)new NullProgressMonitor());
        try {
            reportRowModel = (IReportRowModel)processingInfo.getProcessingResult(IReportRowModel.class);
        }
        catch (TypeCastException e) {
            reportRowModel = null;
        }
        return reportRowModel;
    }

    private int getValueInteger(String value) {
        try {
            return Integer.parseInt(value);
        }
        catch (Exception e) {
            return 0;
        }
    }

    private double getValueDouble(String value) {
        try {
            return Double.parseDouble(value);
        }
        catch (Exception e) {
            return 0.0;
        }
    }

    private List<String> getRowByCompound(Map<Integer, List<String>> areaPercentRowMap, int retentionTime, int deltaRetentionTime) {
        int retentionTimeLeftBorder = retentionTime - deltaRetentionTime;
        int retentionTimeRightBorder = retentionTime + deltaRetentionTime;
        for (Map.Entry<Integer, List<String>> entry : areaPercentRowMap.entrySet()) {
            int retentionTimeTarget = entry.getKey();
            if (retentionTimeTarget < retentionTimeLeftBorder || retentionTimeTarget > retentionTimeRightBorder) continue;
            return entry.getValue();
        }
        return null;
    }
}

