/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.chromatogram.xxd.process.supplier.workflows.converter;

import java.awt.Color;
import java.io.File;
import java.io.IOException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.PDPageContentStream;
import org.apache.pdfbox.pdmodel.common.PDRectangle;
import org.apache.pdfbox.pdmodel.font.PDFont;
import org.apache.pdfbox.pdmodel.font.PDType1Font;
import org.eclipse.chemclipse.chromatogram.xxd.process.supplier.workflows.converter.PdfTableCell;
import org.eclipse.chemclipse.chromatogram.xxd.process.supplier.workflows.model.ISampleQuantReport;
import org.eclipse.chemclipse.chromatogram.xxd.process.supplier.workflows.model.ISampleQuantSubstance;
import org.eclipse.chemclipse.logging.core.Logger;
import org.eclipse.chemclipse.support.text.ValueFormat;
import org.eclipse.core.runtime.IProgressMonitor;

public class SampleQuantExportPDF {
    private static final Logger logger = Logger.getLogger(SampleQuantExportPDF.class);
    private static final float L_1_MM = 2.8346f;
    private static final float L_0_5_MM = 1.4173f;
    private static final float L_1_4_MM = 3.9684398f;
    private static final float L_15_MM = 42.519f;
    private static final float L_20_MM = 56.692f;
    private static final float L_200_MM = 566.92f;
    private static final float L_297_MM = 841.8762f;
    private static final int RESULTS_PER_PAGE = 26;
    private PDFont font = PDType1Font.HELVETICA;
    private PDFont fontBold = PDType1Font.HELVETICA_BOLD;
    private DecimalFormat decimalFormat = ValueFormat.getDecimalFormatEnglish();

    public void write(File file, ISampleQuantReport sampleQuantReport, IProgressMonitor monitor) throws Exception {
        try (PDDocument document = null;){
            try {
                document = new PDDocument();
                List<ISampleQuantSubstance> sampleQuantSubstances = this.getSampleQuantSubstancesToPrint(sampleQuantReport);
                int pages = (int)Math.ceil((double)sampleQuantSubstances.size() / 26.0);
                int page = 1;
                int start = 0;
                int stop = 26;
                while (page <= pages) {
                    List<ISampleQuantSubstance> sampleQuantSubstancesChunk = this.getSampleQuantSubstancesChunk(sampleQuantSubstances, start, stop);
                    this.createPage(document, sampleQuantSubstancesChunk, page++, pages, monitor);
                    start += 26;
                    stop += 26;
                }
                document.save(file);
            }
            catch (IOException e) {
                logger.warn((Object)e);
                if (document != null) {
                    document.close();
                }
            }
        }
    }

    private List<ISampleQuantSubstance> getSampleQuantSubstancesToPrint(ISampleQuantReport sampleQuantReport) {
        ArrayList<ISampleQuantSubstance> sampleQuantSubstances = new ArrayList<ISampleQuantSubstance>();
        for (ISampleQuantSubstance sampleQuantSubstance : sampleQuantReport.getSampleQuantSubstances()) {
            if (!sampleQuantSubstance.getType().equals("SAMPLE")) continue;
            sampleQuantSubstances.add(sampleQuantSubstance);
        }
        return sampleQuantSubstances;
    }

    private List<ISampleQuantSubstance> getSampleQuantSubstancesChunk(List<ISampleQuantSubstance> sampleQuantSubstances, int start, int stop) {
        ArrayList<ISampleQuantSubstance> sampleQuantSubstancesChunk = new ArrayList<ISampleQuantSubstance>();
        if (stop > sampleQuantSubstances.size()) {
            stop = sampleQuantSubstances.size();
        }
        int index = start;
        while (index < stop) {
            sampleQuantSubstancesChunk.add(sampleQuantSubstances.get(index));
            ++index;
        }
        return sampleQuantSubstancesChunk;
    }

    private PDPage createPage(PDDocument document, List<ISampleQuantSubstance> sampleQuantSubstances, int page, int pages, IProgressMonitor monitor) throws IOException {
        PDPage pdPage = new PDPage(PDRectangle.A4);
        document.addPage(pdPage);
        PDPageContentStream contentStream = new PDPageContentStream(document, pdPage);
        contentStream.setFont(this.font, 12.0f);
        float xPosition = 56.692f;
        float yPosition = 0.0f;
        yPosition = this.printTableResults(contentStream, sampleQuantSubstances, xPosition, yPosition);
        this.printPageFooter(document, contentStream, page, pages);
        contentStream.close();
        return pdPage;
    }

    private void printPageFooter(PDDocument document, PDPageContentStream contentStream, int page, int pages) throws IOException {
        this.printText(contentStream, 42.519f, this.getPositionFromTop(807.86096f), "Page " + page + "/" + pages);
    }

    private float printTableResults(PDPageContentStream contentStream, List<ISampleQuantSubstance> sampleQuantSubstances, float xPosition, float yPosition) throws IOException {
        float yStartPosition = yPosition += 42.519f;
        ArrayList<PdfTableCell> cellsMaster = new ArrayList<PdfTableCell>();
        cellsMaster.add(new PdfTableCell("Name", 190.0f));
        cellsMaster.add(new PdfTableCell("CAS#", 90.0f));
        cellsMaster.add(new PdfTableCell("Conc.", 55.0f));
        cellsMaster.add(new PdfTableCell("Unit", 55.0f));
        cellsMaster.add(new PdfTableCell("MQ", 55.0f));
        cellsMaster.add(new PdfTableCell("OK", 75.0f));
        yPosition = this.printTableLine(contentStream, xPosition, yPosition, cellsMaster, Color.GRAY, true, true);
        int i = 1;
        for (ISampleQuantSubstance sampleQuantSubstance : sampleQuantSubstances) {
            ArrayList<PdfTableCell> cells = new ArrayList<PdfTableCell>();
            cells.add(new PdfTableCell(sampleQuantSubstance.getName(), 190.0f));
            cells.add(new PdfTableCell(sampleQuantSubstance.getCasNumber(), 90.0f));
            cells.add(new PdfTableCell(this.decimalFormat.format(sampleQuantSubstance.getConcentration()), 55.0f));
            cells.add(new PdfTableCell(sampleQuantSubstance.getUnit().replace("\u00b5", "u"), 55.0f));
            cells.add(new PdfTableCell(this.decimalFormat.format(sampleQuantSubstance.getMatchQuality()), 55.0f));
            cells.add(new PdfTableCell(sampleQuantSubstance.isValidated() ? "+" : "-", 75.0f));
            yPosition = i % 2 == 0 ? this.printTableLine(contentStream, xPosition, yPosition, cells, Color.LIGHT_GRAY, false, true) : this.printTableLine(contentStream, xPosition, yPosition, cells, null, false, true);
            ++i;
        }
        float top = this.getPositionFromTop(yPosition * 2.8346f);
        contentStream.drawLine(xPosition, top, 566.92f, top);
        float yStart = this.getPositionFromTop(yStartPosition * 2.8346f);
        float yStartExtraSpace = this.getPositionFromTop((yStartPosition + 3.9684398f + 1.4173f) * 2.8346f);
        float yStop = this.getPositionFromTop(yPosition * 2.8346f);
        float left = xPosition;
        for (PdfTableCell cell : cellsMaster) {
            if (cell.isPrintLeftLine()) {
                contentStream.drawLine(left, yStart, left, yStop);
            } else {
                contentStream.drawLine(left, yStartExtraSpace, left, yStop);
            }
            left += cell.getWidth();
        }
        contentStream.drawLine(566.92f, yStart, 566.92f, yStop);
        return yPosition;
    }

    private float printTableLine(PDPageContentStream contentStream, float xPosition, float yPosition, List<PdfTableCell> cells, Color color, boolean bold, boolean drawTopLine) throws IOException {
        float left = xPosition;
        float top = this.getPositionFromTop(yPosition * 2.8346f);
        if (color != null) {
            contentStream.setNonStrokingColor(color);
            float heightx = 5.38574f;
            float topx = this.getPositionFromTop((yPosition + heightx) * 2.8346f);
            float widthx = 566.92f - xPosition;
            contentStream.fillRect(xPosition, topx, widthx, heightx * 2.8346f);
        }
        contentStream.setNonStrokingColor(Color.BLACK);
        if (drawTopLine) {
            contentStream.setStrokingColor(Color.BLACK);
        } else {
            contentStream.setStrokingColor(color);
        }
        contentStream.drawLine(xPosition, top, 566.92f, top);
        top = this.getPositionFromTop((yPosition += 3.9684398f) * 2.8346f);
        for (PdfTableCell cell : cells) {
            if (bold) {
                contentStream.setFont(this.fontBold, 12.0f);
            }
            this.printText(contentStream, left, top, " " + cell.getText());
            left += cell.getWidth();
        }
        contentStream.setFont(this.font, 12.0f);
        return yPosition += 1.4173f;
    }

    private void printText(PDPageContentStream contentStream, float xPosition, float yPosition, String text) throws IOException {
        contentStream.beginText();
        contentStream.moveTextPositionByAmount(xPosition, yPosition);
        contentStream.drawString(text);
        contentStream.endText();
    }

    private float getPositionFromTop(float x) {
        return 841.8762f - x;
    }
}

