/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.chromatogram.xxd.process.supplier.pca.core;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Set;
import java.util.TreeMap;
import org.apache.commons.math3.analysis.UnivariateFunction;
import org.apache.commons.math3.analysis.interpolation.LinearInterpolator;
import org.apache.commons.math3.analysis.interpolation.UnivariateInterpolator;
import org.eclipse.chemclipse.chromatogram.xxd.process.supplier.pca.model.IDataInputEntry;
import org.eclipse.chemclipse.chromatogram.xxd.process.supplier.pca.model.PeakSampleData;
import org.eclipse.chemclipse.chromatogram.xxd.process.supplier.pca.model.Sample;
import org.eclipse.chemclipse.chromatogram.xxd.process.supplier.pca.model.Samples;
import org.eclipse.chemclipse.model.core.IScan;
import org.eclipse.chemclipse.model.statistics.RetentionTime;
import org.eclipse.core.runtime.IProgressMonitor;

public class ScansExtractionSupport {
    private int beginRetentionTimeMax;
    private int endRetentionTimeMin;
    private ExtractionType extractionType;
    private int maximalNumberScans;
    private int retentionTimeWindow;
    private boolean useDefaultProperties;

    public ScansExtractionSupport(int retentionTimeWindow, int maximalNumberScans, ExtractionType extractionType, boolean useDefaultProperties) {
        this.retentionTimeWindow = retentionTimeWindow;
        this.extractionType = extractionType;
        this.useDefaultProperties = useDefaultProperties;
        this.maximalNumberScans = maximalNumberScans;
    }

    private Map<String, NavigableMap<Integer, Float>> extractScans(Map<IDataInputEntry, Collection<IScan>> inputs, IProgressMonitor monitor) {
        this.beginRetentionTimeMax = 0;
        this.endRetentionTimeMin = Integer.MAX_VALUE;
        HashMap<String, NavigableMap<Integer, Float>> scanMap = new HashMap<String, NavigableMap<Integer, Float>>();
        for (Map.Entry<IDataInputEntry, Collection<IScan>> input : inputs.entrySet()) {
            TreeMap<Integer, Float> extractScans = new TreeMap<Integer, Float>();
            Collection<IScan> scans = input.getValue();
            for (IScan scan : scans) {
                float currentSignal = scan.getTotalSignal();
                int currentTime = scan.getRetentionTime();
                extractScans.put(currentTime, Float.valueOf(currentSignal));
            }
            int firstRetentionTime = (Integer)extractScans.firstKey();
            int lastRetetnionTime = (Integer)extractScans.lastKey();
            if (firstRetentionTime > this.beginRetentionTimeMax) {
                this.beginRetentionTimeMax = firstRetentionTime;
            }
            if (lastRetetnionTime < this.endRetentionTimeMin) {
                this.endRetentionTimeMin = lastRetetnionTime;
            }
            scanMap.put(input.getKey().getName(), extractScans);
        }
        return scanMap;
    }

    private Float getClosestScans(NavigableMap<Integer, Float> peakTree, int retentionTime) {
        Map.Entry<Integer, Float> peakRetentionTimeCeil = peakTree.ceilingEntry(retentionTime);
        Map.Entry<Integer, Float> peakRetentionTimeFlour = peakTree.floorEntry(retentionTime);
        if (peakRetentionTimeCeil != null && peakRetentionTimeFlour != null) {
            if (peakRetentionTimeCeil.getKey() - retentionTime < retentionTime - peakRetentionTimeFlour.getKey()) {
                return peakRetentionTimeCeil.getValue();
            }
            return peakRetentionTimeFlour.getValue();
        }
        if (peakRetentionTimeCeil != null) {
            return peakRetentionTimeCeil.getValue();
        }
        if (peakRetentionTimeFlour != null) {
            return peakRetentionTimeFlour.getValue();
        }
        return null;
    }

    private void interpolation(Samples samples, Map<String, NavigableMap<Integer, Float>> extractScans, UnivariateInterpolator interpolator) {
        for (Sample sample : samples.getSampleList()) {
            List data = sample.getSampleData();
            NavigableMap<Integer, Float> scans = extractScans.get(sample.getName());
            double[] retetnionTime = new double[scans.size()];
            double[] scanValues = new double[scans.size()];
            int j = 0;
            for (Map.Entry entry : scans.entrySet()) {
                retetnionTime[j] = ((Integer)entry.getKey()).intValue();
                scanValues[j] = ((Float)entry.getValue()).floatValue();
                ++j;
            }
            UnivariateFunction fun = interpolator.interpolate(retetnionTime, scanValues);
            int i = this.beginRetentionTimeMax;
            while (i <= this.endRetentionTimeMin) {
                double value = fun.value((double)i);
                PeakSampleData d = new PeakSampleData(value, null);
                data.add(d);
                i += this.retentionTimeWindow;
            }
        }
        this.setRetentionTime(samples);
    }

    public Samples process(Map<IDataInputEntry, Collection<IScan>> dataInput, IProgressMonitor monitor) {
        int size;
        Samples samples = new Samples(dataInput.keySet());
        Map<String, NavigableMap<Integer, Float>> extractScans = this.extractScans(dataInput, monitor);
        boolean similarChromatogram = true;
        if (this.useDefaultProperties) {
            Collection<NavigableMap<Integer, Float>> dataSet = extractScans.values();
            boolean isFirst = true;
            HashSet retentionTimes = new HashSet();
            int retentionTimeSize = retentionTimes.size();
            for (NavigableMap<Integer, Float> data : dataSet) {
                if (isFirst) {
                    retentionTimes.addAll(data.keySet());
                    continue;
                }
                if (data.size() != retentionTimes.size()) {
                    similarChromatogram = false;
                    break;
                }
                long dataSiza = data.keySet().stream().filter(time -> retentionTimes.contains(time)).count();
                if (dataSiza == (long)retentionTimeSize) continue;
                similarChromatogram = false;
                break;
            }
        }
        if ((size = (this.endRetentionTimeMin - this.beginRetentionTimeMax) / this.retentionTimeWindow) > this.maximalNumberScans) {
            this.retentionTimeWindow = (this.endRetentionTimeMin - this.beginRetentionTimeMax) / this.maximalNumberScans;
            similarChromatogram = false;
        }
        if (similarChromatogram && this.useDefaultProperties) {
            this.useDefaultProperties(samples, extractScans);
        } else {
            switch (this.extractionType) {
                case CLOSEST_SCAN: {
                    this.setClosestScan(samples, extractScans);
                    break;
                }
                case LINEAR_INTERPOLATION_SCAN: {
                    this.interpolation(samples, extractScans, (UnivariateInterpolator)new LinearInterpolator());
                }
            }
        }
        return samples;
    }

    private void setClosestScan(Samples samples, Map<String, NavigableMap<Integer, Float>> extractScans) {
        for (Sample sample : samples.getSampleList()) {
            List data = sample.getSampleData();
            NavigableMap<Integer, Float> scans = extractScans.get(sample.getName());
            int i = this.beginRetentionTimeMax;
            while (i <= this.endRetentionTimeMin) {
                Float value = this.getClosestScans(scans, i);
                PeakSampleData d = new PeakSampleData(value.floatValue(), null);
                data.add(d);
                i += this.retentionTimeWindow;
            }
        }
        this.setRetentionTime(samples);
    }

    private void setRetentionTime(Samples samples) {
        ArrayList<Integer> retentionTime = new ArrayList<Integer>();
        int i = this.beginRetentionTimeMax;
        while (i <= this.endRetentionTimeMin) {
            retentionTime.add(i);
            i += this.retentionTimeWindow;
        }
        samples.getVariables().addAll(RetentionTime.create(retentionTime));
    }

    private void useDefaultProperties(Samples samples, Map<String, NavigableMap<Integer, Float>> extractScans) {
        Set retentionTimesSet = extractScans.entrySet().iterator().next().getValue().keySet();
        ArrayList retentionTimes = new ArrayList(retentionTimesSet);
        Collections.sort(retentionTimes);
        for (Sample sample : samples.getSampleList()) {
            Iterator it = retentionTimes.iterator();
            List data = sample.getSampleData();
            NavigableMap<Integer, Float> scans = extractScans.get(sample.getName());
            while (it.hasNext()) {
                PeakSampleData d;
                Integer time = (Integer)it.next();
                Float value = (Float)scans.get(time);
                if (value != null) {
                    d = new PeakSampleData(value.floatValue(), null);
                } else {
                    value = this.getClosestScans(scans, time);
                    d = new PeakSampleData(value.floatValue(), null);
                }
                data.add(d);
            }
        }
        samples.getVariables().addAll(RetentionTime.create(retentionTimes));
    }

    public static enum ExtractionType {
        CLOSEST_SCAN,
        LINEAR_INTERPOLATION_SCAN;

    }
}

