/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.chromatogram.xxd.edit.supplier.snip.ui.internal.handlers;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.chemclipse.chromatogram.msd.filter.core.massspectrum.MassSpectrumFilter;
import org.eclipse.chemclipse.chromatogram.msd.filter.settings.IMassSpectrumFilterSettings;
import org.eclipse.chemclipse.chromatogram.xxd.edit.supplier.snip.preferences.PreferenceSupplier;
import org.eclipse.chemclipse.chromatogram.xxd.edit.supplier.snip.settings.MassSpectrumFilterSettings;
import org.eclipse.chemclipse.msd.model.core.IScanMSD;
import org.eclipse.chemclipse.msd.model.notifier.MassSpectrumSelectionUpdateNotifier;
import org.eclipse.chemclipse.processing.core.IProcessingInfo;
import org.eclipse.chemclipse.processing.core.MessageProvider;
import org.eclipse.chemclipse.processing.ui.support.ProcessingInfoViewSupport;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Display;

public class MassSpectrumFilterRunnable
implements IRunnableWithProgress {
    private static final String DESCRIPTION = "SNIP Filter Mass Spectrum";
    private static final String FILTER_ID_SNIP_MS = "org.eclipse.chemclipse.chromatogram.msd.filter.supplier.snip.massspectrum";
    private IScanMSD massSpectrum;

    public MassSpectrumFilterRunnable(IScanMSD massSpectrum) {
        this.massSpectrum = massSpectrum;
    }

    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        try {
            monitor.beginTask(DESCRIPTION, -1);
            MassSpectrumFilterSettings massSpectrumFilterSettings = PreferenceSupplier.getMassSpectrumFilterSettings();
            IProcessingInfo processingInfo = MassSpectrumFilter.applyFilter((IScanMSD)this.massSpectrum, (IMassSpectrumFilterSettings)massSpectrumFilterSettings, (String)FILTER_ID_SNIP_MS, (IProgressMonitor)monitor);
            ProcessingInfoViewSupport.updateProcessingInfo((MessageProvider)processingInfo, (boolean)false);
            this.updateSelection();
        }
        finally {
            monitor.done();
        }
    }

    private void updateSelection() {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                MassSpectrumSelectionUpdateNotifier.fireUpdateChange((IScanMSD)MassSpectrumFilterRunnable.this.massSpectrum, (boolean)true);
            }
        });
    }
}

