/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.chromatogram.xxd.calculator.supplier.amdiscalri.impl;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.chemclipse.chromatogram.msd.identifier.settings.IPeakIdentifierSettingsMSD;
import org.eclipse.chemclipse.chromatogram.msd.peak.detector.settings.IPeakDetectorSettingsMSD;
import org.eclipse.chemclipse.chromatogram.peak.detector.model.Threshold;
import org.eclipse.chemclipse.chromatogram.xxd.calculator.supplier.amdiscalri.core.PeakIdentifier;
import org.eclipse.chemclipse.chromatogram.xxd.calculator.supplier.amdiscalri.impl.RetentionIndexCalculator;
import org.eclipse.chemclipse.chromatogram.xxd.calculator.supplier.amdiscalri.settings.CalculatorSettings;
import org.eclipse.chemclipse.chromatogram.xxd.integrator.core.settings.peaks.AreaSupport;
import org.eclipse.chemclipse.chromatogram.xxd.integrator.core.settings.peaks.IIntegrationSupport;
import org.eclipse.chemclipse.chromatogram.xxd.integrator.supplier.trapezoid.core.PeakIntegrator;
import org.eclipse.chemclipse.chromatogram.xxd.integrator.supplier.trapezoid.settings.PeakIntegrationSettings;
import org.eclipse.chemclipse.chromatogram.xxd.peak.detector.supplier.firstderivative.core.PeakDetectorMSD;
import org.eclipse.chemclipse.chromatogram.xxd.peak.detector.supplier.firstderivative.settings.PeakDetectorSettingsMSD;
import org.eclipse.chemclipse.logging.core.Logger;
import org.eclipse.chemclipse.model.selection.IChromatogramSelection;
import org.eclipse.chemclipse.msd.converter.chromatogram.ChromatogramConverterMSD;
import org.eclipse.chemclipse.msd.model.core.IChromatogramMSD;
import org.eclipse.chemclipse.msd.model.core.IChromatogramPeakMSD;
import org.eclipse.chemclipse.msd.model.core.selection.ChromatogramSelectionMSD;
import org.eclipse.chemclipse.msd.model.core.selection.IChromatogramSelectionMSD;
import org.eclipse.chemclipse.numeric.statistics.WindowSize;
import org.eclipse.chemclipse.processing.core.IProcessingInfo;
import org.eclipse.core.runtime.IProgressMonitor;

public class AlkanePatternDetectorMSD {
    private static final Logger logger = Logger.getLogger(AlkanePatternDetectorMSD.class);

    public IChromatogramMSD parseChromatogram(String chromatogramPath, String pathRetentionIndexFile, boolean useAlreadyDetectedPeaks, IProgressMonitor monitor) {
        IChromatogramMSD chromatogramMSD = null;
        try {
            List<IChromatogramPeakMSD> peaks;
            File file = new File(chromatogramPath);
            IProcessingInfo processingInfo = ChromatogramConverterMSD.getInstance().convert(file, monitor);
            chromatogramMSD = (IChromatogramMSD)processingInfo.getProcessingResult();
            ChromatogramSelectionMSD chromatogramSelectionMSD = new ChromatogramSelectionMSD(chromatogramMSD);
            if (useAlreadyDetectedPeaks) {
                peaks = this.extractPeaks(chromatogramMSD);
            } else {
                chromatogramMSD.removeAllPeaks();
                PeakDetectorMSD peakDetectorMSD = new PeakDetectorMSD();
                PeakDetectorSettingsMSD peakDetectorSettings = new PeakDetectorSettingsMSD();
                peakDetectorSettings.setThreshold(Threshold.LOW);
                peakDetectorSettings.setIncludeBackground(false);
                peakDetectorSettings.setMinimumSignalToNoiseRatio(50.0f);
                peakDetectorSettings.setMovingAverageWindowSize(WindowSize.WIDTH_5);
                peakDetectorMSD.detect((IChromatogramSelectionMSD)chromatogramSelectionMSD, (IPeakDetectorSettingsMSD)peakDetectorSettings, monitor);
                PeakIntegrator peakIntegrator = new PeakIntegrator();
                PeakIntegrationSettings peakIntegratorSettings = new PeakIntegrationSettings();
                peakIntegratorSettings.setIncludeBackground(false);
                AreaSupport areaSupport = new AreaSupport();
                areaSupport.setMinimumArea(0.0);
                IIntegrationSupport integrationSupport = peakIntegratorSettings.getIntegrationSupport();
                integrationSupport.setMinimumPeakWidth(0);
                integrationSupport.setMinimumSignalToNoiseRatio(0.0f);
                peakIntegratorSettings.getSelectedIons().clear();
                peakIntegrator.integrate((IChromatogramSelection)chromatogramSelectionMSD, monitor);
                peaks = this.extractPeaks(chromatogramMSD);
            }
            if (!"".equals(pathRetentionIndexFile)) {
                RetentionIndexCalculator retentionIndexCalculator = new RetentionIndexCalculator();
                CalculatorSettings calculatorSettings = new CalculatorSettings();
                ArrayList<String> retentionIndexFiles = new ArrayList<String>();
                retentionIndexFiles.add(pathRetentionIndexFile);
                calculatorSettings.setRetentionIndexFiles(retentionIndexFiles);
                retentionIndexCalculator.apply((IChromatogramSelection)chromatogramSelectionMSD, calculatorSettings, monitor);
            }
            PeakIdentifier peakIdentifier = new PeakIdentifier();
            IPeakIdentifierSettingsMSD peakIdentifierSettings = null;
            peakIdentifier.identify(peaks, peakIdentifierSettings, monitor);
        }
        catch (Exception e) {
            logger.error((Object)e.getLocalizedMessage(), (Throwable)e);
        }
        return chromatogramMSD;
    }

    private List<IChromatogramPeakMSD> extractPeaks(IChromatogramMSD chromatogramMSD) {
        ArrayList<IChromatogramPeakMSD> peaks = new ArrayList<IChromatogramPeakMSD>();
        for (IChromatogramPeakMSD peak : chromatogramMSD.getPeaks()) {
            peaks.add(peak);
        }
        return peaks;
    }
}

