/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.chromatogram.xxd.calculator.supplier.amdiscalri.ui.editors;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.chemclipse.chromatogram.xxd.calculator.supplier.amdiscalri.impl.CalibrationFile;
import org.eclipse.chemclipse.chromatogram.xxd.calculator.supplier.amdiscalri.preferences.PreferenceSupplier;
import org.eclipse.chemclipse.chromatogram.xxd.calculator.supplier.amdiscalri.ui.editors.CalibrationFileListUtil;
import org.eclipse.chemclipse.chromatogram.xxd.calculator.supplier.amdiscalri.ui.swt.CalibrationFileListUI;
import org.eclipse.chemclipse.support.ui.workbench.DisplayUtils;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Widget;

public class CalibrationTableEditor
extends FieldEditor {
    private CalibrationFileListUI calibrationFileListUI;
    private Composite compositeButtons;
    private Button buttonAdd;
    private Button buttonRemove;
    private Button buttonClear;
    private SelectionListener selectionListener;
    private String[] filterExtensions;
    private String[] filterNames;
    private CalibrationFileListUtil calibrationFileListUtil = new CalibrationFileListUtil();

    public CalibrationTableEditor(String name, String labelText, Composite parent) {
        this.init(name, labelText);
        this.createControl(parent);
    }

    public void setEnabled(boolean enabled, Composite parent) {
        super.setEnabled(enabled, parent);
        this.getTableControl(parent).getTable().setEnabled(enabled);
        this.buttonAdd.setEnabled(enabled);
        this.buttonRemove.setEnabled(enabled);
        this.buttonClear.setEnabled(enabled);
    }

    public void setFocus() {
        if (this.calibrationFileListUI != null) {
            this.calibrationFileListUI.getTable().setFocus();
        }
    }

    public int getNumberOfControls() {
        return 2;
    }

    public void setFilterExtensionsAndNames(String[] filterExtensions, String[] filterNames) {
        this.filterExtensions = filterExtensions;
        this.filterNames = filterNames;
    }

    protected CalibrationFileListUI getListUI() {
        return this.calibrationFileListUI;
    }

    protected void adjustForNumColumns(int numColumns) {
        Label control = this.getLabelControl();
        ((GridData)control.getLayoutData()).horizontalSpan = numColumns;
        ((GridData)this.calibrationFileListUI.getTable().getLayoutData()).horizontalSpan = numColumns - 1;
    }

    protected void doLoad() {
        if (this.calibrationFileListUI != null) {
            String storedContent = this.getPreferenceStore().getString(this.getPreferenceName());
            if (storedContent == null || "".equals(storedContent)) {
                this.calibrationFileListUI.setInput(null);
            } else {
                this.calibrationFileListUI.setInput(this.getCalibrationFiles(storedContent));
            }
        }
    }

    protected void doLoadDefault() {
        if (this.calibrationFileListUI != null) {
            String storedContent = this.getPreferenceStore().getDefaultString(this.getPreferenceName());
            if (storedContent == null || "".equals(storedContent)) {
                this.calibrationFileListUI.setInput(null);
            } else {
                this.calibrationFileListUI.setInput(this.getCalibrationFiles(storedContent));
            }
        }
    }

    protected void doStore() {
        TableItem[] tableItems = this.calibrationFileListUI.getTable().getItems();
        String[] items = new String[tableItems.length];
        int i = 0;
        while (i < tableItems.length) {
            Object object = tableItems[i].getData();
            String file = "";
            if (object instanceof CalibrationFile) {
                CalibrationFile calibrationFile = (CalibrationFile)object;
                file = calibrationFile.getFile().getAbsolutePath();
            }
            items[i] = file;
            ++i;
        }
        String storedContent = this.calibrationFileListUtil.createList(items);
        if (storedContent != null) {
            this.getPreferenceStore().setValue(this.getPreferenceName(), storedContent);
        }
    }

    protected void doFillIntoGrid(Composite parent, int numColumns) {
        Label control = this.getLabelControl(parent);
        GridData gridDataControl = new GridData();
        gridDataControl.horizontalSpan = numColumns;
        control.setLayoutData((Object)gridDataControl);
        GridData gridDataTable = new GridData(1808);
        gridDataTable.verticalAlignment = 4;
        gridDataTable.horizontalAlignment = 4;
        gridDataTable.horizontalSpan = numColumns - 1;
        gridDataTable.grabExcessHorizontalSpace = true;
        this.calibrationFileListUI = this.getTableControl(parent);
        this.calibrationFileListUI.getTable().setLayoutData((Object)gridDataTable);
        GridData gridDataButtons = new GridData();
        gridDataButtons.verticalAlignment = 1;
        this.compositeButtons = this.getButtonControl(parent);
        this.compositeButtons.setLayoutData((Object)gridDataButtons);
    }

    private void createButtons(Composite composite) {
        this.buttonAdd = this.createButton(composite, "Add", "Add a new calibration file.");
        this.buttonRemove = this.createButton(composite, "Remove", "Remove the selected calibration file.");
        this.buttonClear = this.createButton(composite, "Clear", "Remove all calibration files.");
    }

    private Button createButton(Composite parent, String text, String tooltip) {
        Button button = new Button(parent, 8);
        button.setText(text);
        button.setToolTipText(tooltip);
        button.setFont(parent.getFont());
        GridData data = new GridData(768);
        int widthHint = this.convertHorizontalDLUsToPixels((Control)button, 61);
        data.widthHint = Math.max(widthHint, button.computeSize((int)-1, (int)-1, (boolean)true).x);
        button.setLayoutData((Object)data);
        button.addSelectionListener(this.getSelectionListener());
        return button;
    }

    private SelectionListener getSelectionListener() {
        if (this.selectionListener == null) {
            this.selectionListener = new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    Widget widget = event.widget;
                    if (widget == CalibrationTableEditor.this.buttonAdd) {
                        CalibrationTableEditor.this.addPressed();
                    } else if (widget == CalibrationTableEditor.this.buttonRemove) {
                        CalibrationTableEditor.this.removePressed();
                    } else if (widget == CalibrationTableEditor.this.buttonClear) {
                        CalibrationTableEditor.this.clearPressed();
                    } else if (widget == CalibrationTableEditor.this.calibrationFileListUI.getTable()) {
                        CalibrationTableEditor.this.selectionChanged();
                    }
                }
            };
        }
        return this.selectionListener;
    }

    private void addPressed() {
        this.setPresentsDefaultValue(false);
        CalibrationFile calibrationFile = this.selectCalibrationFile();
        if (calibrationFile != null) {
            this.calibrationFileListUI.add(calibrationFile);
            this.selectionChanged();
        }
    }

    private void removePressed() {
        this.setPresentsDefaultValue(false);
        Table table = this.calibrationFileListUI.getTable();
        int index = table.getSelectionIndex();
        if (index >= 0) {
            table.remove(index);
            table.select(index >= table.getItemCount() ? index - 1 : index);
            this.selectionChanged();
        }
    }

    private void clearPressed() {
        this.setPresentsDefaultValue(false);
        this.calibrationFileListUI.getTable().removeAll();
    }

    private void selectionChanged() {
        int index = this.calibrationFileListUI.getTable().getSelectionIndex();
        this.buttonRemove.setEnabled(index >= 0);
        this.buttonClear.setEnabled(index >= 0);
    }

    private CalibrationFile selectCalibrationFile() {
        String filterPath;
        CalibrationFile calibrationFile = null;
        FileDialog fileDialog = new FileDialog(DisplayUtils.getShell((Widget)this.buttonAdd), 4096);
        fileDialog.setText("Select New Calibration File");
        fileDialog.setFilterPath(PreferenceSupplier.getFilterPathIndexFiles());
        if (this.filterExtensions != null && this.filterNames != null) {
            fileDialog.setFilterExtensions(this.filterExtensions);
            fileDialog.setFilterNames(this.filterNames);
        }
        if ((filterPath = fileDialog.open()) != null) {
            TableItem[] tableItems;
            File file = new File(filterPath);
            PreferenceSupplier.setFilterPathIndexFiles((String)file.getParentFile().getAbsolutePath());
            calibrationFile = new CalibrationFile(file);
            TableItem[] tableItemArray = tableItems = this.calibrationFileListUI.getTable().getItems();
            int n = tableItems.length;
            int n2 = 0;
            while (n2 < n) {
                TableItem tableItem = tableItemArray[n2];
                Object object = tableItem.getData();
                if (object instanceof CalibrationFile && ((CalibrationFile)object).equals((Object)calibrationFile)) {
                    calibrationFile = null;
                    break;
                }
                ++n2;
            }
        }
        return calibrationFile;
    }

    private List<CalibrationFile> getCalibrationFiles(String storedContent) {
        String[] files = this.calibrationFileListUtil.parseString(storedContent);
        ArrayList<CalibrationFile> calibrationFiles = new ArrayList<CalibrationFile>();
        String[] stringArray = files;
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            String file = stringArray[n2];
            calibrationFiles.add(new CalibrationFile(new File(file)));
            ++n2;
        }
        return calibrationFiles;
    }

    private Composite getButtonControl(Composite parent) {
        if (this.compositeButtons == null) {
            this.compositeButtons = new Composite(parent, 0);
            GridLayout layout = new GridLayout();
            layout.marginWidth = 0;
            this.compositeButtons.setLayout((Layout)layout);
            this.createButtons(this.compositeButtons);
            this.compositeButtons.addDisposeListener(event -> {
                this.buttonAdd = null;
                this.buttonRemove = null;
                this.buttonClear = null;
                this.compositeButtons = null;
            });
        } else {
            this.checkParent((Control)this.compositeButtons, parent);
        }
        this.selectionChanged();
        return this.compositeButtons;
    }

    private CalibrationFileListUI getTableControl(Composite parent) {
        if (this.calibrationFileListUI == null) {
            this.calibrationFileListUI = new CalibrationFileListUI(parent, 2820);
            this.calibrationFileListUI.getTable().addSelectionListener(this.getSelectionListener());
        } else {
            this.checkParent((Control)this.calibrationFileListUI.getTable(), parent);
        }
        return this.calibrationFileListUI;
    }
}

