/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.chromatogram.xxd.baseline.detector.supplier.smoothed.core;

import org.eclipse.chemclipse.chromatogram.xxd.baseline.detector.core.AbstractBaselineDetector;
import org.eclipse.chemclipse.chromatogram.xxd.baseline.detector.settings.IBaselineDetectorSettings;
import org.eclipse.chemclipse.chromatogram.xxd.baseline.detector.supplier.smoothed.preferences.PreferenceSupplier;
import org.eclipse.chemclipse.chromatogram.xxd.baseline.detector.supplier.smoothed.settings.DetectorSettings;
import org.eclipse.chemclipse.model.baseline.IBaselineModel;
import org.eclipse.chemclipse.model.core.IChromatogram;
import org.eclipse.chemclipse.model.exceptions.ChromatogramIsNullException;
import org.eclipse.chemclipse.model.selection.IChromatogramSelection;
import org.eclipse.chemclipse.model.signals.ITotalScanSignal;
import org.eclipse.chemclipse.model.signals.ITotalScanSignals;
import org.eclipse.chemclipse.model.signals.TotalScanSignalExtractor;
import org.eclipse.chemclipse.model.signals.TotalScanSignalsModifier;
import org.eclipse.chemclipse.model.support.ScanRange;
import org.eclipse.chemclipse.numeric.statistics.Calculations;
import org.eclipse.chemclipse.numeric.statistics.WindowSize;
import org.eclipse.chemclipse.processing.core.IProcessingInfo;
import org.eclipse.core.runtime.IProgressMonitor;

public class BaselineDetector
extends AbstractBaselineDetector {
    private static WindowSize WINDOW_SIZE = WindowSize.WIDTH_7;

    public IProcessingInfo setBaseline(IChromatogramSelection chromatogramSelection, IBaselineDetectorSettings baselineDetectorSettings, IProgressMonitor monitor) {
        IProcessingInfo processingInfo = super.validate(chromatogramSelection, baselineDetectorSettings, monitor);
        if (!processingInfo.hasErrorMessages() && baselineDetectorSettings instanceof DetectorSettings) {
            this.calculateBaseline(chromatogramSelection);
        }
        return processingInfo;
    }

    public IProcessingInfo setBaseline(IChromatogramSelection chromatogramSelection, IProgressMonitor monitor) {
        DetectorSettings detectorSettings = PreferenceSupplier.getDetectorSettings();
        return this.setBaseline(chromatogramSelection, (IBaselineDetectorSettings)detectorSettings, monitor);
    }

    private void calculateBaseline(IChromatogramSelection chromatogramSelection) {
        TotalScanSignalExtractor totalScanSignalExtractor;
        int stopScan;
        IChromatogram chromatogram = chromatogramSelection.getChromatogram();
        int startScan = chromatogram.getScanNumber(chromatogramSelection.getStartRetentionTime());
        ScanRange scanRange = new ScanRange(startScan, stopScan = chromatogram.getScanNumber(chromatogramSelection.getStopRetentionTime()));
        if (scanRange.getWidth() <= WINDOW_SIZE.getSize()) {
            return;
        }
        int windowScanRange = this.calculateWindowScanRange(chromatogram.getScanInterval(), 150, 500);
        try {
            totalScanSignalExtractor = new TotalScanSignalExtractor(chromatogram);
        }
        catch (ChromatogramIsNullException e) {
            return;
        }
        ITotalScanSignals totalIonSignals = totalScanSignalExtractor.getTotalScanSignals(startScan, stopScan);
        int scan = startScan;
        while (scan <= stopScan) {
            ITotalScanSignal totalIonSignal = totalIonSignals.getTotalScanSignal(scan);
            float baselineTotalSignal = this.getMinTotalSignal(scan, scan + windowScanRange, totalIonSignals);
            totalIonSignal.setTotalSignal(baselineTotalSignal);
            ++scan;
        }
        TotalScanSignalsModifier.calculateMovingAverage((ITotalScanSignals)totalIonSignals, (WindowSize)WINDOW_SIZE);
        IBaselineModel baselineModel = chromatogram.getBaselineModel();
        this.applyBaseline(baselineModel, totalIonSignals, startScan, stopScan);
    }

    private void applyBaseline(IBaselineModel baselineModel, ITotalScanSignals totalIonSignals, int startScan, int stopScan) {
        int scan = startScan;
        while (scan < stopScan) {
            ITotalScanSignal actualTotalIonSignal = totalIonSignals.getTotalScanSignal(scan);
            ITotalScanSignal nextTotalIonSignal = totalIonSignals.getNextTotalScanSignal(scan);
            int startRetentionTime = actualTotalIonSignal.getRetentionTime();
            float startBackgroundAbundance = actualTotalIonSignal.getTotalSignal();
            int stopRetentionTime = nextTotalIonSignal.getRetentionTime();
            float stopBackgroundAbundance = nextTotalIonSignal.getTotalSignal();
            baselineModel.addBaseline(startRetentionTime, stopRetentionTime, startBackgroundAbundance, stopBackgroundAbundance, false);
            ++scan;
        }
    }

    private float getMinTotalSignal(int startScan, int stopScan, ITotalScanSignals totalIonSignals) {
        int count = stopScan - startScan + 1;
        float[] values = new float[count];
        int scan = startScan;
        int i = 0;
        while (scan <= stopScan) {
            ITotalScanSignal totalIonSignal = totalIonSignals.getTotalScanSignal(scan);
            if (totalIonSignal != null) {
                values[i] = totalIonSignal.getTotalSignal();
            }
            ++scan;
            ++i;
        }
        return Calculations.getMin((float[])values);
    }

    private int calculateWindowScanRange(int actualScanInterval, int scans, int scanInterval) {
        if (actualScanInterval <= 0) {
            return 0;
        }
        int window = scans * scanInterval;
        return window / actualScanInterval;
    }
}

