/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.chromatogram.msd.process.supplier.batchprocess.core;

import org.eclipse.chemclipse.chromatogram.msd.process.supplier.batchprocess.model.BatchProcessJob;
import org.eclipse.chemclipse.converter.model.IChromatogramInputEntry;
import org.eclipse.chemclipse.logging.core.Logger;
import org.eclipse.chemclipse.model.selection.IChromatogramSelection;
import org.eclipse.chemclipse.model.supplier.IChromatogramSelectionProcessSupplier;
import org.eclipse.chemclipse.model.types.DataType;
import org.eclipse.chemclipse.processing.core.IProcessingInfo;
import org.eclipse.chemclipse.processing.core.MessageConsumer;
import org.eclipse.chemclipse.processing.core.ProcessingInfo;
import org.eclipse.chemclipse.processing.core.exceptions.TypeCastException;
import org.eclipse.chemclipse.processing.methods.IProcessMethod;
import org.eclipse.chemclipse.processing.methods.ProcessEntryContainer;
import org.eclipse.chemclipse.processing.supplier.ProcessExecutionConsumer;
import org.eclipse.chemclipse.processing.supplier.ProcessExecutionContext;
import org.eclipse.chemclipse.processing.supplier.ProcessSupplierContext;
import org.eclipse.chemclipse.xxd.process.support.ChromatogramTypeSupport;
import org.eclipse.chemclipse.xxd.process.support.ProcessTypeSupport;
import org.eclipse.core.runtime.IProgressMonitor;

public class BatchProcess {
    private static final Logger logger = Logger.getLogger(BatchProcess.class);
    private static final String DESCRIPTION = "Batch Processor";
    private final ChromatogramTypeSupport chromatogramTypeSupport;
    private final ProcessSupplierContext processSupplierContext;

    @Deprecated
    public BatchProcess() {
        this(new DataType[]{DataType.CSD, DataType.MSD, DataType.WSD}, (ProcessSupplierContext)new ProcessTypeSupport());
    }

    public BatchProcess(DataType[] dataTypes, ProcessSupplierContext processSupplierContext) {
        this.processSupplierContext = processSupplierContext;
        this.chromatogramTypeSupport = new ChromatogramTypeSupport(dataTypes);
    }

    public IProcessingInfo<?> execute(BatchProcessJob batchProcessJob, IProgressMonitor monitor) {
        ProcessingInfo processingInfo = new ProcessingInfo();
        if (batchProcessJob == null || batchProcessJob.getProcessMethod() == null) {
            processingInfo.addErrorMessage(DESCRIPTION, "The batch job and/or process method was null.");
        } else {
            IProcessMethod processMethod = batchProcessJob.getProcessMethod();
            for (IChromatogramInputEntry chromatogramInput : batchProcessJob.getChromatogramInputEntries()) {
                String pathChromatogram = chromatogramInput.getInputFile();
                IProcessingInfo processingInfoX = this.chromatogramTypeSupport.getChromatogramSelection(pathChromatogram, monitor);
                if (!processingInfoX.hasErrorMessages()) {
                    try {
                        IChromatogramSelection chromatogramSelection = (IChromatogramSelection)processingInfoX.getProcessingResult();
                        ProcessingInfo processorResult = new ProcessingInfo();
                        ProcessEntryContainer.applyProcessEntries((ProcessEntryContainer)processMethod, (ProcessExecutionContext)new ProcessExecutionContext(monitor, (MessageConsumer)processorResult, this.processSupplierContext), (ProcessExecutionConsumer)IChromatogramSelectionProcessSupplier.createConsumer((IChromatogramSelection)chromatogramSelection));
                        if (processorResult.hasErrorMessages()) {
                            processingInfo.addErrorMessage(DESCRIPTION, "Processing: " + pathChromatogram + " failed");
                        } else {
                            processingInfo.addInfoMessage(DESCRIPTION, "Processing: " + pathChromatogram + " completed");
                        }
                        processingInfo.addMessages((IProcessingInfo)processorResult);
                    }
                    catch (TypeCastException e) {
                        logger.warn((Object)e);
                        processingInfo.addErrorMessage(DESCRIPTION, "Failure to process: " + pathChromatogram);
                    }
                    continue;
                }
                processingInfo.addErrorMessage(DESCRIPTION, "Failure to process: " + pathChromatogram);
            }
        }
        return processingInfo;
    }
}

