/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.chromatogram.msd.peak.detector.supplier.amdis.internal.identifier;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import org.eclipse.chemclipse.chromatogram.msd.peak.detector.supplier.amdis.internal.identifier.AMDISParser;
import org.eclipse.chemclipse.chromatogram.msd.peak.detector.supplier.amdis.preferences.PreferenceSupplier;
import org.eclipse.chemclipse.chromatogram.msd.peak.detector.supplier.amdis.runtime.IExtendedRuntimeSupport;
import org.eclipse.chemclipse.chromatogram.msd.peak.detector.supplier.amdis.runtime.RuntimeSupportFactory;
import org.eclipse.chemclipse.chromatogram.msd.peak.detector.supplier.amdis.settings.IOnsiteSettings;
import org.eclipse.chemclipse.chromatogram.msd.peak.detector.supplier.amdis.settings.PeakDetectorSettings;
import org.eclipse.chemclipse.chromatogram.msd.peak.detector.supplier.amdis.support.PeakProcessorSupport;
import org.eclipse.chemclipse.model.core.IChromatogram;
import org.eclipse.chemclipse.model.core.IPeaks;
import org.eclipse.chemclipse.msd.converter.chromatogram.ChromatogramConverterMSD;
import org.eclipse.chemclipse.msd.model.core.IChromatogramMSD;
import org.eclipse.chemclipse.msd.model.core.selection.IChromatogramSelectionMSD;
import org.eclipse.chemclipse.processing.core.DefaultProcessingResult;
import org.eclipse.chemclipse.processing.core.IProcessingInfo;
import org.eclipse.chemclipse.processing.core.IProcessingMessage;
import org.eclipse.chemclipse.processing.core.IProcessingResult;
import org.eclipse.chemclipse.support.settings.OperatingSystemUtils;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;

public class AmdisIdentifier {
    public static final String IDENTIFIER = "AMDIS Identifier";
    private static final String CONVERTER_ID = "net.openchrom.msd.converter.supplier.cdf";

    public IProcessingResult<Void> calulateAndSetDeconvolutedPeaks(IChromatogramSelectionMSD chromatogramSelection, PeakDetectorSettings peakDetectorSettings, IProgressMonitor monitor) throws InterruptedException {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        DefaultProcessingResult result = new DefaultProcessingResult();
        IChromatogramMSD chromatogram = chromatogramSelection.getChromatogramMSD();
        IOnsiteSettings onsiteSettings = peakDetectorSettings.getOnsiteSettings();
        String amdisTmpPath = PreferenceSupplier.getAmdisTmpPath();
        File file = new File(String.valueOf(amdisTmpPath) + File.separator + chromatogram.getName());
        IProcessingInfo processingInfo = ChromatogramConverterMSD.getInstance().convert(file, (IChromatogram)chromatogram, CONVERTER_ID, (IProgressMonitor)subMonitor.split(10));
        if (processingInfo == null) {
            result.addErrorMessage(IDENTIFIER, "Conversion to CDF returned no result");
            return result;
        }
        for (IProcessingMessage message : processingInfo.getMessages()) {
            result.addMessage(message);
        }
        File fileChromatogram = (File)processingInfo.getProcessingResult();
        if (fileChromatogram == null) {
            result.addErrorMessage(IDENTIFIER, "Conversion to CDF returned no file");
            return result;
        }
        if (result.hasErrorMessages()) {
            return result;
        }
        try {
            AMDISParser parser = new AMDISParser(fileChromatogram);
            IProcessingResult<IPeaks> amdisPeaks = this.executeAMDIS(fileChromatogram, onsiteSettings, parser, (IProgressMonitor)subMonitor.split(80));
            result.addMessages(amdisPeaks);
            if (result.hasErrorMessages()) {
                DefaultProcessingResult defaultProcessingResult = result;
                return defaultProcessingResult;
            }
            IPeaks peaks = (IPeaks)amdisPeaks.getProcessingResult();
            if (peaks == null) {
                result.addErrorMessage(IDENTIFIER, "Parsing peaks does not return a result");
                DefaultProcessingResult defaultProcessingResult = result;
                return defaultProcessingResult;
            }
            IProcessingResult<Void> insertPeaks = PeakProcessorSupport.insertPeaks(chromatogramSelection, peaks.getPeaks(), peakDetectorSettings, (IProgressMonitor)subMonitor.split(10));
            result.addMessages(insertPeaks);
        }
        finally {
            fileChromatogram.delete();
        }
        return result;
    }

    private IProcessingResult<IPeaks> executeAMDIS(File fileChromatogram, IOnsiteSettings onsiteSettings, AMDISParser parser, IProgressMonitor monitor) throws InterruptedException {
        IExtendedRuntimeSupport runtimeSupport;
        String amdisApplication = PreferenceSupplier.getAmdisApplication();
        String filePath = this.getAmdisCompatibleFilePath(fileChromatogram);
        try {
            runtimeSupport = RuntimeSupportFactory.getRuntimeSupport(amdisApplication, filePath);
        }
        catch (FileNotFoundException e) {
            return this.createErrorResult("Can't get AMDIS executable, make sure that AMDIS is installed and the configuration points to the right AMDIS location", e);
        }
        try {
            runtimeSupport.getAmdisSupport().modifySettings(onsiteSettings);
            try {
                runtimeSupport.executeRunCommand();
            }
            catch (IOException e) {
                IProcessingResult iProcessingResult = this.createErrorResult("Can't execute AMDIS", e);
                try {
                    runtimeSupport.executeKillCommand();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                return iProcessingResult;
            }
            IProcessingResult<IPeaks> iProcessingResult = parser.parse(monitor);
            return iProcessingResult;
        }
        finally {
            try {
                runtimeSupport.executeKillCommand();
            }
            catch (IOException iOException) {}
        }
    }

    private <T> IProcessingResult<T> createErrorResult(String msg, Exception e) {
        DefaultProcessingResult errorResult = new DefaultProcessingResult();
        errorResult.addErrorMessage(IDENTIFIER, String.valueOf(msg) + ": " + e.getMessage());
        return errorResult;
    }

    private String getAmdisCompatibleFilePath(File fileChromatogram) {
        String filePath = "";
        String amdisTmpPath = PreferenceSupplier.getAmdisTmpPath();
        if (OperatingSystemUtils.isWindows()) {
            filePath = String.valueOf(amdisTmpPath) + File.separator + fileChromatogram.getName();
        } else {
            String wineTmpPath = String.valueOf(amdisTmpPath) + File.separator + fileChromatogram.getName();
            if (wineTmpPath.contains(".wine/dosdevices/")) {
                String[] vals = wineTmpPath.split("/dosdevices/");
                if (vals.length == 2) {
                    filePath = vals[1].replace("/", "\\");
                }
            } else if (wineTmpPath.contains(".wine/drive_")) {
                String[] vals = wineTmpPath.split("/drive_");
                if (vals.length == 2) {
                    filePath = vals[1].replaceFirst("([a-zA-z])(/)(.*)", "$1:$2$3");
                    filePath = filePath.replace("/", "\\");
                }
            } else {
                filePath = "C:\\tmp\\" + fileChromatogram.getName();
            }
        }
        return filePath;
    }
}

