/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.chromatogram.msd.identifier.supplier.file.model;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import org.eclipse.chemclipse.logging.core.Logger;
import org.eclipse.chemclipse.model.columns.ISeparationColumn;
import org.eclipse.chemclipse.model.columns.SeparationColumn;
import org.eclipse.chemclipse.model.columns.SeparationColumnFactory;

public class IdentifierFileReader {
    private static final Logger logger = Logger.getLogger(IdentifierFileReader.class);

    public ISeparationColumn parse(File file) {
        ISeparationColumn separationColumn = SeparationColumnFactory.getSeparationColumn((String)"DEFAULT");
        if (this.isSeparationColumnFile(file)) {
            separationColumn = this.extractSeparationColumn(file);
        }
        return separationColumn;
    }

    private ISeparationColumn extractSeparationColumn(File file) {
        ISeparationColumn separationColumn = SeparationColumnFactory.getSeparationColumn((String)"DEFAULT");
        try {
            String line;
            BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
            String name = "DEFAULT";
            String length = "";
            String diameter = "";
            String phase = "";
            while ((line = bufferedReader.readLine()) != null) {
                if (!line.startsWith("#")) continue;
                if (line.startsWith("#COLUMN_NAME")) {
                    name = this.getValue(line);
                    continue;
                }
                if (line.startsWith("#COLUMN_LENGTH")) {
                    length = this.getValue(line);
                    continue;
                }
                if (line.startsWith("#COLUMN_DIAMETER")) {
                    diameter = this.getValue(line);
                    continue;
                }
                if (!line.startsWith("#COLUMN_PHASE")) continue;
                phase = this.getValue(line);
            }
            separationColumn = new SeparationColumn(name, length, diameter, phase);
            bufferedReader.close();
        }
        catch (IOException e) {
            logger.error((Object)e);
        }
        return separationColumn;
    }

    private boolean isSeparationColumnFile(File file) {
        String name;
        boolean isSeparationColumnFile = false;
        if (file != null && file.exists() && ((name = file.getName().toLowerCase()).endsWith(".msl") || name.endsWith(".msp"))) {
            isSeparationColumnFile = true;
        }
        return isSeparationColumnFile;
    }

    private String getValue(String line) {
        String value = "";
        String[] values = line.split("=");
        if (values.length == 2) {
            value = values[1].trim();
        }
        return value;
    }
}

