/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.chromatogram.msd.classifier.supplier.wnc.ui.internal.provider;

import java.text.DecimalFormat;
import org.eclipse.chemclipse.chromatogram.msd.classifier.supplier.wnc.model.IWncIon;
import org.eclipse.chemclipse.rcp.ui.icons.core.ApplicationImageFactory;
import org.eclipse.chemclipse.support.ui.provider.AbstractChemClipseLabelProvider;
import org.eclipse.swt.graphics.Image;

public class WncResultsLabelProvider
extends AbstractChemClipseLabelProvider {
    public Image getColumnImage(Object element, int columnIndex) {
        if (columnIndex == 0) {
            return this.getImage(element);
        }
        return null;
    }

    public String getColumnText(Object element, int columnIndex) {
        DecimalFormat decimalFormat = this.getDecimalFormat();
        String text = "";
        if (element instanceof IWncIon) {
            IWncIon wncIon = (IWncIon)element;
            switch (columnIndex) {
                case 0: {
                    text = wncIon.getName();
                    break;
                }
                case 1: {
                    text = Integer.toString(wncIon.getIon());
                    break;
                }
                case 2: {
                    text = decimalFormat.format(wncIon.getPercentageSumIntensity());
                    break;
                }
                case 3: {
                    text = decimalFormat.format(wncIon.getPercentageMaxIntensity());
                    break;
                }
                default: {
                    text = "n.v.";
                }
            }
        }
        return text;
    }

    public Image getImage(Object element) {
        return ApplicationImageFactory.getInstance().getImage("org.eclipse.chemclipse.rcp.ui.icons/ion.gif", "16x16");
    }
}

