/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.chromatogram.xxd.calculator.io;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.FileUtils;
import org.eclipse.chemclipse.logging.core.Logger;
import org.eclipse.chemclipse.model.columns.IRetentionIndexEntry;
import org.eclipse.chemclipse.model.columns.ISeparationColumn;
import org.eclipse.chemclipse.model.columns.ISeparationColumnIndices;
import org.eclipse.chemclipse.model.columns.RetentionIndexEntry;
import org.eclipse.chemclipse.model.columns.SeparationColumnIndices;
import org.eclipse.chemclipse.processing.core.IProcessingInfo;
import org.eclipse.chemclipse.processing.core.ProcessingInfo;

public class MassLibConverter {
    private static final Logger logger = Logger.getLogger(MassLibConverter.class);
    private Pattern patternColumn = Pattern.compile("(INFO1:)(\\s+)(\\w+)(\\s+)(\\w+-?\\w+)");
    private Pattern patternIndices = Pattern.compile("(RETIND:)(\\s+)(\\d+:\\d+:?\\d+)(\\s+)(\\d*)");
    private Pattern patternTargets = Pattern.compile("(SCANDESC:)(\\s+)(\\d+)(\\s+)(')(.*)(')");

    public IProcessingInfo<ISeparationColumnIndices> parseRetentionIndices(File file) {
        ProcessingInfo processingInfo = new ProcessingInfo();
        SeparationColumnIndices separationColumnIndices = new SeparationColumnIndices();
        ISeparationColumn separationColumn = separationColumnIndices.getSeparationColumn();
        try {
            String content = FileUtils.readFileToString((File)file);
            Matcher matcherColumn = this.patternColumn.matcher(content);
            while (matcherColumn.find()) {
                String length = matcherColumn.group(3).trim();
                String name = matcherColumn.group(5).trim();
                separationColumn.setName(name);
                separationColumn.setLength(length);
            }
            Matcher matcherIndices = this.patternIndices.matcher(content);
            while (matcherIndices.find()) {
                String[] values = matcherIndices.group(3).trim().split(":");
                String value = "";
                if (values.length == 2) {
                    String minutes = values[0];
                    String seconds = values[1];
                    value = String.valueOf(minutes) + "." + seconds;
                } else if (values.length == 3) {
                    String hours = values[0];
                    String minutes = values[1];
                    String seconds = values[2];
                    if (!"0".equals(hours)) {
                        int h = this.getInteger(hours);
                        int m = this.getInteger(minutes);
                        minutes = Integer.toString(h * 60 + m);
                    }
                    value = String.valueOf(minutes) + "." + seconds;
                }
                int retentionTime = (int)(this.getDouble(value) * 60000.0);
                float retentionIndex = this.getFloat(matcherIndices.group(5).trim());
                separationColumnIndices.put((IRetentionIndexEntry)new RetentionIndexEntry(retentionTime, retentionIndex, ""));
            }
        }
        catch (IOException e) {
            logger.warn((Object)e);
        }
        processingInfo.setProcessingResult((Object)separationColumnIndices);
        return processingInfo;
    }

    public IProcessingInfo<Map<Integer, String>> parseTargets(File file) {
        ProcessingInfo processingInfo = new ProcessingInfo();
        HashMap<Integer, String> targets = new HashMap<Integer, String>();
        try {
            String content = FileUtils.readFileToString((File)file);
            Matcher matcherTargets = this.patternTargets.matcher(content);
            while (matcherTargets.find()) {
                int scan = this.getInteger(matcherTargets.group(3).trim());
                String name = matcherTargets.group(6).trim();
                targets.put(scan, name);
            }
        }
        catch (IOException e) {
            logger.warn((Object)e);
        }
        processingInfo.setProcessingResult(targets);
        return processingInfo;
    }

    private double getDouble(String value) {
        double result = 0.0;
        try {
            result = Double.valueOf(value);
        }
        catch (NumberFormatException e) {
            logger.warn((Object)e);
        }
        return result;
    }

    private float getFloat(String value) {
        float result = 0.0f;
        try {
            result = Float.valueOf(value).floatValue();
        }
        catch (NumberFormatException e) {
            logger.warn((Object)e);
        }
        return result;
    }

    private int getInteger(String value) {
        int result = 0;
        try {
            result = Integer.valueOf(value);
        }
        catch (NumberFormatException e) {
            logger.warn((Object)e);
        }
        return result;
    }
}

