/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.chromatogram.msd.filter.impl;

import org.eclipse.chemclipse.chromatogram.filter.result.ChromatogramFilterResult;
import org.eclipse.chemclipse.chromatogram.filter.result.ResultStatus;
import org.eclipse.chemclipse.chromatogram.filter.settings.IChromatogramFilterSettings;
import org.eclipse.chemclipse.chromatogram.msd.filter.core.chromatogram.AbstractChromatogramFilterMSD;
import org.eclipse.chemclipse.chromatogram.msd.filter.impl.preferences.PreferenceSupplier;
import org.eclipse.chemclipse.chromatogram.msd.filter.impl.settings.FilterSettingsAdjust;
import org.eclipse.chemclipse.logging.core.Logger;
import org.eclipse.chemclipse.model.core.IScan;
import org.eclipse.chemclipse.model.support.IRetentionTimeRange;
import org.eclipse.chemclipse.msd.model.core.IChromatogramMSD;
import org.eclipse.chemclipse.msd.model.core.IIon;
import org.eclipse.chemclipse.msd.model.core.IScanMSD;
import org.eclipse.chemclipse.msd.model.core.selection.IChromatogramSelectionMSD;
import org.eclipse.chemclipse.msd.model.implementation.Ion;
import org.eclipse.chemclipse.msd.model.xic.ExtractedIonSignalExtractor;
import org.eclipse.chemclipse.msd.model.xic.ExtractedIonSignalsModifier;
import org.eclipse.chemclipse.msd.model.xic.IExtractedIonSignal;
import org.eclipse.chemclipse.msd.model.xic.IExtractedIonSignals;
import org.eclipse.chemclipse.processing.core.IProcessingInfo;
import org.eclipse.core.runtime.IProgressMonitor;

public class ChromatogramFilterAdjust
extends AbstractChromatogramFilterMSD {
    private static final Logger logger = Logger.getLogger(ChromatogramFilterAdjust.class);

    public IProcessingInfo applyFilter(IChromatogramSelectionMSD chromatogramSelection, IChromatogramFilterSettings chromatogramFilterSettings, IProgressMonitor monitor) {
        IProcessingInfo processingInfo = this.validate(chromatogramSelection, chromatogramFilterSettings);
        if (!processingInfo.hasErrorMessages() && chromatogramFilterSettings instanceof FilterSettingsAdjust) {
            if (chromatogramSelection instanceof IChromatogramSelectionMSD) {
                IChromatogramSelectionMSD chromatogramSelectionMSD = chromatogramSelection;
                try {
                    IChromatogramMSD chromatogram = (IChromatogramMSD)chromatogramSelectionMSD.getChromatogram();
                    ExtractedIonSignalExtractor extractedIonSignalExtractor = new ExtractedIonSignalExtractor(chromatogram);
                    IExtractedIonSignals extractedIonSignals = extractedIonSignalExtractor.getExtractedIonSignals((IRetentionTimeRange)chromatogramSelection);
                    ExtractedIonSignalsModifier.adjustThresholdTransitions((IExtractedIonSignals)extractedIonSignals);
                    int startScan = chromatogram.getScanNumber(chromatogramSelection.getStartRetentionTime());
                    int stopScan = chromatogram.getScanNumber(chromatogramSelection.getStopRetentionTime());
                    int i = startScan;
                    while (i <= stopScan) {
                        IScan scan = chromatogram.getScan(i);
                        if (scan instanceof IScanMSD) {
                            IScanMSD scanMSD = (IScanMSD)scan;
                            IExtractedIonSignal extractedIonSignalOriginal = scanMSD.getExtractedIonSignal();
                            IExtractedIonSignal extractedIonSignalAdjusted = extractedIonSignals.getExtractedIonSignal(i);
                            int startMZ = extractedIonSignalAdjusted.getStartIon();
                            int stopMZ = extractedIonSignalAdjusted.getStopIon();
                            int j = startMZ;
                            while (j <= stopMZ) {
                                float intensity = extractedIonSignalAdjusted.getAbundance(j);
                                if (intensity > 0.0f && extractedIonSignalOriginal.getAbundance(j) == 0.0f) {
                                    Ion ion = new Ion((double)j, intensity);
                                    scanMSD.addIon((IIon)ion);
                                }
                                ++j;
                            }
                        }
                        ++i;
                    }
                }
                catch (Exception e) {
                    logger.warn((Object)e);
                }
            }
            processingInfo.setProcessingResult((Object)new ChromatogramFilterResult(ResultStatus.OK, "Chromatogram Filter Adjust applied"));
        }
        return processingInfo;
    }

    public IProcessingInfo applyFilter(IChromatogramSelectionMSD chromatogramSelection, IProgressMonitor monitor) {
        FilterSettingsAdjust filterSettings = PreferenceSupplier.getFilterSettingsAdjust();
        return this.applyFilter(chromatogramSelection, (IChromatogramFilterSettings)filterSettings, monitor);
    }
}

