/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.chromatogram.msd.filter.core.peak;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.eclipse.chemclipse.chromatogram.filter.exceptions.NoPeakFilterSupplierAvailableException;
import org.eclipse.chemclipse.chromatogram.filter.settings.IPeakFilterSettings;
import org.eclipse.chemclipse.chromatogram.msd.filter.core.peak.IPeakFilterSupplier;
import org.eclipse.chemclipse.chromatogram.msd.filter.core.peak.IPeakFilterSupport;
import org.eclipse.chemclipse.chromatogram.msd.filter.core.peak.PeakFilter;
import org.eclipse.chemclipse.model.selection.IChromatogramSelection;
import org.eclipse.chemclipse.model.supplier.ChromatogramSelectionProcessorSupplier;
import org.eclipse.chemclipse.model.types.DataType;
import org.eclipse.chemclipse.msd.model.core.selection.IChromatogramSelectionMSD;
import org.eclipse.chemclipse.processing.core.MessageConsumer;
import org.eclipse.chemclipse.processing.supplier.IProcessSupplier;
import org.eclipse.chemclipse.processing.supplier.IProcessTypeSupplier;
import org.eclipse.core.runtime.IProgressMonitor;
import org.osgi.service.component.annotations.Component;

@Component(service={IProcessTypeSupplier.class})
public class PeakFilterProcessSupplier
implements IProcessTypeSupplier {
    public String getCategory() {
        return "Peak Filter";
    }

    public Collection<IProcessSupplier<?>> getProcessorSuppliers() {
        try {
            IPeakFilterSupport support = PeakFilter.getPeakFilterSupport();
            ArrayList list = new ArrayList();
            for (String processorId : support.getAvailableFilterIds()) {
                IPeakFilterSupplier supplier = support.getFilterSupplier(processorId);
                list.add((IProcessSupplier<?>)new PeakFilterProcessorSupplier(supplier, this));
            }
            return list;
        }
        catch (NoPeakFilterSupplierAvailableException e) {
            return Collections.emptyList();
        }
    }

    private static final class PeakFilterProcessorSupplier
    extends ChromatogramSelectionProcessorSupplier<IPeakFilterSettings> {
        public PeakFilterProcessorSupplier(IPeakFilterSupplier supplier, IProcessTypeSupplier parent) {
            super(supplier.getId(), supplier.getFilterName(), supplier.getDescription(), supplier.getSettingsClass(), parent, new DataType[]{DataType.MSD});
        }

        public IChromatogramSelection<?, ?> apply(IChromatogramSelection<?, ?> chromatogramSelection, IPeakFilterSettings processSettings, MessageConsumer messageConsumer, IProgressMonitor monitor) {
            if (chromatogramSelection instanceof IChromatogramSelectionMSD) {
                IChromatogramSelectionMSD chromatogramSelectionMSD = (IChromatogramSelectionMSD)chromatogramSelection;
                if (processSettings instanceof IPeakFilterSettings) {
                    messageConsumer.addMessages(PeakFilter.applyFilter(chromatogramSelectionMSD, processSettings, this.getId(), monitor));
                } else {
                    messageConsumer.addMessages(PeakFilter.applyFilter(chromatogramSelectionMSD, this.getId(), monitor));
                }
            } else {
                messageConsumer.addWarnMessage(this.getName(), "Only MSD chromatograms supported, processing skipped");
            }
            return chromatogramSelection;
        }
    }
}

