/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.chromatogram.msd.filter.core.massspectrum;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import org.eclipse.chemclipse.chromatogram.msd.filter.core.massspectrum.AbstractMassspectrumFilterProcessTypeSupplier;
import org.eclipse.chemclipse.model.core.IChromatogram;
import org.eclipse.chemclipse.model.core.IScan;
import org.eclipse.chemclipse.model.selection.IChromatogramSelection;
import org.eclipse.chemclipse.msd.model.core.IScanMSD;
import org.eclipse.chemclipse.processing.supplier.IProcessTypeSupplier;
import org.osgi.service.component.annotations.Component;

@Component(service={IProcessTypeSupplier.class})
public class ScanMassspectrumFilterProcessTypeSupplier
extends AbstractMassspectrumFilterProcessTypeSupplier {
    public ScanMassspectrumFilterProcessTypeSupplier() {
        super("Scan Massspectrum Filter", "mzfilter.msd.scan.", new Function<IChromatogramSelection<?, ?>, List<IScanMSD>>(){

            @Override
            public List<IScanMSD> apply(IChromatogramSelection<?, ?> chromatogramSelection) {
                ArrayList<IScanMSD> massspectras = new ArrayList<IScanMSD>();
                IChromatogram chromatogram = chromatogramSelection.getChromatogram();
                int startScan = chromatogram.getScanNumber(chromatogramSelection.getStartRetentionTime());
                int stopScan = chromatogram.getScanNumber(chromatogramSelection.getStopRetentionTime());
                int scanIndex = startScan;
                while (scanIndex <= stopScan) {
                    IScan scan = chromatogram.getScan(scanIndex);
                    if (scan instanceof IScanMSD) {
                        massspectras.add((IScanMSD)scan);
                    }
                    ++scanIndex;
                }
                return massspectras;
            }
        });
    }
}

