/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.xxd.converter.supplier.chemclipse.internal.quantitation;

import java.io.DataInputStream;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import org.eclipse.chemclipse.logging.core.Logger;
import org.eclipse.chemclipse.model.core.IIntegrationEntry;
import org.eclipse.chemclipse.model.core.IPeakIntensityValues;
import org.eclipse.chemclipse.model.core.PeakType;
import org.eclipse.chemclipse.model.core.RetentionIndexType;
import org.eclipse.chemclipse.model.exceptions.AbundanceLimitExceededException;
import org.eclipse.chemclipse.model.exceptions.PeakException;
import org.eclipse.chemclipse.model.exceptions.ReferenceMustNotBeNullException;
import org.eclipse.chemclipse.model.identifier.ComparisonResult;
import org.eclipse.chemclipse.model.identifier.IComparisonResult;
import org.eclipse.chemclipse.model.identifier.ILibraryInformation;
import org.eclipse.chemclipse.model.identifier.LibraryInformation;
import org.eclipse.chemclipse.model.identifier.PeakComparisonResult;
import org.eclipse.chemclipse.model.identifier.PeakLibraryInformation;
import org.eclipse.chemclipse.model.implementation.IdentificationTarget;
import org.eclipse.chemclipse.model.implementation.IntegrationEntry;
import org.eclipse.chemclipse.model.implementation.PeakIntensityValues;
import org.eclipse.chemclipse.model.implementation.QuantitationEntry;
import org.eclipse.chemclipse.model.quantitation.CalibrationMethod;
import org.eclipse.chemclipse.model.quantitation.IQuantitationDatabase;
import org.eclipse.chemclipse.model.quantitation.IQuantitationEntry;
import org.eclipse.chemclipse.model.quantitation.IQuantitationPeak;
import org.eclipse.chemclipse.model.quantitation.IQuantitationSignal;
import org.eclipse.chemclipse.model.quantitation.IResponseSignal;
import org.eclipse.chemclipse.model.quantitation.IRetentionIndexWindow;
import org.eclipse.chemclipse.model.quantitation.IRetentionTimeWindow;
import org.eclipse.chemclipse.model.quantitation.QuantitationDatabase;
import org.eclipse.chemclipse.model.quantitation.QuantitationSignal;
import org.eclipse.chemclipse.model.quantitation.ResponseSignal;
import org.eclipse.chemclipse.model.quantitation.RetentionIndexWindow;
import org.eclipse.chemclipse.model.quantitation.RetentionTimeWindow;
import org.eclipse.chemclipse.msd.model.core.IIon;
import org.eclipse.chemclipse.msd.model.core.IIonTransition;
import org.eclipse.chemclipse.msd.model.core.IIonTransitionSettings;
import org.eclipse.chemclipse.msd.model.core.IPeakMSD;
import org.eclipse.chemclipse.msd.model.core.IPeakMassSpectrum;
import org.eclipse.chemclipse.msd.model.core.IPeakModelMSD;
import org.eclipse.chemclipse.msd.model.core.IScanMSD;
import org.eclipse.chemclipse.msd.model.exceptions.IonLimitExceededException;
import org.eclipse.chemclipse.msd.model.exceptions.IonTransitionIsNullException;
import org.eclipse.chemclipse.msd.model.implementation.Ion;
import org.eclipse.chemclipse.msd.model.implementation.IonTransitionSettings;
import org.eclipse.chemclipse.msd.model.implementation.PeakMSD;
import org.eclipse.chemclipse.msd.model.implementation.PeakMassSpectrum;
import org.eclipse.chemclipse.msd.model.implementation.PeakModelMSD;
import org.eclipse.chemclipse.msd.model.implementation.QuantitationPeakMSD;
import org.eclipse.chemclipse.msd.model.implementation.ScanMSD;
import org.eclipse.chemclipse.xxd.converter.supplier.chemclipse.internal.quantitation.AbstractDatabaseReader;
import org.eclipse.chemclipse.xxd.converter.supplier.chemclipse.internal.quantitation.IDatabaseReader;
import org.eclipse.chemclipse.xxd.model.quantitation.QuantitationCompound;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;

public class DatabaseReader_1000
extends AbstractDatabaseReader
implements IDatabaseReader {
    private static final Logger logger = Logger.getLogger(DatabaseReader_1000.class);

    @Override
    public IQuantitationDatabase convert(File file, IProgressMonitor monitor) throws IOException {
        IQuantitationDatabase quantitationDatabase = null;
        try (ZipFile zipFile = new ZipFile(file);){
            if (this.isValidFileFormat(zipFile)) {
                quantitationDatabase = this.readFromZipFile(zipFile, "", file, monitor);
            }
        }
        return quantitationDatabase;
    }

    private IQuantitationDatabase readFromZipFile(ZipFile zipFile, String directoryPrefix, File file, IProgressMonitor monitor) throws IOException {
        return this.readZipData(zipFile, directoryPrefix, file, monitor);
    }

    private IQuantitationDatabase readZipData(Object object, String directoryPrefix, File file, IProgressMonitor monitor) throws IOException {
        boolean closeStream;
        QuantitationDatabase quantitationDatabase = new QuantitationDatabase();
        quantitationDatabase.setFile(file);
        quantitationDatabase.setConverterId("org.eclipse.chemclipse.xxd.converter.supplier.chemclipse.quantitationDatabaseSupplier");
        if (object instanceof ZipFile) {
            closeStream = true;
        } else if (object instanceof ZipInputStream) {
            closeStream = false;
        } else {
            return null;
        }
        this.readContent(this.getDataInputStream(object, String.valueOf(directoryPrefix) + "QUANTDB/QUANTITATION_DATABASE"), closeStream, (IQuantitationDatabase)quantitationDatabase, monitor);
        return quantitationDatabase;
    }

    private void readContent(DataInputStream dataInputStream, boolean closeStream, IQuantitationDatabase quantitationDatabase, IProgressMonitor monitor) throws IOException {
        quantitationDatabase.setOperator(this.readString(dataInputStream));
        quantitationDatabase.setDescription(this.readString(dataInputStream));
        int size = dataInputStream.readInt();
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)"Read Database", (int)size);
        try {
            int i = 0;
            while (i < size) {
                String name = this.readString(dataInputStream);
                String concentrationUnit = this.readString(dataInputStream);
                CalibrationMethod calibrationMethod = CalibrationMethod.valueOf((String)this.readString(dataInputStream));
                String chemicalClass = this.readString(dataInputStream);
                boolean crossZero = dataInputStream.readBoolean();
                boolean useTIC = dataInputStream.readBoolean();
                List<IQuantitationPeak> quantitationPeaks = this.readQuantitationPeaks(dataInputStream);
                List<IResponseSignal> concentrationResponseEntriesMSD = this.readConcentrationResponseEntries(dataInputStream);
                List<IQuantitationSignal> quantitationSignalsMSD = this.readQuantitationSignals(dataInputStream);
                IRetentionIndexWindow retentionIndexWindow = this.readRetentionIndexWindow(dataInputStream);
                IRetentionTimeWindow retentionTimeWindow = this.readRetentionTimeWindow(dataInputStream);
                QuantitationCompound quantitationCompound = new QuantitationCompound(name, concentrationUnit, retentionTimeWindow.getRetentionTime());
                quantitationCompound.setCalibrationMethod(calibrationMethod);
                quantitationCompound.setChemicalClass(chemicalClass);
                quantitationCompound.setUseCrossZero(crossZero);
                quantitationCompound.setUseTIC(useTIC);
                quantitationCompound.getRetentionIndexWindow().setAllowedNegativeDeviation(retentionIndexWindow.getAllowedNegativeDeviation());
                quantitationCompound.getRetentionIndexWindow().setAllowedPositiveDeviation(retentionIndexWindow.getAllowedPositiveDeviation());
                quantitationCompound.getRetentionIndexWindow().setRetentionIndex(retentionIndexWindow.getRetentionIndex());
                quantitationCompound.getRetentionTimeWindow().setAllowedNegativeDeviation(retentionTimeWindow.getAllowedNegativeDeviation());
                quantitationCompound.getRetentionTimeWindow().setAllowedPositiveDeviation(retentionTimeWindow.getAllowedPositiveDeviation());
                quantitationCompound.getResponseSignals().addAll(concentrationResponseEntriesMSD);
                quantitationCompound.getQuantitationSignals().addAll(quantitationSignalsMSD);
                quantitationCompound.getQuantitationPeaks().addAll(quantitationPeaks);
                quantitationDatabase.add((Object)quantitationCompound);
                subMonitor.worked(1);
                ++i;
            }
        }
        finally {
            SubMonitor.done((IProgressMonitor)subMonitor);
        }
        if (closeStream) {
            dataInputStream.close();
        }
    }

    private List<IQuantitationPeak> readQuantitationPeaks(DataInputStream dataInputStream) throws IOException {
        ArrayList<IQuantitationPeak> quantitationPeaks = new ArrayList<IQuantitationPeak>();
        IonTransitionSettings ionTransitionSettings = new IonTransitionSettings();
        int size = dataInputStream.readInt();
        int i = 0;
        while (i < size) {
            double concentration = dataInputStream.readDouble();
            String concentrationUnit = this.readString(dataInputStream);
            IPeakMSD referencePeakMSD = this.readPeak(dataInputStream, (IIonTransitionSettings)ionTransitionSettings);
            QuantitationPeakMSD quantitationPeak = new QuantitationPeakMSD(referencePeakMSD, concentration, concentrationUnit);
            quantitationPeaks.add((IQuantitationPeak)quantitationPeak);
            ++i;
        }
        return quantitationPeaks;
    }

    private List<IResponseSignal> readConcentrationResponseEntries(DataInputStream dataInputStream) throws IOException {
        ArrayList<IResponseSignal> responseSignals = new ArrayList<IResponseSignal>();
        int size = dataInputStream.readInt();
        int i = 0;
        while (i < size) {
            double signal = dataInputStream.readDouble();
            double concentration = dataInputStream.readDouble();
            double response = dataInputStream.readDouble();
            ResponseSignal responseSignal = new ResponseSignal(signal, concentration, response);
            responseSignals.add((IResponseSignal)responseSignal);
            ++i;
        }
        return responseSignals;
    }

    private List<IQuantitationSignal> readQuantitationSignals(DataInputStream dataInputStream) throws IOException {
        ArrayList<IQuantitationSignal> quantitationSignals = new ArrayList<IQuantitationSignal>();
        int size = dataInputStream.readInt();
        int i = 0;
        while (i < size) {
            double signal = dataInputStream.readDouble();
            float relativeResponse = dataInputStream.readFloat();
            double uncertainty = dataInputStream.readDouble();
            boolean use = dataInputStream.readBoolean();
            QuantitationSignal quantitationSignal = new QuantitationSignal(signal, (double)relativeResponse, uncertainty, use);
            quantitationSignals.add((IQuantitationSignal)quantitationSignal);
            ++i;
        }
        return quantitationSignals;
    }

    private IRetentionIndexWindow readRetentionIndexWindow(DataInputStream dataInputStream) throws IOException {
        RetentionIndexWindow retentionIndexWindow = new RetentionIndexWindow();
        retentionIndexWindow.setAllowedNegativeDeviation(dataInputStream.readFloat());
        retentionIndexWindow.setAllowedPositiveDeviation(dataInputStream.readFloat());
        retentionIndexWindow.setRetentionIndex(dataInputStream.readFloat());
        return retentionIndexWindow;
    }

    private IRetentionTimeWindow readRetentionTimeWindow(DataInputStream dataInputStream) throws IOException {
        RetentionTimeWindow retentionTimeWindow = new RetentionTimeWindow();
        retentionTimeWindow.setAllowedNegativeDeviation(dataInputStream.readFloat());
        retentionTimeWindow.setAllowedPositiveDeviation(dataInputStream.readFloat());
        retentionTimeWindow.setRetentionTime(dataInputStream.readInt());
        return retentionTimeWindow;
    }

    private IPeakMSD readPeak(DataInputStream dataInputStream, IIonTransitionSettings ionTransitionSettings) throws IOException, IllegalArgumentException, PeakException {
        String detectorDescription = this.readString(dataInputStream);
        String quantifierDescription = this.readString(dataInputStream);
        boolean activeForAnalysis = dataInputStream.readBoolean();
        String integratorDescription = this.readString(dataInputStream);
        String modelDescription = this.readString(dataInputStream);
        PeakType peakType = PeakType.valueOf((String)this.readString(dataInputStream));
        int suggestedNumberOfComponents = dataInputStream.readInt();
        float startBackgroundAbundance = dataInputStream.readFloat();
        float stopBackgroundAbundance = dataInputStream.readFloat();
        IPeakMassSpectrum peakMaximum = this.readPeakMassSpectrum(dataInputStream, ionTransitionSettings);
        int numberOfRetentionTimes = dataInputStream.readInt();
        PeakIntensityValues intensityValues = new PeakIntensityValues(Float.MAX_VALUE);
        int i = 1;
        while (i <= numberOfRetentionTimes) {
            int retentionTime = dataInputStream.readInt();
            float relativeIntensity = dataInputStream.readFloat();
            intensityValues.addIntensityValue(retentionTime, relativeIntensity);
            ++i;
        }
        intensityValues.normalize();
        PeakModelMSD peakModel = new PeakModelMSD(peakMaximum, (IPeakIntensityValues)intensityValues, startBackgroundAbundance, stopBackgroundAbundance);
        PeakMSD peak = new PeakMSD((IPeakModelMSD)peakModel);
        peak.setDetectorDescription(detectorDescription);
        peak.setQuantifierDescription(quantifierDescription);
        peak.setActiveForAnalysis(activeForAnalysis);
        peak.setIntegratorDescription(integratorDescription);
        peak.setModelDescription(modelDescription);
        peak.setPeakType(peakType);
        peak.setSuggestedNumberOfComponents(suggestedNumberOfComponents);
        List<IIntegrationEntry> integrationEntries = this.readIntegrationEntries(dataInputStream);
        peak.setIntegratedArea(integrationEntries, integratorDescription);
        this.readPeakIdentificationTargets(dataInputStream, (IPeakMSD)peak);
        this.readPeakQuantitationEntries(dataInputStream, (IPeakMSD)peak);
        boolean readOptimizedMassSpectrum = dataInputStream.readBoolean();
        if (readOptimizedMassSpectrum) {
            ScanMSD optimizedMassSpectrum = new ScanMSD();
            this.readNormalMassSpectrum((IScanMSD)optimizedMassSpectrum, dataInputStream, ionTransitionSettings);
            peakMaximum.setOptimizedMassSpectrum((IScanMSD)optimizedMassSpectrum);
        }
        return peak;
    }

    private IPeakMassSpectrum readPeakMassSpectrum(DataInputStream dataInputStream, IIonTransitionSettings ionTransitionSettings) throws IOException {
        short massSpectrometer = dataInputStream.readShort();
        short massSpectrumType = dataInputStream.readShort();
        double precursorIon = dataInputStream.readDouble();
        PeakMassSpectrum massSpectrum = new PeakMassSpectrum();
        massSpectrum.setMassSpectrometer(massSpectrometer);
        massSpectrum.setMassSpectrumType(massSpectrumType);
        massSpectrum.setPrecursorIon(precursorIon);
        this.readNormalMassSpectrum((IScanMSD)massSpectrum, dataInputStream, ionTransitionSettings);
        return massSpectrum;
    }

    private void readNormalMassSpectrum(IScanMSD massSpectrum, DataInputStream dataInputStream, IIonTransitionSettings ionTransitionSettings) throws IOException {
        int retentionTime = dataInputStream.readInt();
        int retentionTimeColumn1 = dataInputStream.readInt();
        int retentionTimeColumn2 = dataInputStream.readInt();
        float retentionIndex = dataInputStream.readFloat();
        if (dataInputStream.readBoolean()) {
            int size = dataInputStream.readInt();
            int i = 0;
            while (i < size) {
                RetentionIndexType retentionIndexType = RetentionIndexType.valueOf((String)this.readString(dataInputStream));
                float retentionIndexAdditional = dataInputStream.readFloat();
                massSpectrum.setRetentionIndex(retentionIndexType, retentionIndexAdditional);
                ++i;
            }
        }
        int timeSegmentId = dataInputStream.readInt();
        int cycleNumber = dataInputStream.readInt();
        massSpectrum.setRetentionTime(retentionTime);
        massSpectrum.setRetentionTimeColumn1(retentionTimeColumn1);
        massSpectrum.setRetentionTimeColumn2(retentionTimeColumn2);
        massSpectrum.setRetentionIndex(retentionIndex);
        massSpectrum.setTimeSegmentId(timeSegmentId);
        massSpectrum.setCycleNumber(cycleNumber);
        int numberOfIons = dataInputStream.readInt();
        int i = 1;
        while (i <= numberOfIons) {
            try {
                IIon ion = this.readIon(dataInputStream, ionTransitionSettings);
                massSpectrum.addIon(ion);
            }
            catch (AbundanceLimitExceededException e) {
                logger.warn((Object)e);
            }
            catch (IonLimitExceededException e) {
                logger.warn((Object)e);
            }
            catch (IonTransitionIsNullException e) {
                logger.warn((Object)e);
            }
            ++i;
        }
        this.readMassSpectrumIdentificationTargets(dataInputStream, massSpectrum);
    }

    private IIon readIon(DataInputStream dataInputStream, IIonTransitionSettings ionTransitionSettings) throws IOException, AbundanceLimitExceededException, IonLimitExceededException, IonTransitionIsNullException {
        Ion ion;
        double mz = dataInputStream.readDouble();
        float abundance = dataInputStream.readFloat();
        int transition = dataInputStream.readInt();
        if (transition == 0) {
            ion = new Ion(mz, abundance);
        } else {
            String compoundName = this.readString(dataInputStream);
            double filter1FirstIon = dataInputStream.readDouble();
            double filter1LastIon = dataInputStream.readDouble();
            double filter3FirstIon = dataInputStream.readDouble();
            double filter3LastIon = dataInputStream.readDouble();
            double collisionEnergy = dataInputStream.readDouble();
            double filter1Resolution = dataInputStream.readDouble();
            double filter3Resolution = dataInputStream.readDouble();
            int transitionGroup = dataInputStream.readInt();
            int dwell = dataInputStream.readInt();
            IIonTransition ionTransition = ionTransitionSettings.getIonTransition(compoundName, filter1FirstIon, filter1LastIon, filter3FirstIon, filter3LastIon, collisionEnergy, filter1Resolution, filter3Resolution, transitionGroup);
            ionTransition.setDwell(dwell);
            ion = new Ion(mz, abundance, ionTransition);
        }
        return ion;
    }

    private void readMassSpectrumIdentificationTargets(DataInputStream dataInputStream, IScanMSD massSpectrum) throws IOException {
        int numberOfMassSpectrumTargets = dataInputStream.readInt();
        int i = 1;
        while (i <= numberOfMassSpectrumTargets) {
            String identifier = this.readString(dataInputStream);
            boolean manuallyVerified = dataInputStream.readBoolean();
            String casNumber = this.readString(dataInputStream);
            String comments = this.readString(dataInputStream);
            String referenceIdentifier = this.readString(dataInputStream);
            String miscellaneous = this.readString(dataInputStream);
            String database = this.readString(dataInputStream);
            String contributor = this.readString(dataInputStream);
            String name = this.readString(dataInputStream);
            HashSet<String> synonyms = new HashSet<String>();
            int numberOfSynonyms = dataInputStream.readInt();
            int j = 0;
            while (j < numberOfSynonyms) {
                synonyms.add(this.readString(dataInputStream));
                ++j;
            }
            String formula = this.readString(dataInputStream);
            String smiles = this.readString(dataInputStream);
            String inChI = this.readString(dataInputStream);
            double molWeight = dataInputStream.readDouble();
            float matchFactor = dataInputStream.readFloat();
            float matchFactorDirect = dataInputStream.readFloat();
            float reverseMatchFactor = dataInputStream.readFloat();
            float reverseMatchFactorDirect = dataInputStream.readFloat();
            float probability = dataInputStream.readFloat();
            boolean isMatch = dataInputStream.readBoolean();
            LibraryInformation libraryInformation = new LibraryInformation();
            libraryInformation.setCasNumber(casNumber);
            libraryInformation.setComments(comments);
            libraryInformation.setReferenceIdentifier(referenceIdentifier);
            libraryInformation.setMiscellaneous(miscellaneous);
            libraryInformation.setDatabase(database);
            libraryInformation.setContributor(contributor);
            libraryInformation.setName(name);
            libraryInformation.setSynonyms(synonyms);
            libraryInformation.setFormula(formula);
            libraryInformation.setSmiles(smiles);
            libraryInformation.setInChI(inChI);
            libraryInformation.setMolWeight(molWeight);
            ComparisonResult comparisonResult = new ComparisonResult(matchFactor, reverseMatchFactor, matchFactorDirect, reverseMatchFactorDirect, probability);
            comparisonResult.setMatch(isMatch);
            try {
                IdentificationTarget identificationEntry = new IdentificationTarget((ILibraryInformation)libraryInformation, (IComparisonResult)comparisonResult);
                identificationEntry.setIdentifier(identifier);
                identificationEntry.setManuallyVerified(manuallyVerified);
                massSpectrum.getTargets().add(identificationEntry);
            }
            catch (ReferenceMustNotBeNullException e) {
                logger.warn((Object)e);
            }
            ++i;
        }
    }

    private List<IIntegrationEntry> readIntegrationEntries(DataInputStream dataInputStream) throws IOException {
        ArrayList<IIntegrationEntry> integrationEntries = new ArrayList<IIntegrationEntry>();
        int numberOfIntegrationEntries = dataInputStream.readInt();
        int i = 1;
        while (i <= numberOfIntegrationEntries) {
            double signal = dataInputStream.readDouble();
            double integratedArea = dataInputStream.readDouble();
            IntegrationEntry integrationEntry = new IntegrationEntry(signal, integratedArea);
            integrationEntries.add((IIntegrationEntry)integrationEntry);
            ++i;
        }
        return integrationEntries;
    }

    private void readPeakIdentificationTargets(DataInputStream dataInputStream, IPeakMSD peak) throws IOException {
        int numberOfPeakTargets = dataInputStream.readInt();
        int i = 1;
        while (i <= numberOfPeakTargets) {
            String identifier = this.readString(dataInputStream);
            boolean manuallyVerified = dataInputStream.readBoolean();
            String casNumber = this.readString(dataInputStream);
            String comments = this.readString(dataInputStream);
            String referenceIdentifier = this.readString(dataInputStream);
            String miscellaneous = this.readString(dataInputStream);
            String database = this.readString(dataInputStream);
            String contributor = this.readString(dataInputStream);
            String name = this.readString(dataInputStream);
            HashSet<String> synonyms = new HashSet<String>();
            int numberOfSynonyms = dataInputStream.readInt();
            int j = 0;
            while (j < numberOfSynonyms) {
                synonyms.add(this.readString(dataInputStream));
                ++j;
            }
            String formula = this.readString(dataInputStream);
            String smiles = this.readString(dataInputStream);
            String inChI = this.readString(dataInputStream);
            double molWeight = dataInputStream.readDouble();
            float matchFactor = dataInputStream.readFloat();
            float matchFactorDirect = dataInputStream.readFloat();
            float reverseMatchFactor = dataInputStream.readFloat();
            float reverseMatchFactorDirect = dataInputStream.readFloat();
            float probability = dataInputStream.readFloat();
            boolean isMatch = dataInputStream.readBoolean();
            PeakLibraryInformation libraryInformation = new PeakLibraryInformation();
            libraryInformation.setCasNumber(casNumber);
            libraryInformation.setComments(comments);
            libraryInformation.setReferenceIdentifier(referenceIdentifier);
            libraryInformation.setMiscellaneous(miscellaneous);
            libraryInformation.setDatabase(database);
            libraryInformation.setContributor(contributor);
            libraryInformation.setName(name);
            libraryInformation.setSynonyms(synonyms);
            libraryInformation.setFormula(formula);
            libraryInformation.setSmiles(smiles);
            libraryInformation.setInChI(inChI);
            libraryInformation.setMolWeight(molWeight);
            PeakComparisonResult comparisonResult = new PeakComparisonResult(matchFactor, reverseMatchFactor, matchFactorDirect, reverseMatchFactorDirect, probability);
            comparisonResult.setMatch(isMatch);
            try {
                IdentificationTarget identificationEntry = new IdentificationTarget((ILibraryInformation)libraryInformation, (IComparisonResult)comparisonResult);
                identificationEntry.setIdentifier(identifier);
                identificationEntry.setManuallyVerified(manuallyVerified);
                peak.getTargets().add(identificationEntry);
            }
            catch (ReferenceMustNotBeNullException e) {
                logger.warn((Object)e);
            }
            ++i;
        }
    }

    private void readPeakQuantitationEntries(DataInputStream dataInputStream, IPeakMSD peak) throws IOException {
        int numberOfQuantitationEntries = dataInputStream.readInt();
        int i = 1;
        while (i <= numberOfQuantitationEntries) {
            double signal = dataInputStream.readDouble();
            String name = this.readString(dataInputStream);
            String chemicalClass = this.readString(dataInputStream);
            double concentration = dataInputStream.readDouble();
            String concentrationUnit = this.readString(dataInputStream);
            double area = dataInputStream.readDouble();
            String calibrationMethod = this.readString(dataInputStream);
            boolean usedCrossZero = dataInputStream.readBoolean();
            String description = this.readString(dataInputStream);
            QuantitationEntry quantitationEntry = new QuantitationEntry(name, concentration, concentrationUnit, area);
            quantitationEntry.setSignal(signal);
            quantitationEntry.setChemicalClass(chemicalClass);
            quantitationEntry.setCalibrationMethod(calibrationMethod);
            quantitationEntry.setUsedCrossZero(usedCrossZero);
            quantitationEntry.setDescription(description);
            peak.addQuantitationEntry((IQuantitationEntry)quantitationEntry);
            ++i;
        }
    }

    private boolean isValidFileFormat(ZipFile zipFile) throws IOException {
        boolean isValid = false;
        DataInputStream dataInputStream = this.getDataInputStream(zipFile, "VERSION");
        String version = this.readString(dataInputStream);
        if (version.equals("0.0.0.1")) {
            isValid = true;
        }
        dataInputStream.close();
        return isValid;
    }
}

