/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.wsd.converter.supplier.chemclipse.internal.io;

import java.io.BufferedOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.eclipse.chemclipse.converter.exceptions.FileIsNotWriteableException;
import org.eclipse.chemclipse.converter.io.AbstractChromatogramWriter;
import org.eclipse.chemclipse.csd.converter.supplier.chemclipse.io.ChromatogramWriterCSD;
import org.eclipse.chemclipse.csd.model.core.IChromatogramCSD;
import org.eclipse.chemclipse.model.baseline.IBaselineModel;
import org.eclipse.chemclipse.model.columns.IRetentionIndexEntry;
import org.eclipse.chemclipse.model.columns.ISeparationColumn;
import org.eclipse.chemclipse.model.columns.ISeparationColumnIndices;
import org.eclipse.chemclipse.model.core.IChromatogram;
import org.eclipse.chemclipse.model.core.IIntegrationEntry;
import org.eclipse.chemclipse.model.core.IMethod;
import org.eclipse.chemclipse.model.core.IScan;
import org.eclipse.chemclipse.model.core.RetentionIndexType;
import org.eclipse.chemclipse.model.identifier.IComparisonResult;
import org.eclipse.chemclipse.model.identifier.IIdentificationTarget;
import org.eclipse.chemclipse.model.identifier.ILibraryInformation;
import org.eclipse.chemclipse.model.quantitation.IInternalStandard;
import org.eclipse.chemclipse.model.quantitation.IQuantitationEntry;
import org.eclipse.chemclipse.msd.converter.supplier.chemclipse.io.ChromatogramWriterMSD;
import org.eclipse.chemclipse.msd.model.core.IChromatogramMSD;
import org.eclipse.chemclipse.support.history.IEditHistory;
import org.eclipse.chemclipse.support.history.IEditInformation;
import org.eclipse.chemclipse.wsd.converter.supplier.chemclipse.io.ChromatogramWriterWSD;
import org.eclipse.chemclipse.wsd.converter.supplier.chemclipse.io.IChromatogramWSDZipWriter;
import org.eclipse.chemclipse.wsd.model.core.IChromatogramPeakWSD;
import org.eclipse.chemclipse.wsd.model.core.IChromatogramWSD;
import org.eclipse.chemclipse.wsd.model.core.IPeakModelWSD;
import org.eclipse.chemclipse.wsd.model.core.IPeakWSD;
import org.eclipse.chemclipse.wsd.model.core.IScanSignalWSD;
import org.eclipse.chemclipse.wsd.model.core.IScanWSD;
import org.eclipse.chemclipse.xxd.converter.supplier.chemclipse.preferences.PreferenceSupplier;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;

public class ChromatogramWriter_1300
extends AbstractChromatogramWriter
implements IChromatogramWSDZipWriter {
    private static final String CLASSIFIER_DELIMITER = " ";

    public void writeChromatogram(File file, IChromatogramWSD chromatogram, IProgressMonitor monitor) throws FileNotFoundException, FileIsNotWriteableException, IOException {
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        ZipOutputStream zipOutputStream = new ZipOutputStream(new BufferedOutputStream(fileOutputStream));
        zipOutputStream.setLevel(PreferenceSupplier.getChromatogramCompressionLevel());
        zipOutputStream.setMethod(8);
        this.writeChromatogram(zipOutputStream, "", chromatogram, monitor);
        zipOutputStream.flush();
        zipOutputStream.close();
    }

    @Override
    public void writeChromatogram(ZipOutputStream zipOutputStream, String directoryPrefix, IChromatogramWSD chromatogram, IProgressMonitor monitor) throws IOException {
        this.writeVersion(zipOutputStream, directoryPrefix, monitor);
        this.writeOverviewFolder(zipOutputStream, directoryPrefix, chromatogram, monitor);
        this.writeChromatogramFolder(zipOutputStream, directoryPrefix, chromatogram, monitor);
        List referencedChromatograms = chromatogram.getReferencedChromatograms();
        this.writeChromatogramReferenceInfo(zipOutputStream, directoryPrefix, referencedChromatograms, monitor);
        this.writeReferencedChromatograms(zipOutputStream, directoryPrefix, referencedChromatograms, monitor);
    }

    private void writeVersion(ZipOutputStream zipOutputStream, String directoryPrefix, IProgressMonitor monitor) throws IOException {
        ZipEntry zipEntry = new ZipEntry(String.valueOf(directoryPrefix) + "VERSION");
        zipOutputStream.putNextEntry(zipEntry);
        DataOutputStream dataOutputStream = new DataOutputStream(zipOutputStream);
        String version = "1.3.0.0";
        dataOutputStream.writeInt(version.length());
        dataOutputStream.writeChars(version);
        dataOutputStream.flush();
        zipOutputStream.closeEntry();
    }

    private void writeOverviewFolder(ZipOutputStream zipOutputStream, String directoryPrefix, IChromatogramWSD chromatogram, IProgressMonitor monitor) throws IOException {
        ZipEntry zipEntry = new ZipEntry(String.valueOf(directoryPrefix) + "WSD/OVERVIEW/");
        zipOutputStream.putNextEntry(zipEntry);
        zipOutputStream.closeEntry();
        zipEntry = new ZipEntry(String.valueOf(directoryPrefix) + "WSD/OVERVIEW/TIC");
        zipOutputStream.putNextEntry(zipEntry);
        DataOutputStream dataOutputStream = new DataOutputStream(zipOutputStream);
        int scans = chromatogram.getNumberOfScans();
        dataOutputStream.writeInt(scans);
        int scan = 1;
        while (scan <= scans) {
            IScanWSD scanWSD = chromatogram.getSupplierScan(scan);
            dataOutputStream.writeFloat(scanWSD.getTotalSignal());
            dataOutputStream.writeInt(scanWSD.getRetentionTime());
            ++scan;
        }
        dataOutputStream.flush();
        zipOutputStream.closeEntry();
    }

    private void writeChromatogramFolder(ZipOutputStream zipOutputStream, String directoryPrefix, IChromatogramWSD chromatogram, IProgressMonitor monitor) throws IOException {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)"Write Chromatogram", (int)100);
        try {
            ZipEntry zipEntry = new ZipEntry(String.valueOf(directoryPrefix) + "WSD/CHROMATOGRAM/");
            zipOutputStream.putNextEntry(zipEntry);
            zipOutputStream.closeEntry();
            this.writeChromatogramMethod(zipOutputStream, directoryPrefix, chromatogram);
            subMonitor.worked(20);
            this.writeChromatogramScans(zipOutputStream, directoryPrefix, chromatogram, (IProgressMonitor)subMonitor);
            subMonitor.worked(20);
            this.writeChromatogramBaseline(zipOutputStream, directoryPrefix, chromatogram);
            this.writeChromatogramPeaks(zipOutputStream, directoryPrefix, chromatogram);
            this.writeChromatogramArea(zipOutputStream, directoryPrefix, chromatogram);
            subMonitor.worked(20);
            this.writeChromatogramIdentification(zipOutputStream, directoryPrefix, chromatogram);
            this.writeChromatogramHistory(zipOutputStream, directoryPrefix, chromatogram);
            subMonitor.worked(20);
            this.writeChromatogramMiscellaneous(zipOutputStream, directoryPrefix, chromatogram);
            this.writeSeparationColumn(zipOutputStream, directoryPrefix, chromatogram);
            subMonitor.worked(20);
        }
        finally {
            SubMonitor.done((IProgressMonitor)subMonitor);
        }
    }

    private void writeChromatogramMethod(ZipOutputStream zipOutputStream, String directoryPrefix, IChromatogramWSD chromatogram) throws IOException {
        ZipEntry zipEntry = new ZipEntry(String.valueOf(directoryPrefix) + "WSD/CHROMATOGRAM/SYSTEM_SETTINGS");
        zipOutputStream.putNextEntry(zipEntry);
        DataOutputStream dataOutputStream = new DataOutputStream(zipOutputStream);
        IMethod method = chromatogram.getMethod();
        this.writeString(dataOutputStream, method.getInstrumentName());
        this.writeString(dataOutputStream, method.getIonSource());
        dataOutputStream.writeDouble(method.getSamplingRate());
        dataOutputStream.writeInt(method.getSolventDelay());
        dataOutputStream.writeDouble(method.getSourceHeater());
        this.writeString(dataOutputStream, method.getStopMode());
        dataOutputStream.writeInt(method.getStopTime());
        dataOutputStream.writeInt(method.getTimeFilterPeakWidth());
        dataOutputStream.flush();
        zipOutputStream.closeEntry();
    }

    private void writeChromatogramScans(ZipOutputStream zipOutputStream, String directoryPrefix, IChromatogramWSD chromatogram, IProgressMonitor monitor) throws IOException {
        ZipEntry zipEntry = new ZipEntry(String.valueOf(directoryPrefix) + "WSD/CHROMATOGRAM/SCANS");
        zipOutputStream.putNextEntry(zipEntry);
        DataOutputStream dataOutputStream = new DataOutputStream(zipOutputStream);
        int scans = chromatogram.getNumberOfScans();
        dataOutputStream.writeInt(scans);
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)"Write Scans", (int)scans);
        try {
            int scan = 1;
            while (scan <= scans) {
                IScanWSD scanWSD = chromatogram.getSupplierScan(scan);
                int scanSignalTotal = scanWSD.getScanSignals().size();
                dataOutputStream.writeInt(scanSignalTotal);
                int signal = 0;
                while (signal < scanSignalTotal) {
                    IScanSignalWSD scanSignal = scanWSD.getScanSignal(signal);
                    double wavelength = scanSignal.getWavelength();
                    float abundance = scanSignal.getAbundance();
                    dataOutputStream.writeDouble(wavelength);
                    dataOutputStream.writeFloat(abundance);
                    ++signal;
                }
                dataOutputStream.writeInt(scanWSD.getRetentionTime());
                dataOutputStream.writeInt(scanWSD.getRelativeRetentionTime());
                dataOutputStream.writeInt(scanWSD.getRetentionTimeColumn1());
                dataOutputStream.writeInt(scanWSD.getRetentionTimeColumn2());
                dataOutputStream.writeFloat(scanWSD.getRetentionIndex());
                dataOutputStream.writeBoolean(scanWSD.hasAdditionalRetentionIndices());
                if (scanWSD.hasAdditionalRetentionIndices()) {
                    Map retentionIndicesTyped = scanWSD.getRetentionIndicesTyped();
                    dataOutputStream.writeInt(retentionIndicesTyped.size());
                    for (Map.Entry retentionIndexTyped : retentionIndicesTyped.entrySet()) {
                        this.writeString(dataOutputStream, ((RetentionIndexType)retentionIndexTyped.getKey()).toString());
                        dataOutputStream.writeFloat(((Float)retentionIndexTyped.getValue()).floatValue());
                    }
                }
                dataOutputStream.writeFloat(scanWSD.getTotalSignal());
                dataOutputStream.writeInt(scanWSD.getTimeSegmentId());
                dataOutputStream.writeInt(scanWSD.getCycleNumber());
                Set scanTargets = scanWSD.getTargets();
                dataOutputStream.writeInt(scanTargets.size());
                for (IIdentificationTarget scanTarget : scanTargets) {
                    if (!(scanTarget instanceof IIdentificationTarget)) continue;
                    IIdentificationTarget identificationEntry = scanTarget;
                    this.writeIdentificationEntry(dataOutputStream, identificationEntry);
                }
                subMonitor.worked(1);
                ++scan;
            }
        }
        finally {
            SubMonitor.done((IProgressMonitor)subMonitor);
        }
        dataOutputStream.flush();
        zipOutputStream.closeEntry();
    }

    private void writeChromatogramBaseline(ZipOutputStream zipOutputStream, String directoryPrefix, IChromatogramWSD chromatogram) throws IOException {
        ZipEntry zipEntry = new ZipEntry(String.valueOf(directoryPrefix) + "WSD/CHROMATOGRAM/BASELINE");
        zipOutputStream.putNextEntry(zipEntry);
        DataOutputStream dataOutputStream = new DataOutputStream(zipOutputStream);
        int scans = chromatogram.getNumberOfScans();
        dataOutputStream.writeInt(scans);
        IBaselineModel baselineModel = chromatogram.getBaselineModel();
        int scan = 1;
        while (scan <= scans) {
            int retentionTime = chromatogram.getSupplierScan(scan).getRetentionTime();
            float backgroundAbundance = baselineModel.getBackgroundAbundance(retentionTime);
            dataOutputStream.writeInt(retentionTime);
            dataOutputStream.writeFloat(backgroundAbundance);
            ++scan;
        }
        dataOutputStream.flush();
        zipOutputStream.closeEntry();
    }

    private void writeChromatogramPeaks(ZipOutputStream zipOutputStream, String directoryPrefix, IChromatogramWSD chromatogram) throws IOException {
        ZipEntry zipEntry = new ZipEntry(String.valueOf(directoryPrefix) + "WSD/CHROMATOGRAM/PEAKS");
        zipOutputStream.putNextEntry(zipEntry);
        DataOutputStream dataOutputStream = new DataOutputStream(zipOutputStream);
        List peaks = chromatogram.getPeaks();
        dataOutputStream.writeInt(peaks.size());
        for (IChromatogramPeakWSD peak : peaks) {
            this.writePeak(dataOutputStream, (IPeakWSD)peak);
        }
        dataOutputStream.flush();
        zipOutputStream.closeEntry();
    }

    private void writeChromatogramArea(ZipOutputStream zipOutputStream, String directoryPrefix, IChromatogramWSD chromatogram) throws IOException {
        ZipEntry zipEntry = new ZipEntry(String.valueOf(directoryPrefix) + "WSD/CHROMATOGRAM/AREA");
        zipOutputStream.putNextEntry(zipEntry);
        DataOutputStream dataOutputStream = new DataOutputStream(zipOutputStream);
        List chromatogramIntegrationEntries = chromatogram.getChromatogramIntegrationEntries();
        this.writeString(dataOutputStream, chromatogram.getIntegratorDescription());
        this.writeIntegrationEntries(dataOutputStream, chromatogramIntegrationEntries);
        List backgroundIntegrationEntries = chromatogram.getBackgroundIntegrationEntries();
        this.writeString(dataOutputStream, chromatogram.getIntegratorDescription());
        this.writeIntegrationEntries(dataOutputStream, backgroundIntegrationEntries);
        dataOutputStream.flush();
        zipOutputStream.closeEntry();
    }

    private void writePeak(DataOutputStream dataOutputStream, IPeakWSD peak) throws IOException {
        IPeakModelWSD peakModel = peak.getPeakModel();
        this.writeString(dataOutputStream, peak.getDetectorDescription());
        this.writeString(dataOutputStream, peak.getQuantifierDescription());
        dataOutputStream.writeBoolean(peak.isActiveForAnalysis());
        this.writeString(dataOutputStream, peak.getIntegratorDescription());
        this.writeString(dataOutputStream, peak.getModelDescription());
        this.writeString(dataOutputStream, peak.getPeakType().toString());
        dataOutputStream.writeInt(peak.getSuggestedNumberOfComponents());
        this.writeString(dataOutputStream, this.joinString(peak.getClassifier()));
        dataOutputStream.writeFloat(peakModel.getBackgroundAbundance(peakModel.getStartRetentionTime()));
        dataOutputStream.writeFloat(peakModel.getBackgroundAbundance(peakModel.getStopRetentionTime()));
        IScan scan = peakModel.getPeakMaximum();
        dataOutputStream.writeInt(scan.getRetentionTime());
        dataOutputStream.writeInt(scan.getRelativeRetentionTime());
        dataOutputStream.writeFloat(scan.getTotalSignal());
        dataOutputStream.writeInt(scan.getRetentionTimeColumn1());
        dataOutputStream.writeInt(scan.getRetentionTimeColumn2());
        dataOutputStream.writeFloat(scan.getRetentionIndex());
        dataOutputStream.writeBoolean(scan.hasAdditionalRetentionIndices());
        if (scan.hasAdditionalRetentionIndices()) {
            Map retentionIndicesTyped = scan.getRetentionIndicesTyped();
            dataOutputStream.writeInt(retentionIndicesTyped.size());
            for (Map.Entry retentionIndexTyped : retentionIndicesTyped.entrySet()) {
                this.writeString(dataOutputStream, ((RetentionIndexType)retentionIndexTyped.getKey()).toString());
                dataOutputStream.writeFloat(((Float)retentionIndexTyped.getValue()).floatValue());
            }
        }
        dataOutputStream.writeInt(scan.getTimeSegmentId());
        dataOutputStream.writeInt(scan.getCycleNumber());
        List retentionTimes = peakModel.getRetentionTimes();
        dataOutputStream.writeInt(retentionTimes.size());
        Iterator iterator = retentionTimes.iterator();
        while (iterator.hasNext()) {
            int retentionTime = (Integer)((Object)iterator.next());
            dataOutputStream.writeInt(retentionTime);
            dataOutputStream.writeFloat(peakModel.getPeakAbundance(retentionTime));
        }
        List integrationEntries = peak.getIntegrationEntries();
        this.writeIntegrationEntries(dataOutputStream, integrationEntries);
        Set peakTargets = peak.getTargets();
        dataOutputStream.writeInt(peakTargets.size());
        for (IIdentificationTarget peakTarget : peakTargets) {
            if (!(peakTarget instanceof IIdentificationTarget)) continue;
            IIdentificationTarget identificationEntry = peakTarget;
            this.writeIdentificationEntry(dataOutputStream, identificationEntry);
        }
        List quantitationEntries = peak.getQuantitationEntries();
        dataOutputStream.writeInt(quantitationEntries.size());
        for (IQuantitationEntry quantitationEntry : quantitationEntries) {
            this.writeString(dataOutputStream, quantitationEntry.getName());
            this.writeString(dataOutputStream, quantitationEntry.getChemicalClass());
            dataOutputStream.writeDouble(quantitationEntry.getConcentration());
            this.writeString(dataOutputStream, quantitationEntry.getConcentrationUnit());
            dataOutputStream.writeDouble(quantitationEntry.getArea());
            this.writeString(dataOutputStream, quantitationEntry.getCalibrationMethod());
            dataOutputStream.writeBoolean(quantitationEntry.getUsedCrossZero());
            this.writeString(dataOutputStream, quantitationEntry.getDescription());
            if (quantitationEntry.getSignal() != 0.0) {
                dataOutputStream.writeBoolean(true);
                dataOutputStream.writeDouble(quantitationEntry.getSignal());
                continue;
            }
            dataOutputStream.writeBoolean(false);
        }
        this.writeIntenalStandards(dataOutputStream, peak.getInternalStandards());
    }

    private String joinString(Collection<String> classifier) {
        StringBuilder sb = new StringBuilder();
        if (classifier != null) {
            for (String c : classifier) {
                if (sb.length() > 0) {
                    sb.append(CLASSIFIER_DELIMITER);
                }
                sb.append(c);
            }
        }
        return sb.toString();
    }

    private void writeIntegrationEntries(DataOutputStream dataOutputStream, List<? extends IIntegrationEntry> integrationEntries) throws IOException {
        dataOutputStream.writeInt(integrationEntries.size());
        for (IIntegrationEntry iIntegrationEntry : integrationEntries) {
            dataOutputStream.writeDouble(iIntegrationEntry.getIntegratedArea());
        }
    }

    private void writeIntenalStandards(DataOutputStream dataOutputStream, List<IInternalStandard> internalStandards) throws IOException {
        dataOutputStream.writeInt(internalStandards.size());
        for (IInternalStandard internalStandard : internalStandards) {
            this.writeString(dataOutputStream, internalStandard.getName());
            dataOutputStream.writeDouble(internalStandard.getConcentration());
            this.writeString(dataOutputStream, internalStandard.getConcentrationUnit());
            dataOutputStream.writeDouble(internalStandard.getResponseFactor());
            this.writeString(dataOutputStream, internalStandard.getChemicalClass());
        }
    }

    private void writeChromatogramIdentification(ZipOutputStream zipOutputStream, String directoryPrefix, IChromatogramWSD chromatogram) throws IOException {
        ZipEntry zipEntry = new ZipEntry(String.valueOf(directoryPrefix) + "WSD/CHROMATOGRAM/IDENTIFICATION");
        zipOutputStream.putNextEntry(zipEntry);
        DataOutputStream dataOutputStream = new DataOutputStream(zipOutputStream);
        Set chromatogramTargets = chromatogram.getTargets();
        dataOutputStream.writeInt(chromatogramTargets.size());
        for (IIdentificationTarget chromatogramTarget : chromatogramTargets) {
            if (!(chromatogramTarget instanceof IIdentificationTarget)) continue;
            IIdentificationTarget identificationEntry = chromatogramTarget;
            this.writeIdentificationEntry(dataOutputStream, identificationEntry);
        }
        dataOutputStream.flush();
        zipOutputStream.closeEntry();
    }

    private void writeIdentificationEntry(DataOutputStream dataOutputStream, IIdentificationTarget identificationEntry) throws IOException {
        ILibraryInformation libraryInformation = identificationEntry.getLibraryInformation();
        IComparisonResult comparisonResult = identificationEntry.getComparisonResult();
        this.writeString(dataOutputStream, identificationEntry.getIdentifier());
        dataOutputStream.writeBoolean(identificationEntry.isManuallyVerified());
        dataOutputStream.writeInt(libraryInformation.getRetentionTime());
        dataOutputStream.writeFloat(libraryInformation.getRetentionIndex());
        this.writeString(dataOutputStream, libraryInformation.getCasNumber());
        this.writeString(dataOutputStream, libraryInformation.getComments());
        this.writeString(dataOutputStream, libraryInformation.getReferenceIdentifier());
        this.writeString(dataOutputStream, libraryInformation.getMiscellaneous());
        this.writeString(dataOutputStream, libraryInformation.getDatabase());
        this.writeString(dataOutputStream, libraryInformation.getContributor());
        this.writeString(dataOutputStream, libraryInformation.getName());
        Set synonyms = libraryInformation.getSynonyms();
        int numberOfSynonyms = synonyms.size();
        dataOutputStream.writeInt(numberOfSynonyms);
        for (String synonym : synonyms) {
            this.writeString(dataOutputStream, synonym);
        }
        this.writeString(dataOutputStream, libraryInformation.getFormula());
        this.writeString(dataOutputStream, libraryInformation.getSmiles());
        this.writeString(dataOutputStream, libraryInformation.getInChI());
        dataOutputStream.writeDouble(libraryInformation.getMolWeight());
        dataOutputStream.writeFloat(comparisonResult.getMatchFactor());
        dataOutputStream.writeFloat(comparisonResult.getMatchFactorDirect());
        dataOutputStream.writeFloat(comparisonResult.getReverseMatchFactor());
        dataOutputStream.writeFloat(comparisonResult.getReverseMatchFactorDirect());
        dataOutputStream.writeFloat(comparisonResult.getProbability());
        dataOutputStream.writeBoolean(comparisonResult.isMatch());
    }

    private void writeChromatogramHistory(ZipOutputStream zipOutputStream, String directoryPrefix, IChromatogramWSD chromatogram) throws IOException {
        ZipEntry zipEntry = new ZipEntry(String.valueOf(directoryPrefix) + "WSD/CHROMATOGRAM/HISTORY");
        zipOutputStream.putNextEntry(zipEntry);
        DataOutputStream dataOutputStream = new DataOutputStream(zipOutputStream);
        IEditHistory editHistory = chromatogram.getEditHistory();
        dataOutputStream.writeInt(editHistory.size());
        for (IEditInformation editInformation : editHistory) {
            dataOutputStream.writeLong(editInformation.getDate().getTime());
            this.writeString(dataOutputStream, editInformation.getDescription());
        }
        dataOutputStream.flush();
        zipOutputStream.closeEntry();
    }

    private void writeChromatogramMiscellaneous(ZipOutputStream zipOutputStream, String directoryPrefix, IChromatogramWSD chromatogram) throws IOException {
        ZipEntry zipEntry = new ZipEntry(String.valueOf(directoryPrefix) + "WSD/CHROMATOGRAM/MISC");
        zipOutputStream.putNextEntry(zipEntry);
        DataOutputStream dataOutputStream = new DataOutputStream(zipOutputStream);
        Map headerData = chromatogram.getHeaderDataMap();
        dataOutputStream.writeInt(headerData.size());
        for (Map.Entry data : headerData.entrySet()) {
            this.writeString(dataOutputStream, (String)data.getKey());
            this.writeString(dataOutputStream, (String)data.getValue());
        }
        dataOutputStream.flush();
        zipOutputStream.closeEntry();
    }

    private void writeSeparationColumn(ZipOutputStream zipOutputStream, String directoryPrefix, IChromatogramWSD chromatogram) throws IOException {
        ZipEntry zipEntry = new ZipEntry(String.valueOf(directoryPrefix) + "WSD/CHROMATOGRAM/SEPARATION_COLUMN");
        zipOutputStream.putNextEntry(zipEntry);
        DataOutputStream dataOutputStream = new DataOutputStream(zipOutputStream);
        ISeparationColumnIndices separationColumnIndices = chromatogram.getSeparationColumnIndices();
        dataOutputStream.writeInt(separationColumnIndices.size());
        for (Map.Entry entry : separationColumnIndices.entrySet()) {
            IRetentionIndexEntry retentionIndexEntry = (IRetentionIndexEntry)entry.getValue();
            this.writeString(dataOutputStream, retentionIndexEntry.getName());
            dataOutputStream.writeInt(retentionIndexEntry.getRetentionTime());
            dataOutputStream.writeFloat(retentionIndexEntry.getRetentionIndex());
        }
        ISeparationColumn separationColumn = separationColumnIndices.getSeparationColumn();
        this.writeString(dataOutputStream, separationColumn.getName());
        this.writeString(dataOutputStream, separationColumn.getLength());
        this.writeString(dataOutputStream, separationColumn.getDiameter());
        this.writeString(dataOutputStream, separationColumn.getPhase());
        dataOutputStream.flush();
        zipOutputStream.closeEntry();
    }

    private void writeChromatogramReferenceInfo(ZipOutputStream zipOutputStream, String directoryPrefix, List<IChromatogram<?>> referencedChromatograms, IProgressMonitor monitor) throws IOException {
        ZipEntry zipEntryType = new ZipEntry(String.valueOf(directoryPrefix) + "REFERENCE_INFO");
        zipOutputStream.putNextEntry(zipEntryType);
        DataOutputStream dataOutputStream = new DataOutputStream(zipOutputStream);
        dataOutputStream.writeInt(referencedChromatograms.size());
        zipOutputStream.closeEntry();
    }

    private void writeReferencedChromatograms(ZipOutputStream zipOutputStream, String directoryPrefix, List<IChromatogram<?>> referencedChromatograms, IProgressMonitor monitor) throws IOException {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)"Write Chromatogram", (int)(referencedChromatograms.size() * 20));
        try {
            ChromatogramWriterMSD chromatogramWriterMSD = new ChromatogramWriterMSD();
            ChromatogramWriterCSD chromatogramWriterCSD = new ChromatogramWriterCSD();
            ChromatogramWriterWSD chromatogramWriterWSD = new ChromatogramWriterWSD();
            int i = 0;
            for (IChromatogram<?> referencedChromatogram : referencedChromatograms) {
                ZipEntry zipEntryChromtogram;
                String prefix = String.valueOf(directoryPrefix) + "CHROMATOGRAM_REFERENCE" + "_" + i++ + "/";
                ZipEntry zipEntryType = new ZipEntry(String.valueOf(prefix) + "CHROMATOGRAM_TYPE");
                zipOutputStream.putNextEntry(zipEntryType);
                DataOutputStream dataOutputStream = new DataOutputStream(zipOutputStream);
                if (referencedChromatogram instanceof IChromatogramMSD) {
                    this.writeString(dataOutputStream, "MSD");
                    dataOutputStream.flush();
                    prefix = String.valueOf(prefix) + "CHROMATOGRAM_REFERENCE/";
                    zipEntryChromtogram = new ZipEntry(prefix);
                    zipOutputStream.putNextEntry(zipEntryChromtogram);
                    chromatogramWriterMSD.writeChromatogram(zipOutputStream, prefix, (IChromatogramMSD)referencedChromatogram, monitor);
                } else if (referencedChromatogram instanceof IChromatogramCSD) {
                    this.writeString(dataOutputStream, "CSD");
                    dataOutputStream.flush();
                    prefix = String.valueOf(prefix) + "CHROMATOGRAM_REFERENCE/";
                    zipEntryChromtogram = new ZipEntry(prefix);
                    zipOutputStream.putNextEntry(zipEntryChromtogram);
                    chromatogramWriterCSD.writeChromatogram(zipOutputStream, prefix, (IChromatogramCSD)referencedChromatogram, monitor);
                } else if (referencedChromatogram instanceof IChromatogramWSD) {
                    this.writeString(dataOutputStream, "WSD");
                    dataOutputStream.flush();
                    prefix = String.valueOf(prefix) + "CHROMATOGRAM_REFERENCE/";
                    zipEntryChromtogram = new ZipEntry(prefix);
                    zipOutputStream.putNextEntry(zipEntryChromtogram);
                    chromatogramWriterWSD.writeChromatogram(zipOutputStream, prefix, (IChromatogramWSD)referencedChromatogram, monitor);
                }
                subMonitor.worked(20);
                zipOutputStream.closeEntry();
            }
        }
        finally {
            SubMonitor.done((IProgressMonitor)subMonitor);
        }
    }

    private void writeString(DataOutputStream dataOutputStream, String value) throws IOException {
        dataOutputStream.writeInt(value.length());
        dataOutputStream.writeChars(value);
    }
}

