/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.msd.converter.supplier.chemclipse.internal.io;

import java.io.BufferedOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.eclipse.chemclipse.converter.exceptions.FileIsNotWriteableException;
import org.eclipse.chemclipse.converter.io.AbstractChromatogramWriter;
import org.eclipse.chemclipse.model.core.IIntegrationEntry;
import org.eclipse.chemclipse.model.identifier.IComparisonResult;
import org.eclipse.chemclipse.model.identifier.IIdentificationTarget;
import org.eclipse.chemclipse.model.identifier.ILibraryInformation;
import org.eclipse.chemclipse.msd.converter.supplier.chemclipse.io.IChromatogramMSDZipWriter;
import org.eclipse.chemclipse.msd.model.core.IChromatogramMSD;
import org.eclipse.chemclipse.msd.model.core.IChromatogramPeakMSD;
import org.eclipse.chemclipse.msd.model.core.IIon;
import org.eclipse.chemclipse.msd.model.core.IPeakMSD;
import org.eclipse.chemclipse.msd.model.core.IPeakMassSpectrum;
import org.eclipse.chemclipse.msd.model.core.IPeakModelMSD;
import org.eclipse.chemclipse.msd.model.core.IRegularMassSpectrum;
import org.eclipse.chemclipse.msd.model.core.IVendorMassSpectrum;
import org.eclipse.chemclipse.support.history.IEditHistory;
import org.eclipse.chemclipse.support.history.IEditInformation;
import org.eclipse.chemclipse.xxd.converter.supplier.chemclipse.internal.support.MassSpectrometer;
import org.eclipse.chemclipse.xxd.converter.supplier.chemclipse.internal.support.MassSpectrumType;
import org.eclipse.chemclipse.xxd.converter.supplier.chemclipse.preferences.PreferenceSupplier;
import org.eclipse.core.runtime.IProgressMonitor;

public class ChromatogramWriter_0701
extends AbstractChromatogramWriter
implements IChromatogramMSDZipWriter {
    public void writeChromatogram(File file, IChromatogramMSD chromatogram, IProgressMonitor monitor) throws FileNotFoundException, FileIsNotWriteableException, IOException {
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        ZipOutputStream zipOutputStream = new ZipOutputStream(new BufferedOutputStream(fileOutputStream));
        zipOutputStream.setLevel(PreferenceSupplier.getChromatogramCompressionLevel());
        zipOutputStream.setMethod(8);
        this.writeChromatogram(zipOutputStream, "", chromatogram, monitor);
        zipOutputStream.flush();
        zipOutputStream.close();
    }

    @Override
    public void writeChromatogram(ZipOutputStream zipOutputStream, String directoryPrefix, IChromatogramMSD chromatogram, IProgressMonitor monitor) throws IOException {
        this.writeVersion(zipOutputStream, directoryPrefix, monitor);
        this.writeOverviewFolder(zipOutputStream, directoryPrefix, chromatogram, monitor);
        this.writeChromatogramFolder(zipOutputStream, directoryPrefix, chromatogram, monitor);
    }

    private void writeVersion(ZipOutputStream zipOutputStream, String directoryPrefix, IProgressMonitor monitor) throws IOException {
        ZipEntry zipEntry = new ZipEntry(String.valueOf(directoryPrefix) + "VERSION");
        zipOutputStream.putNextEntry(zipEntry);
        DataOutputStream dataOutputStream = new DataOutputStream(zipOutputStream);
        String version = "0.7.0.1";
        dataOutputStream.writeInt(version.length());
        dataOutputStream.writeChars(version);
        dataOutputStream.flush();
        zipOutputStream.closeEntry();
    }

    private void writeOverviewFolder(ZipOutputStream zipOutputStream, String directoryPrefix, IChromatogramMSD chromatogram, IProgressMonitor monitor) throws IOException {
        ZipEntry zipEntry = new ZipEntry(String.valueOf(directoryPrefix) + "OVERVIEW/");
        zipOutputStream.putNextEntry(zipEntry);
        zipOutputStream.closeEntry();
        zipEntry = new ZipEntry(String.valueOf(directoryPrefix) + "OVERVIEW/TIC");
        zipOutputStream.putNextEntry(zipEntry);
        DataOutputStream dataOutputStream = new DataOutputStream(zipOutputStream);
        int scans = chromatogram.getNumberOfScans();
        dataOutputStream.writeInt(scans);
        int scan = 1;
        while (scan <= scans) {
            dataOutputStream.writeInt(chromatogram.getScan(scan).getRetentionTime());
            dataOutputStream.writeFloat(chromatogram.getScan(scan).getTotalSignal());
            ++scan;
        }
        dataOutputStream.flush();
        zipOutputStream.closeEntry();
    }

    private void writeChromatogramFolder(ZipOutputStream zipOutputStream, String directoryPrefix, IChromatogramMSD chromatogram, IProgressMonitor monitor) throws IOException {
        ZipEntry zipEntry = new ZipEntry(String.valueOf(directoryPrefix) + "CHROMATOGRAM/");
        zipOutputStream.putNextEntry(zipEntry);
        zipOutputStream.closeEntry();
        this.writeChromatogramScans(zipOutputStream, directoryPrefix, chromatogram, monitor);
        this.writeChromatogramPeaks(zipOutputStream, directoryPrefix, chromatogram, monitor);
        this.writeChromatogramArea(zipOutputStream, directoryPrefix, chromatogram, monitor);
        this.writeChromatogramIdentification(zipOutputStream, directoryPrefix, chromatogram, monitor);
        this.writeChromatogramHistory(zipOutputStream, directoryPrefix, chromatogram, monitor);
        this.writeChromatogramMiscellaneous(zipOutputStream, directoryPrefix, chromatogram, monitor);
    }

    private void writeChromatogramScans(ZipOutputStream zipOutputStream, String directoryPrefix, IChromatogramMSD chromatogram, IProgressMonitor monitor) throws IOException {
        ZipEntry zipEntry = new ZipEntry(String.valueOf(directoryPrefix) + "CHROMATOGRAM/SCANS");
        zipOutputStream.putNextEntry(zipEntry);
        DataOutputStream dataOutputStream = new DataOutputStream(zipOutputStream);
        int scans = chromatogram.getNumberOfScans();
        dataOutputStream.writeInt(scans);
        int scan = 1;
        while (scan <= scans) {
            IVendorMassSpectrum massSpectrum = chromatogram.getSupplierScan(scan);
            this.writeMassSpectrum(dataOutputStream, (IRegularMassSpectrum)massSpectrum);
            ++scan;
        }
        dataOutputStream.flush();
        zipOutputStream.closeEntry();
    }

    private void writeChromatogramPeaks(ZipOutputStream zipOutputStream, String directoryPrefix, IChromatogramMSD chromatogram, IProgressMonitor monitor) throws IOException {
        ZipEntry zipEntry = new ZipEntry(String.valueOf(directoryPrefix) + "CHROMATOGRAM/PEAKS");
        zipOutputStream.putNextEntry(zipEntry);
        DataOutputStream dataOutputStream = new DataOutputStream(zipOutputStream);
        List peaks = chromatogram.getPeaks();
        dataOutputStream.writeInt(peaks.size());
        for (IChromatogramPeakMSD peak : peaks) {
            this.writePeak(dataOutputStream, (IPeakMSD)peak);
        }
        dataOutputStream.flush();
        zipOutputStream.closeEntry();
    }

    private void writeChromatogramArea(ZipOutputStream zipOutputStream, String directoryPrefix, IChromatogramMSD chromatogram, IProgressMonitor monitor) throws IOException {
        ZipEntry zipEntry = new ZipEntry(String.valueOf(directoryPrefix) + "CHROMATOGRAM/AREA");
        zipOutputStream.putNextEntry(zipEntry);
        DataOutputStream dataOutputStream = new DataOutputStream(zipOutputStream);
        List chromatogramIntegrationEntries = chromatogram.getChromatogramIntegrationEntries();
        this.writeString(dataOutputStream, chromatogram.getIntegratorDescription());
        this.writeIntegrationEntries(dataOutputStream, chromatogramIntegrationEntries);
        List backgroundIntegrationEntries = chromatogram.getBackgroundIntegrationEntries();
        this.writeString(dataOutputStream, chromatogram.getIntegratorDescription());
        this.writeIntegrationEntries(dataOutputStream, backgroundIntegrationEntries);
        dataOutputStream.flush();
        zipOutputStream.closeEntry();
    }

    private void writeChromatogramIdentification(ZipOutputStream zipOutputStream, String directoryPrefix, IChromatogramMSD chromatogram, IProgressMonitor monitor) throws IOException {
        ZipEntry zipEntry = new ZipEntry(String.valueOf(directoryPrefix) + "CHROMATOGRAM/IDENTIFICATION");
        zipOutputStream.putNextEntry(zipEntry);
        DataOutputStream dataOutputStream = new DataOutputStream(zipOutputStream);
        Set chromatogramTargets = chromatogram.getTargets();
        dataOutputStream.writeInt(chromatogramTargets.size());
        for (IIdentificationTarget chromatogramTarget : chromatogramTargets) {
            if (!(chromatogramTarget instanceof IIdentificationTarget)) continue;
            IIdentificationTarget identificationEntry = chromatogramTarget;
            this.writeIdentificationEntry(dataOutputStream, identificationEntry);
        }
        dataOutputStream.flush();
        zipOutputStream.closeEntry();
    }

    private void writeChromatogramHistory(ZipOutputStream zipOutputStream, String directoryPrefix, IChromatogramMSD chromatogram, IProgressMonitor monitor) throws IOException {
        ZipEntry zipEntry = new ZipEntry(String.valueOf(directoryPrefix) + "CHROMATOGRAM/HISTORY");
        zipOutputStream.putNextEntry(zipEntry);
        DataOutputStream dataOutputStream = new DataOutputStream(zipOutputStream);
        IEditHistory editHistory = chromatogram.getEditHistory();
        dataOutputStream.writeInt(editHistory.size());
        for (IEditInformation editInformation : editHistory) {
            dataOutputStream.writeLong(editInformation.getDate().getTime());
            this.writeString(dataOutputStream, editInformation.getDescription());
        }
        dataOutputStream.flush();
        zipOutputStream.closeEntry();
    }

    private void writeChromatogramMiscellaneous(ZipOutputStream zipOutputStream, String directoryPrefix, IChromatogramMSD chromatogram, IProgressMonitor monitor) throws IOException {
        ZipEntry zipEntry = new ZipEntry(String.valueOf(directoryPrefix) + "CHROMATOGRAM/MISC");
        zipOutputStream.putNextEntry(zipEntry);
        DataOutputStream dataOutputStream = new DataOutputStream(zipOutputStream);
        dataOutputStream.writeLong(chromatogram.getDate().getTime());
        this.writeString(dataOutputStream, chromatogram.getMiscInfo());
        this.writeString(dataOutputStream, chromatogram.getOperator());
        dataOutputStream.flush();
        zipOutputStream.closeEntry();
    }

    private void writeMassSpectrum(DataOutputStream dataOutputStream, IRegularMassSpectrum massSpectrum) throws IOException {
        this.writeString(dataOutputStream, this.getMassSpectrometer(massSpectrum.getMassSpectrometer()).toString());
        this.writeString(dataOutputStream, this.getMassSpectrumType(massSpectrum.getMassSpectrumType()).toString());
        dataOutputStream.writeInt(massSpectrum.getRetentionTime());
        dataOutputStream.writeFloat(massSpectrum.getRetentionIndex());
        List ions = massSpectrum.getIons();
        this.writeMassSpectrumIons(dataOutputStream, ions);
    }

    private void writeMassSpectrumIons(DataOutputStream dataOutputStream, List<IIon> ions) throws IOException {
        dataOutputStream.writeInt(ions.size());
        for (IIon ion : ions) {
            dataOutputStream.writeDouble(ion.getIon());
            dataOutputStream.writeFloat(ion.getAbundance());
        }
    }

    private void writePeak(DataOutputStream dataOutputStream, IPeakMSD peak) throws IOException {
        IPeakModelMSD peakModel = peak.getPeakModel();
        this.writeString(dataOutputStream, peak.getDetectorDescription());
        this.writeString(dataOutputStream, peak.getIntegratorDescription());
        this.writeString(dataOutputStream, peak.getModelDescription());
        this.writeString(dataOutputStream, peak.getPeakType().toString());
        dataOutputStream.writeFloat(peakModel.getBackgroundAbundance(peakModel.getStartRetentionTime()));
        dataOutputStream.writeFloat(peakModel.getBackgroundAbundance(peakModel.getStopRetentionTime()));
        IPeakMassSpectrum massSpectrum = peakModel.getPeakMassSpectrum();
        this.writeMassSpectrum(dataOutputStream, (IRegularMassSpectrum)massSpectrum);
        List retentionTimes = peakModel.getRetentionTimes();
        dataOutputStream.writeInt(retentionTimes.size());
        Iterator iterator = retentionTimes.iterator();
        while (iterator.hasNext()) {
            int retentionTime = (Integer)iterator.next();
            dataOutputStream.writeInt(retentionTime);
            dataOutputStream.writeFloat(peakModel.getPeakAbundance(retentionTime));
        }
        List integrationEntries = peak.getIntegrationEntries();
        this.writeIntegrationEntries(dataOutputStream, integrationEntries);
        Set peakTargets = peak.getTargets();
        dataOutputStream.writeInt(peakTargets.size());
        for (IIdentificationTarget peakTarget : peakTargets) {
            if (!(peakTarget instanceof IIdentificationTarget)) continue;
            IIdentificationTarget identificationEntry = peakTarget;
            this.writeIdentificationEntry(dataOutputStream, identificationEntry);
        }
    }

    private void writeIntegrationEntries(DataOutputStream dataOutputStream, List<? extends IIntegrationEntry> integrationEntries) throws IOException {
        dataOutputStream.writeInt(integrationEntries.size());
        for (IIntegrationEntry iIntegrationEntry : integrationEntries) {
            dataOutputStream.writeDouble(iIntegrationEntry.getSignal());
            dataOutputStream.writeDouble(iIntegrationEntry.getIntegratedArea());
        }
    }

    private void writeIdentificationEntry(DataOutputStream dataOutputStream, IIdentificationTarget identificationEntry) throws IOException {
        ILibraryInformation libraryInformation = identificationEntry.getLibraryInformation();
        IComparisonResult comparisonResult = identificationEntry.getComparisonResult();
        this.writeString(dataOutputStream, identificationEntry.getIdentifier());
        this.writeString(dataOutputStream, libraryInformation.getCasNumber());
        this.writeString(dataOutputStream, libraryInformation.getComments());
        this.writeString(dataOutputStream, libraryInformation.getMiscellaneous());
        this.writeString(dataOutputStream, libraryInformation.getName());
        dataOutputStream.writeFloat(comparisonResult.getMatchFactor());
        dataOutputStream.writeFloat(comparisonResult.getReverseMatchFactor());
        dataOutputStream.writeFloat(comparisonResult.getProbability());
    }

    private void writeString(DataOutputStream dataOutputStream, String value) throws IOException {
        dataOutputStream.writeInt(value.length());
        dataOutputStream.writeChars(value);
    }

    private MassSpectrometer getMassSpectrometer(short massSpectrometer) {
        MassSpectrometer detector;
        switch (massSpectrometer) {
            case 1: {
                detector = MassSpectrometer.MS1;
                break;
            }
            case 2: {
                detector = MassSpectrometer.MS2;
                break;
            }
            case 3: {
                detector = MassSpectrometer.MS3;
                break;
            }
            default: {
                detector = MassSpectrometer.MS1;
            }
        }
        return detector;
    }

    private MassSpectrumType getMassSpectrumType(short massSpectrumType) {
        MassSpectrumType type = MassSpectrumType.CENTROID;
        if (massSpectrumType == 1) {
            type = MassSpectrumType.PROFILE;
        }
        return type;
    }
}

