/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.chromatogram.xxd.report.supplier.openchrom.io;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.chemclipse.chromatogram.xxd.report.supplier.openchrom.settings.ReportSettings1;
import org.eclipse.chemclipse.csd.model.core.IChromatogramCSD;
import org.eclipse.chemclipse.model.comparator.PeakRetentionTimeComparator;
import org.eclipse.chemclipse.model.core.IChromatogram;
import org.eclipse.chemclipse.model.core.IChromatogramOverview;
import org.eclipse.chemclipse.model.core.IChromatogramPeak;
import org.eclipse.chemclipse.model.core.IIntegrationEntry;
import org.eclipse.chemclipse.model.core.IPeak;
import org.eclipse.chemclipse.model.core.IPeakModel;
import org.eclipse.chemclipse.model.core.IScan;
import org.eclipse.chemclipse.model.identifier.IComparisonResult;
import org.eclipse.chemclipse.model.identifier.IIdentificationTarget;
import org.eclipse.chemclipse.model.identifier.ILibraryInformation;
import org.eclipse.chemclipse.model.quantitation.IQuantitationEntry;
import org.eclipse.chemclipse.model.support.PeakQuantitation;
import org.eclipse.chemclipse.model.support.PeakQuantitations;
import org.eclipse.chemclipse.model.support.PeakQuantitationsExtractor;
import org.eclipse.chemclipse.model.targets.ITarget;
import org.eclipse.chemclipse.msd.model.core.IChromatogramMSD;
import org.eclipse.chemclipse.msd.model.core.IIon;
import org.eclipse.chemclipse.msd.model.core.IPeakMassSpectrum;
import org.eclipse.chemclipse.msd.model.core.IPeakModelMSD;
import org.eclipse.chemclipse.msd.model.core.comparator.IonAbundanceComparator;
import org.eclipse.chemclipse.support.comparator.SortOrder;
import org.eclipse.chemclipse.support.text.ValueFormat;
import org.eclipse.chemclipse.wsd.model.core.IChromatogramWSD;
import org.eclipse.core.runtime.IProgressMonitor;

public class ReportWriter1 {
    private static final int NUMBER_OF_IONS_TO_PRINT = 5;
    private static final String DELIMITER = "\t";
    private static final String ION_DELIMITER = " ";
    private static final String RESULTS_DELIMITER = "---";
    private static final String NO_VALUE = "--";
    private PeakQuantitationsExtractor peakQuantitationsExtractor = new PeakQuantitationsExtractor();
    private DecimalFormat decimalFormat = ValueFormat.getDecimalFormatEnglish((String)"0.0####");
    private DateFormat dateFormat = ValueFormat.getDateFormatEnglish();
    private IonAbundanceComparator ionComparator = new IonAbundanceComparator(SortOrder.DESC);
    private PeakRetentionTimeComparator peakComparator = new PeakRetentionTimeComparator(SortOrder.ASC);

    public void generate(File file, boolean append, List<IChromatogram<? extends IPeak>> chromatograms, ReportSettings1 reportSettings, IProgressMonitor monitor) throws IOException {
        Throwable throwable = null;
        Object var7_8 = null;
        try (PrintWriter printWriter = new PrintWriter(new FileWriter(file, append));){
            printWriter.println("++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++");
            printWriter.println("ASCII Report");
            printWriter.println("++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++");
            for (IChromatogram<? extends IPeak> chromatogram : chromatograms) {
                this.printHeader(printWriter, (IChromatogramOverview)chromatogram, monitor);
                this.reportChromatogram(printWriter, chromatogram, monitor);
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private void printHeader(PrintWriter printWriter, IChromatogramOverview chromatogramOverview, IProgressMonitor monitor) {
        this.printHeaderLine(printWriter, "Name", chromatogramOverview.getName());
        this.printHeaderLine(printWriter, "Data Name", chromatogramOverview.getDataName());
        this.printHeaderLine(printWriter, "Operator", chromatogramOverview.getOperator());
        Date date = chromatogramOverview.getDate();
        if (date != null) {
            this.printHeaderLine(printWriter, "Date", this.dateFormat.format(chromatogramOverview.getDate()));
        } else {
            this.printHeaderLine(printWriter, "Date", "");
        }
        this.printHeaderLine(printWriter, "Info", chromatogramOverview.getShortInfo());
        this.printHeaderLine(printWriter, "Misc", chromatogramOverview.getMiscInfo());
        this.printHeaderLine(printWriter, "Misc (separated)", chromatogramOverview.getMiscInfoSeparated());
        this.printHeaderLine(printWriter, "Details", chromatogramOverview.getDetailedInfo());
        this.printHeaderLine(printWriter, "Scans", Integer.toString(chromatogramOverview.getNumberOfScans()));
        this.printHeaderLine(printWriter, "Start RT (min)", this.decimalFormat.format((double)chromatogramOverview.getStartRetentionTime() / 60000.0));
        this.printHeaderLine(printWriter, "Stop RT (min)", this.decimalFormat.format((double)chromatogramOverview.getStopRetentionTime() / 60000.0));
        this.printHeaderLine(printWriter, "Barcode", chromatogramOverview.getBarcode());
        printWriter.println("");
        printWriter.println(">>>");
        printWriter.println("");
        for (Map.Entry entry : chromatogramOverview.getHeaderDataMap().entrySet()) {
            this.printHeaderLine(printWriter, (String)entry.getKey(), (String)entry.getValue());
        }
        printWriter.println("------------------------------");
    }

    private void printHeaderLine(PrintWriter printWriter, String key, String value) {
        printWriter.print(key);
        printWriter.print(": ");
        printWriter.println(value);
    }

    private void reportChromatogram(PrintWriter printWriter, IChromatogram chromatogram, IProgressMonitor monitor) {
        ArrayList<IPeak> peaks = new ArrayList<IPeak>(chromatogram.getPeaks());
        Collections.sort(peaks, this.peakComparator);
        printWriter.println("");
        printWriter.println("NAME: " + chromatogram.getName());
        printWriter.println("TYPE: " + this.getChromatogramType(chromatogram));
        printWriter.println("------------------------------");
        printWriter.println("Integrated Chromatogram Area: " + this.decimalFormat.format(chromatogram.getChromatogramIntegratedArea()));
        printWriter.println("Integrated Background Area: " + this.decimalFormat.format(chromatogram.getBackgroundIntegratedArea()));
        printWriter.println("Integrated Peak Area: " + this.decimalFormat.format(chromatogram.getPeakIntegratedArea()));
        printWriter.println("");
        printWriter.println("");
        printWriter.println("PEAK LIST OVERVIEW");
        printWriter.println("------------------------------");
        this.reportPeaksOverview(printWriter, peaks, "Peaks are not available.", monitor);
        printWriter.println("");
        printWriter.println("");
        printWriter.println("PEAK INTEGRATION RESULTS");
        printWriter.println("------------------------------");
        this.reportPeakIntegrationResults(printWriter, peaks, "Peak integration results are not available.", monitor);
        printWriter.println("");
        printWriter.println("");
        printWriter.println("SCAN IDENTIFICATION RESULTS");
        printWriter.println("------------------------------");
        this.reportScanIdentificationResults(printWriter, (IChromatogram<? extends IPeak>)chromatogram, "Scan identification results are not available.", monitor);
        printWriter.println("");
        printWriter.println("");
        printWriter.println("PEAK IDENTIFICATION RESULTS");
        printWriter.println("------------------------------");
        this.reportPeakIdentificationResults(printWriter, peaks, "Peak identification results are not available.", monitor);
        printWriter.println("");
        printWriter.println("");
        printWriter.println("BACKGROUND INTEGRATION RESULTS");
        printWriter.println("------------------------------");
        this.reportIntegrationResults(printWriter, chromatogram.getBackgroundIntegrationEntries(), "Background integration results are not available.", monitor);
        printWriter.println("");
        printWriter.println("");
        printWriter.println("CHROMATOGRAM INTEGRATION RESULTS");
        printWriter.println("------------------------------");
        this.reportIntegrationResults(printWriter, chromatogram.getChromatogramIntegrationEntries(), "Chromatogram integration results are not available.", monitor);
        printWriter.println("");
        printWriter.println("");
        printWriter.println("CHROMATOGRAM IDENTIFICATION RESULTS");
        printWriter.println("------------------------------");
        this.reportChromatogramIdentificationResults(printWriter, chromatogram, "Chromatogram identification results are not available.", monitor);
        printWriter.println("");
        printWriter.println("");
        printWriter.println("PEAK QUANTITATION RESULTS");
        printWriter.println("------------------------------");
        this.reportPeakQuantitationResults(printWriter, peaks, "Peak quantitation results are not available.", monitor);
        printWriter.println("");
        printWriter.println("");
        printWriter.println("PEAK QUANTITATION SUMMARY");
        printWriter.println("------------------------------");
        this.reportPeakListQuantitationSummary(printWriter, this.peakQuantitationsExtractor.extract(peaks), "The peak quantitation summary is not available.", monitor);
        printWriter.println("");
        printWriter.println("~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~");
    }

    private String getChromatogramType(IChromatogram chromatogram) {
        if (chromatogram instanceof IChromatogramCSD) {
            return "CSD";
        }
        if (chromatogram instanceof IChromatogramMSD) {
            return "MSD";
        }
        if (chromatogram instanceof IChromatogramWSD) {
            return "WSD";
        }
        return "???";
    }

    private void reportPeaksOverview(PrintWriter printWriter, List<IPeak> peaks, String messageNoResults, IProgressMonitor monitor) {
        if (peaks.size() > 0) {
            this.printPeaksOverview(printWriter, peaks, monitor);
        } else {
            printWriter.println(messageNoResults);
        }
    }

    private void printPeaksOverview(PrintWriter printWriter, List<IPeak> peaks, IProgressMonitor monitor) {
        printWriter.print("[#]");
        printWriter.print(DELIMITER);
        printWriter.print("RT (Min)");
        printWriter.print(DELIMITER);
        printWriter.print("RI");
        printWriter.print(DELIMITER);
        printWriter.print("Start RT (Min)");
        printWriter.print(DELIMITER);
        printWriter.print("Stop RT (Min)");
        printWriter.print(DELIMITER);
        printWriter.print("Tailing");
        printWriter.print(DELIMITER);
        printWriter.print("Width (at 50% peak height by inflection points)");
        printWriter.print(DELIMITER);
        printWriter.print("Integrated Area");
        printWriter.print(DELIMITER);
        printWriter.print("S/N");
        printWriter.print(DELIMITER);
        printWriter.print("Leading");
        printWriter.print(DELIMITER);
        printWriter.print("Tailing");
        printWriter.print(DELIMITER);
        printWriter.print("Scan #");
        printWriter.print(DELIMITER);
        printWriter.print("Purity");
        printWriter.print(DELIMITER);
        printWriter.print("Integrator");
        printWriter.print(DELIMITER);
        printWriter.print("Detector");
        printWriter.print(DELIMITER);
        printWriter.print("Model");
        printWriter.print(DELIMITER);
        printWriter.print("Trace ...");
        printWriter.println("");
        int counter = 1;
        for (IPeak peak : peaks) {
            this.reportPeak(printWriter, peak, counter++, monitor);
        }
    }

    private void reportPeak(PrintWriter printWriter, IPeak peak, int number, IProgressMonitor monitor) {
        String highestTraces;
        IPeakModel peakModel = peak.getPeakModel();
        IChromatogramPeak chromatogramPeak = null;
        if (peak instanceof IChromatogramPeak) {
            chromatogramPeak = (IChromatogramPeak)peak;
        }
        printWriter.print("[" + number + "]");
        printWriter.print(DELIMITER);
        printWriter.print(this.decimalFormat.format((double)peakModel.getRetentionTimeAtPeakMaximum() / 60000.0));
        printWriter.print(DELIMITER);
        printWriter.print(this.decimalFormat.format(peakModel.getPeakMaximum().getRetentionIndex()));
        printWriter.print(DELIMITER);
        printWriter.print(this.decimalFormat.format((double)peakModel.getStartRetentionTime() / 60000.0));
        printWriter.print(DELIMITER);
        printWriter.print(this.decimalFormat.format((double)peakModel.getStopRetentionTime() / 60000.0));
        printWriter.print(DELIMITER);
        printWriter.print(this.decimalFormat.format(peakModel.getTailing()));
        printWriter.print(DELIMITER);
        printWriter.print(this.decimalFormat.format((double)peakModel.getWidthByInflectionPoints(0.5f) / 60000.0));
        printWriter.print(DELIMITER);
        printWriter.print(this.decimalFormat.format(peak.getIntegratedArea()));
        printWriter.print(DELIMITER);
        printWriter.print(this.decimalFormat.format(chromatogramPeak != null ? Float.valueOf(chromatogramPeak.getSignalToNoiseRatio()) : NO_VALUE));
        printWriter.print(DELIMITER);
        printWriter.print(this.decimalFormat.format(peakModel.getLeading()));
        printWriter.print(DELIMITER);
        printWriter.print(this.decimalFormat.format(peakModel.getTailing()));
        printWriter.print(DELIMITER);
        printWriter.print(chromatogramPeak != null ? Integer.toString(chromatogramPeak.getScanMax()) : NO_VALUE);
        printWriter.print(DELIMITER);
        printWriter.print(this.decimalFormat.format(chromatogramPeak != null ? Float.valueOf(chromatogramPeak.getPurity()) : NO_VALUE));
        printWriter.print(DELIMITER);
        printWriter.print(peak.getIntegratorDescription());
        printWriter.print(DELIMITER);
        printWriter.print(peak.getDetectorDescription());
        printWriter.print(DELIMITER);
        printWriter.print(peak.getModelDescription());
        if (peakModel instanceof IPeakModelMSD) {
            IPeakModelMSD peakModelMSD = (IPeakModelMSD)peakModel;
            highestTraces = this.extractHighestIons(printWriter, peakModelMSD);
        } else {
            highestTraces = NO_VALUE;
        }
        printWriter.print(DELIMITER);
        printWriter.print(highestTraces);
        printWriter.println("");
    }

    private String extractHighestIons(PrintWriter printWriter, IPeakModelMSD peakModelMSD) {
        IPeakMassSpectrum peakMassSpectrum = peakModelMSD.getPeakMassSpectrum();
        ArrayList ions = new ArrayList(peakMassSpectrum.getIons());
        int numberOfIonsToPrint = ions.size() < 5 ? ions.size() : 5;
        Collections.sort(ions, this.ionComparator);
        StringBuilder builder = new StringBuilder();
        int i = 0;
        while (i < numberOfIonsToPrint) {
            IIon ion = (IIon)ions.get(i);
            if (ion.getIon() == 0.0) {
                builder.append("TIC");
            } else {
                builder.append(this.decimalFormat.format(ion.getIon()));
            }
            builder.append(ION_DELIMITER);
            ++i;
        }
        builder.append("...");
        return builder.toString();
    }

    private void reportPeakIntegrationResults(PrintWriter printWriter, List<IPeak> peaks, String messageNoResults, IProgressMonitor monitor) {
        if (peaks.size() > 0) {
            this.printPeakIntegrationResults(printWriter, peaks, monitor);
        } else {
            printWriter.println(messageNoResults);
        }
    }

    private void printPeakIntegrationResults(PrintWriter printWriter, List<IPeak> peaks, IProgressMonitor monitor) {
        printWriter.print("[#]");
        printWriter.print(DELIMITER);
        printWriter.print("Trace (0 = TIC or SUM XIC/XWC))");
        printWriter.print(DELIMITER);
        printWriter.print("Integrated Area");
        printWriter.println("");
        int counter = 1;
        for (IPeak peak : peaks) {
            this.reportPeakIntegrationResults(printWriter, peak, counter++, monitor);
        }
    }

    private void reportPeakIntegrationResults(PrintWriter printWriter, IPeak peak, int number, IProgressMonitor monitor) {
        List integrationEntries = peak.getIntegrationEntries();
        for (IIntegrationEntry integrationEntry : integrationEntries) {
            printWriter.print("[" + number + "]");
            printWriter.print(DELIMITER);
            double signal = integrationEntry.getSignal();
            if (signal == 0.0) {
                printWriter.print("TIC");
            } else {
                printWriter.print(this.decimalFormat.format(signal));
            }
            printWriter.print(DELIMITER);
            printWriter.print(this.decimalFormat.format(integrationEntry.getIntegratedArea()));
            printWriter.println("");
        }
    }

    private void reportPeakIdentificationResults(PrintWriter printWriter, List<IPeak> peaks, String messageNoResults, IProgressMonitor monitor) {
        if (peaks.size() > 0) {
            this.printPeakIdentificationResults(printWriter, peaks, monitor);
        } else {
            printWriter.println(messageNoResults);
        }
    }

    private void printPeakIdentificationResults(PrintWriter printWriter, List<IPeak> peaks, IProgressMonitor monitor) {
        this.printTargetsHeadline(printWriter, "[#]", monitor);
        int counter = 1;
        for (IPeak peak : peaks) {
            Set peakTargets = peak.getTargets();
            if (peakTargets.size() > 0) {
                printWriter.println(RESULTS_DELIMITER);
                this.printTargetsData(printWriter, peakTargets, Integer.toString(counter), monitor);
            }
            ++counter;
        }
    }

    private void reportScanIdentificationResults(PrintWriter printWriter, IChromatogram<? extends IPeak> chromatogram, String messageNoResults, IProgressMonitor monitor) {
        if (this.scanTargetsAvailable(chromatogram)) {
            this.printTargetsHeadline(printWriter, "[#]", monitor);
            int counter = 1;
            for (IScan scan : chromatogram.getScans()) {
                if (scan.getTargets().size() > 0) {
                    printWriter.println(RESULTS_DELIMITER);
                    this.printTargetsData(printWriter, scan.getTargets(), Integer.toString(counter), monitor);
                }
                ++counter;
            }
        } else {
            printWriter.println(messageNoResults);
        }
    }

    private boolean scanTargetsAvailable(IChromatogram<? extends IPeak> chromatogram) {
        chromatogram.getScans();
        for (IScan scan : chromatogram.getScans()) {
            if (scan.getTargets().size() <= 0) continue;
            return true;
        }
        return false;
    }

    private void reportChromatogramIdentificationResults(PrintWriter printWriter, IChromatogram chromatogram, String messageNoResults, IProgressMonitor monitor) {
        Set chromatogramTargets = chromatogram.getTargets();
        if (chromatogramTargets.size() > 0) {
            this.printTargetsHeadline(printWriter, null, monitor);
            this.printTargetsData(printWriter, chromatogramTargets, null, monitor);
        } else {
            printWriter.println(messageNoResults);
        }
    }

    private void printTargetsHeadline(PrintWriter printWriter, String prefix, IProgressMonitor monitor) {
        if (prefix != null) {
            printWriter.print(prefix);
            printWriter.print(DELIMITER);
        }
        printWriter.print("Name");
        printWriter.print(DELIMITER);
        printWriter.print("CAS");
        printWriter.print(DELIMITER);
        printWriter.print("MatchFactor");
        printWriter.print(DELIMITER);
        printWriter.print("ReverseMatchFactor");
        printWriter.print(DELIMITER);
        printWriter.print("Formula");
        printWriter.print(DELIMITER);
        printWriter.print("Mol Weight");
        printWriter.print(DELIMITER);
        printWriter.print("Probability");
        printWriter.print(DELIMITER);
        printWriter.print("Advise");
        printWriter.print(DELIMITER);
        printWriter.print("Identifier");
        printWriter.print(DELIMITER);
        printWriter.print("Miscellaneous");
        printWriter.print(DELIMITER);
        printWriter.print("Comments");
        printWriter.println("");
    }

    private void printTargetsData(PrintWriter printWriter, Set<IIdentificationTarget> targets, String prefix, IProgressMonitor monitor) {
        for (ITarget iTarget : targets) {
            IIdentificationTarget identificationEntry = (IIdentificationTarget)iTarget;
            ILibraryInformation libraryInformation = identificationEntry.getLibraryInformation();
            IComparisonResult comparisonResult = identificationEntry.getComparisonResult();
            if (prefix != null) {
                printWriter.print("[" + prefix + "]");
                printWriter.print(DELIMITER);
            }
            printWriter.print(libraryInformation.getName());
            printWriter.print(DELIMITER);
            printWriter.print(libraryInformation.getCasNumber());
            printWriter.print(DELIMITER);
            printWriter.print(this.decimalFormat.format(comparisonResult.getMatchFactor()));
            printWriter.print(DELIMITER);
            printWriter.print(this.decimalFormat.format(comparisonResult.getReverseMatchFactor()));
            printWriter.print(DELIMITER);
            printWriter.print(libraryInformation.getFormula());
            printWriter.print(DELIMITER);
            printWriter.print(this.decimalFormat.format(libraryInformation.getMolWeight()));
            printWriter.print(DELIMITER);
            printWriter.print(this.decimalFormat.format(comparisonResult.getProbability()));
            printWriter.print(DELIMITER);
            printWriter.print(comparisonResult.getAdvise());
            printWriter.print(DELIMITER);
            printWriter.print(identificationEntry.getIdentifier());
            printWriter.print(DELIMITER);
            printWriter.print(libraryInformation.getMiscellaneous());
            printWriter.print(DELIMITER);
            printWriter.print(libraryInformation.getComments());
            printWriter.println("");
        }
    }

    private void reportIntegrationResults(PrintWriter printWriter, List<IIntegrationEntry> integrationEntries, String messageNoResults, IProgressMonitor monitor) {
        if (integrationEntries.size() > 0) {
            this.printIntegrationEntries(printWriter, integrationEntries, monitor);
        } else {
            printWriter.println(messageNoResults);
        }
    }

    private void printIntegrationEntries(PrintWriter printWriter, List<IIntegrationEntry> integrationEntries, IProgressMonitor monitor) {
        printWriter.print("m/z (0 = TIC or SUM XIC))");
        printWriter.print(DELIMITER);
        printWriter.print("Integrated Area");
        printWriter.println("");
        for (IIntegrationEntry integrationEntry : integrationEntries) {
            double signal = integrationEntry.getSignal();
            if (signal == 0.0) {
                printWriter.print("TIC");
            } else {
                printWriter.print(this.decimalFormat.format(signal));
            }
            printWriter.print(DELIMITER);
            printWriter.print(this.decimalFormat.format(integrationEntry.getIntegratedArea()));
            printWriter.println("");
        }
    }

    private void reportPeakQuantitationResults(PrintWriter printWriter, List<IPeak> peaks, String messageNoResults, IProgressMonitor monitor) {
        if (peaks.size() > 0) {
            this.printPeakQuantitationResults(printWriter, peaks, monitor);
        } else {
            printWriter.println(messageNoResults);
        }
    }

    private void printPeakQuantitationResults(PrintWriter printWriter, List<IPeak> peaks, IProgressMonitor monitor) {
        printWriter.print("[#]");
        printWriter.print(DELIMITER);
        printWriter.print("Name");
        printWriter.print(DELIMITER);
        printWriter.print("ChemicalClass");
        printWriter.print(DELIMITER);
        printWriter.print("Concentration");
        printWriter.print(DELIMITER);
        printWriter.print("ConcentrationUnit");
        printWriter.print(DELIMITER);
        printWriter.print("Area");
        printWriter.print(DELIMITER);
        printWriter.print("Description");
        printWriter.print(DELIMITER);
        printWriter.print("Ion");
        printWriter.println("");
        int counter = 1;
        for (IPeak peak : peaks) {
            List quantitationEntries = peak.getQuantitationEntries();
            if (quantitationEntries.size() > 0) {
                printWriter.println(RESULTS_DELIMITER);
                this.printPeakQuantitationResults(printWriter, quantitationEntries, counter, monitor);
            }
            ++counter;
        }
    }

    private void printPeakQuantitationResults(PrintWriter printWriter, List<IQuantitationEntry> quantitationEntries, int number, IProgressMonitor monitor) {
        for (IQuantitationEntry quantitationEntry : quantitationEntries) {
            printWriter.print("[" + number + "]");
            printWriter.print(DELIMITER);
            printWriter.print(quantitationEntry.getName());
            printWriter.print(DELIMITER);
            printWriter.print(quantitationEntry.getChemicalClass());
            printWriter.print(DELIMITER);
            printWriter.print(this.decimalFormat.format(quantitationEntry.getConcentration()));
            printWriter.print(DELIMITER);
            printWriter.print(quantitationEntry.getConcentrationUnit());
            printWriter.print(DELIMITER);
            printWriter.print(this.decimalFormat.format(quantitationEntry.getArea()));
            printWriter.print(DELIMITER);
            printWriter.print(quantitationEntry.getDescription());
            double signal = quantitationEntry.getSignal();
            printWriter.print(DELIMITER);
            if (signal == 0.0) {
                printWriter.print("TIC");
            } else {
                printWriter.print(this.decimalFormat.format(signal));
            }
            printWriter.println("");
        }
    }

    private void reportPeakListQuantitationSummary(PrintWriter printWriter, PeakQuantitations peakQuantitations, String messageNoResults, IProgressMonitor monitor) {
        if (peakQuantitations.getTitles().size() > 0) {
            Iterator titles = peakQuantitations.getTitles().iterator();
            while (titles.hasNext()) {
                printWriter.print((String)titles.next());
                if (!titles.hasNext()) continue;
                printWriter.print(DELIMITER);
            }
            printWriter.println("");
            List peakQuantitationEntries = peakQuantitations.getQuantitationEntries();
            for (PeakQuantitation peakQuantitationEntry : peakQuantitationEntries) {
                printWriter.print(this.decimalFormat.format((double)peakQuantitationEntry.getRetentionTime() / 60000.0));
                printWriter.print(DELIMITER);
                printWriter.print(this.decimalFormat.format(peakQuantitationEntry.getIntegratedArea()));
                Iterator iterator = peakQuantitationEntry.getConcentrations().iterator();
                while (iterator.hasNext()) {
                    double concentration = (Double)iterator.next();
                    printWriter.print(DELIMITER);
                    printWriter.print(this.decimalFormat.format(concentration));
                }
                printWriter.println("");
            }
        } else {
            printWriter.println(messageNoResults);
        }
    }
}

