/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.msd.identifier.supplier.nist.runtime;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import org.eclipse.chemclipse.logging.core.Logger;
import org.eclipse.chemclipse.msd.identifier.supplier.nist.internal.helper.PathHelper;
import org.eclipse.chemclipse.msd.identifier.supplier.nist.runtime.INistSupport;
import org.eclipse.chemclipse.support.runtime.IRuntimeSupport;

public class NistSupport
implements INistSupport {
    private static final Logger logger = Logger.getLogger(NistSupport.class);
    private IRuntimeSupport runtimeSupport;
    private int numberOfUnknownEntriesToProcess = 1;

    public NistSupport(IRuntimeSupport runtimeSupport) {
        this.runtimeSupport = runtimeSupport;
    }

    @Override
    public void setNumberOfTargets(int numberOfTargets) {
        try {
            int b;
            String line;
            File nistSettings = new File(this.getNISTSettingsFile());
            FileReader fileReader = new FileReader(nistSettings);
            BufferedReader bufferedReader = new BufferedReader(fileReader);
            File nistSettingsTmp = new File(PathHelper.getStoragePath() + File.separator + "nistms.INI");
            PrintWriter printWriter = new PrintWriter(nistSettingsTmp);
            while ((line = bufferedReader.readLine()) != null) {
                if (line.startsWith("Hits to Print=")) {
                    printWriter.println("Hits to Print=" + numberOfTargets);
                    continue;
                }
                printWriter.println(line);
            }
            printWriter.flush();
            printWriter.close();
            bufferedReader.close();
            fileReader.close();
            FileReader in = new FileReader(nistSettingsTmp);
            FileWriter out = new FileWriter(nistSettings);
            while ((b = in.read()) != -1) {
                out.write(b);
            }
            in.close();
            out.flush();
            out.close();
        }
        catch (IOException e) {
            logger.warn((Object)e);
        }
    }

    @Override
    public boolean validateExecutable() {
        return this.runtimeSupport.getApplicationExecutable().toLowerCase().startsWith("nistms");
    }

    @Override
    public String getNistlogFile() {
        return String.valueOf(this.runtimeSupport.getApplicationPath()) + File.separator + "NISTLOG.TXT";
    }

    @Override
    public String getSrcreadyFile() {
        return String.valueOf(this.runtimeSupport.getApplicationPath()) + File.separator + "SRCREADY.TXT";
    }

    @Override
    public String getSrcresltFile() {
        return String.valueOf(this.runtimeSupport.getApplicationPath()) + File.separator + "SRCRESLT.TXT";
    }

    @Override
    public String getAutoimpFile() {
        return String.valueOf(this.runtimeSupport.getApplicationPath()) + File.separator + "AUTOIMP.MSD";
    }

    @Override
    public String getNISTSettingsFile() {
        return String.valueOf(this.runtimeSupport.getApplicationPath()) + File.separator + "nistms.INI";
    }

    @Override
    public void setNumberOfUnknownEntriesToProcess(int numberOfUnknownEntriesToProcess) {
        this.numberOfUnknownEntriesToProcess = numberOfUnknownEntriesToProcess;
    }

    @Override
    public int getNumberOfUnknownEntriesToProcess() {
        return this.numberOfUnknownEntriesToProcess;
    }

    @Override
    public String getFilespecFile() {
        return PathHelper.getStoragePath() + File.separator + "FILESPEC.FIL";
    }

    @Override
    public String getMassSpectraFile() {
        return PathHelper.getStoragePath() + File.separator + "MASSSPECTRA.MSL";
    }
}

