/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.rcp.app.ui.dialogs;

import java.io.IOException;
import org.eclipse.chemclipse.rcp.app.ui.Activator;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.preference.IPersistentPreferenceStore;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;

public class PerspectiveChooserDialog
extends Dialog {
    private String title = "";
    private String message = "";
    private Label messageLabel;
    private Button changePerspectiveAutomatically;
    private IPreferenceStore preferenceStore;
    private String preferenceKey;

    public PerspectiveChooserDialog(Shell parentShell, String title, String message) {
        this(parentShell, title, message, Activator.getDefault().getPreferenceStore(), "changePerspectiveAutomatically");
    }

    public PerspectiveChooserDialog(Shell parentShell, String title, String message, IPreferenceStore preferenceStore, String preferenceKey) {
        super(parentShell);
        this.preferenceStore = preferenceStore;
        this.preferenceKey = preferenceKey;
        if (title != null) {
            this.title = title;
        }
        if (message != null) {
            this.message = message;
        }
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        if (this.title != null) {
            shell.setText(this.title);
        }
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId == 0) {
            IPersistentPreferenceStore store;
            this.preferenceStore.setValue(this.preferenceKey, this.changePerspectiveAutomatically.getSelection());
            if (this.preferenceStore instanceof IPersistentPreferenceStore && (store = (IPersistentPreferenceStore)this.preferenceStore).needsSaving()) {
                try {
                    store.save();
                }
                catch (IOException e) {
                    Activator.getDefault().getLog().log((IStatus)new Status(4, ((Object)((Object)this)).getClass().getName(), "Saving preferences failed", (Throwable)e));
                }
            }
        }
        super.buttonPressed(buttonId);
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        GridData layoutData = new GridData(1796);
        layoutData.widthHint = this.convertHorizontalDLUsToPixels(300);
        this.createMessage(composite);
        this.createCheckboxes(composite, layoutData);
        return composite;
    }

    private void createMessage(Composite parent) {
        if (this.message != null) {
            GridData layoutData = new GridData(1796);
            layoutData.widthHint = this.convertHorizontalDLUsToPixels(300);
            layoutData.minimumHeight = 100;
            this.messageLabel = new Label(parent, 64);
            this.messageLabel.setLayoutData((Object)layoutData);
            this.messageLabel.setText(this.message);
            this.messageLabel.setFont(parent.getFont());
        }
    }

    private void createCheckboxes(Composite parent, GridData layoutData) {
        this.changePerspectiveAutomatically = new Button(parent, 32);
        this.changePerspectiveAutomatically.setText("Change perspectives automatically and don't ask again");
        this.changePerspectiveAutomatically.setLayoutData((Object)layoutData);
        this.changePerspectiveAutomatically.setSelection(this.preferenceStore.getBoolean(this.preferenceKey));
    }
}

