/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.msd.swt.ui.components;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.Date;
import org.eclipse.chemclipse.converter.exceptions.NoConverterAvailableException;
import org.eclipse.chemclipse.logging.core.Logger;
import org.eclipse.chemclipse.model.identifier.ILibraryInformation;
import org.eclipse.chemclipse.msd.converter.database.DatabaseConverter;
import org.eclipse.chemclipse.msd.converter.database.DatabaseConverterSupport;
import org.eclipse.chemclipse.msd.model.core.IIon;
import org.eclipse.chemclipse.msd.model.core.IMassSpectra;
import org.eclipse.chemclipse.msd.model.core.IScanMSD;
import org.eclipse.chemclipse.msd.model.implementation.Ion;
import org.eclipse.chemclipse.msd.model.implementation.RegularLibraryMassSpectrum;
import org.eclipse.chemclipse.msd.swt.ui.components.massspectrum.MassSpectrumListUI;
import org.eclipse.chemclipse.msd.swt.ui.internal.runnables.LibraryImportRunnable;
import org.eclipse.chemclipse.msd.swt.ui.preferences.PreferenceSupplier;
import org.eclipse.chemclipse.rcp.ui.icons.core.ApplicationImageFactory;
import org.eclipse.chemclipse.support.text.ValueFormat;
import org.eclipse.chemclipse.swt.ui.components.SearchSupportUI;
import org.eclipse.chemclipse.swt.ui.support.Colors;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;

public class LibraryModifySupportUI
extends Composite {
    private static final Logger logger = Logger.getLogger(LibraryModifySupportUI.class);
    private static final String ACTION_INITIALIZE = "ACTION_INITIALIZE";
    private static final String ACTION_CANCEL = "ACTION_CANCEL";
    private static final String ACTION_DELETE = "ACTION_DELETE";
    private static final String ACTION_IMPORT = "ACTION_IMPORT";
    private static final String ACTION_SELECT = "ACTION_SELECT";
    private static final String ACTION_ADD = "ACTION_ADD";
    private Text textLibraryPath;
    private Button buttonSelectLibrary;
    private Button buttonMergeLibrary;
    private Button buttonCancel;
    private Button buttonDelete;
    private Button buttonAdd;
    private Button buttonImport;
    private MassSpectrumListUI massSpectrumListUI;
    private SearchSupportUI searchSupportUI;
    private IMassSpectra massSpectra;

    public LibraryModifySupportUI(Composite parent, int style) {
        super(parent, style);
        this.createControl();
    }

    public void update(IMassSpectra massSpectra) {
        this.massSpectra = massSpectra;
        if (this.massSpectrumListUI != null) {
            this.massSpectrumListUI.setInput(massSpectra);
        }
    }

    public void setReferencedComposites(MassSpectrumListUI massSpectrumListUI, SearchSupportUI searchSupportUI) {
        this.searchSupportUI = searchSupportUI;
        this.massSpectrumListUI = massSpectrumListUI;
        this.massSpectrumListUI.getTable().addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                LibraryModifySupportUI.this.enableButtonFields(LibraryModifySupportUI.ACTION_SELECT);
            }
        });
        this.enableButtonFields(ACTION_INITIALIZE);
    }

    private void createControl() {
        this.setLayout((Layout)new FillLayout());
        Composite composite = new Composite((Composite)this, 0);
        composite.setBackground(Colors.WHITE);
        GridLayout gridLayout = new GridLayout(8, false);
        gridLayout.marginLeft = 0;
        gridLayout.marginRight = 0;
        composite.setLayout((Layout)gridLayout);
        this.createLibraryPathText(composite);
        this.createSelectLibraryButton(composite);
        this.createMergeLibraryButton(composite);
        this.createCancelLibraryButton(composite);
        this.createDeleteLibraryButton(composite);
        this.createAddLibraryButton(composite);
        this.createImportLibraryButton(composite);
        this.createResetSearchButton(composite);
        this.enableButtonFields(ACTION_INITIALIZE);
    }

    private void createLibraryPathText(Composite parent) {
        this.textLibraryPath = new Text(parent, 2048);
        this.textLibraryPath.setToolTipText("Absolute path to your library.");
        this.textLibraryPath.setText("");
        this.textLibraryPath.setLayoutData((Object)new GridData(768));
    }

    private void createSelectLibraryButton(Composite parent) {
        this.buttonSelectLibrary = new Button(parent, 8);
        this.buttonSelectLibrary.setToolTipText("Select a library");
        this.buttonSelectLibrary.setText("");
        this.buttonSelectLibrary.setImage(ApplicationImageFactory.getInstance().getImage("org.eclipse.chemclipse.rcp.ui.icons/file.gif", "16x16"));
        this.buttonSelectLibrary.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DatabaseConverterSupport databaseConverterSupport = DatabaseConverter.getDatabaseConverterSupport();
                try {
                    String[] extensions = databaseConverterSupport.getFilterExtensions();
                    String[] names = databaseConverterSupport.getFilterNames();
                    if (extensions.length == names.length) {
                        String[] filterExtensions = new String[extensions.length + 1];
                        String[] filterNames = new String[extensions.length + 1];
                        filterExtensions[0] = "*.*";
                        filterNames[0] = "All files";
                        int i = 0;
                        while (i < extensions.length) {
                            filterExtensions[i + 1] = extensions[i].replace(".", "*.");
                            filterNames[i + 1] = names[i];
                            ++i;
                        }
                        Shell shell = Display.getCurrent().getActiveShell();
                        FileDialog fileDialog = new FileDialog(shell, 8);
                        fileDialog.setText("Select Library");
                        fileDialog.setFilterExtensions(filterExtensions);
                        fileDialog.setFilterNames(filterNames);
                        fileDialog.setFilterPath(PreferenceSupplier.getPathMassSpectrumLibraries());
                        String pathname = fileDialog.open();
                        if (pathname != null) {
                            PreferenceSupplier.setPathMassSpectrumLibraries(fileDialog.getFilterPath());
                            LibraryModifySupportUI.this.textLibraryPath.setText(pathname);
                        }
                    }
                }
                catch (NoConverterAvailableException e1) {
                    logger.warn((Object)e1);
                }
            }
        });
    }

    private void createMergeLibraryButton(Composite parent) {
        final Shell shell = Display.getCurrent().getActiveShell();
        this.buttonMergeLibrary = new Button(parent, 8);
        this.buttonMergeLibrary.setText("");
        this.buttonMergeLibrary.setToolTipText("Merge the selected library");
        this.buttonMergeLibrary.setImage(ApplicationImageFactory.getInstance().getImage("org.eclipse.chemclipse.rcp.ui.icons/execute.gif", "16x16"));
        this.buttonMergeLibrary.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String pathLibrary = LibraryModifySupportUI.this.textLibraryPath.getText().trim();
                if ("".equals(pathLibrary)) {
                    MessageBox messageBox = new MessageBox(shell, 40);
                    messageBox.setText("Merge Library");
                    messageBox.setMessage("Please select a library.");
                    messageBox.open();
                } else {
                    File file = new File(LibraryModifySupportUI.this.textLibraryPath.getText().trim());
                    LibraryImportRunnable runnable = new LibraryImportRunnable(file);
                    ProgressMonitorDialog monitor = new ProgressMonitorDialog(shell);
                    try {
                        monitor.run(true, true, (IRunnableWithProgress)runnable);
                    }
                    catch (InvocationTargetException e1) {
                        logger.warn((Object)e1);
                    }
                    catch (InterruptedException e1) {
                        logger.warn((Object)e1);
                    }
                    IMassSpectra massSpectraImport = runnable.getMassSpectra();
                    if (massSpectraImport != null) {
                        LibraryModifySupportUI.this.textLibraryPath.setText("");
                        LibraryModifySupportUI.this.massSpectra.addMassSpectra((Collection)massSpectraImport.getList());
                        LibraryModifySupportUI.this.update(LibraryModifySupportUI.this.massSpectra);
                        LibraryModifySupportUI.this.resetSearch();
                    }
                    LibraryModifySupportUI.this.enableButtonFields(LibraryModifySupportUI.ACTION_INITIALIZE);
                }
            }
        });
    }

    private void createCancelLibraryButton(Composite parent) {
        this.buttonCancel = new Button(parent, 8);
        this.buttonCancel.setToolTipText("Cancel operation");
        this.buttonCancel.setImage(ApplicationImageFactory.getInstance().getImage("org.eclipse.chemclipse.rcp.ui.icons/cancel.gif", "16x16"));
        this.buttonCancel.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                LibraryModifySupportUI.this.enableButtonFields(LibraryModifySupportUI.ACTION_CANCEL);
            }
        });
    }

    private void createDeleteLibraryButton(Composite parent) {
        this.buttonDelete = new Button(parent, 8);
        this.buttonDelete.setEnabled(false);
        this.buttonDelete.setText("");
        this.buttonDelete.setToolTipText("Delete the library entry.");
        this.buttonDelete.setImage(ApplicationImageFactory.getInstance().getImage("org.eclipse.chemclipse.rcp.ui.icons/delete.gif", "16x16"));
        this.buttonDelete.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Table table;
                int index;
                if (LibraryModifySupportUI.this.massSpectrumListUI != null && (index = (table = LibraryModifySupportUI.this.massSpectrumListUI.getTable()).getSelectionIndex()) >= 0) {
                    MessageBox messageBox = new MessageBox(Display.getCurrent().getActiveShell(), 296);
                    messageBox.setText("Delete library entrie(s)?");
                    messageBox.setMessage("Would you like to delete the library entrie(s)?");
                    if (messageBox.open() == 32) {
                        TableItem[] tableItems;
                        LibraryModifySupportUI.this.enableButtonFields(LibraryModifySupportUI.ACTION_DELETE);
                        TableItem[] tableItemArray = tableItems = table.getSelection();
                        int n = tableItems.length;
                        int n2 = 0;
                        while (n2 < n) {
                            TableItem tableItem = tableItemArray[n2];
                            Object object = tableItem.getData();
                            if (object instanceof IScanMSD) {
                                IScanMSD massSpectrum = (IScanMSD)object;
                                LibraryModifySupportUI.this.massSpectra.removeMassSpectrum(massSpectrum);
                            }
                            ++n2;
                        }
                        LibraryModifySupportUI.this.update(LibraryModifySupportUI.this.massSpectra);
                        LibraryModifySupportUI.this.resetSearch();
                    }
                }
            }
        });
    }

    private void createAddLibraryButton(Composite parent) {
        this.buttonAdd = new Button(parent, 8);
        this.buttonAdd.setToolTipText("Add a library entry.");
        this.buttonAdd.setText("");
        this.buttonAdd.setImage(ApplicationImageFactory.getInstance().getImage("org.eclipse.chemclipse.rcp.ui.icons/add.gif", "16x16"));
        this.buttonAdd.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                LibraryModifySupportUI.this.enableButtonFields(LibraryModifySupportUI.ACTION_ADD);
                MessageBox messageBox = new MessageBox(Display.getCurrent().getActiveShell(), 290);
                messageBox.setText("Add library entry?");
                messageBox.setMessage("Would you like to add a new library entry?");
                if (messageBox.open() == 32) {
                    try {
                        String name = "Add a name";
                        RegularLibraryMassSpectrum libraryMassSpectrum = new RegularLibraryMassSpectrum();
                        ILibraryInformation libraryInformation = libraryMassSpectrum.getLibraryInformation();
                        libraryInformation.setName(name);
                        libraryInformation.setComments("This library entry has been added manually");
                        libraryInformation.setMiscellaneous(ValueFormat.getDateFormatEnglish().format(new Date()));
                        libraryMassSpectrum.addIon((IIon)new Ion(18.0, 600.0f));
                        libraryMassSpectrum.addIon((IIon)new Ion(28.0, 1000.0f));
                        libraryMassSpectrum.addIon((IIon)new Ion(32.0, 250.0f));
                        LibraryModifySupportUI.this.massSpectra.addMassSpectrum((IScanMSD)libraryMassSpectrum);
                        if (LibraryModifySupportUI.this.searchSupportUI != null) {
                            LibraryModifySupportUI.this.searchSupportUI.setSearchText(name);
                        }
                    }
                    catch (Exception e1) {
                        logger.warn((Object)e1);
                    }
                }
                LibraryModifySupportUI.this.enableButtonFields(LibraryModifySupportUI.ACTION_INITIALIZE);
            }
        });
    }

    private void createImportLibraryButton(Composite parent) {
        this.buttonImport = new Button(parent, 8);
        this.buttonImport.setToolTipText("Import a library.");
        this.buttonImport.setText("");
        this.buttonImport.setImage(ApplicationImageFactory.getInstance().getImage("org.eclipse.chemclipse.rcp.ui.icons/import.png", "16x16"));
        this.buttonImport.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                LibraryModifySupportUI.this.enableButtonFields(LibraryModifySupportUI.ACTION_IMPORT);
            }
        });
    }

    private void createResetSearchButton(Composite parent) {
        Button button = new Button(parent, 8);
        button.setToolTipText("Reset the search settings.");
        button.setText("");
        button.setImage(ApplicationImageFactory.getInstance().getImage("org.eclipse.chemclipse.rcp.ui.icons/reset.gif", "16x16"));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                LibraryModifySupportUI.this.resetSearch();
            }
        });
    }

    private void resetSearch() {
        if (this.searchSupportUI != null) {
            this.searchSupportUI.setSearchText("");
        }
    }

    private void enableButtonFields(String action) {
        this.enableFields(false);
        switch (action) {
            case "ACTION_INITIALIZE": {
                this.buttonAdd.setEnabled(true);
                this.buttonImport.setEnabled(true);
                break;
            }
            case "ACTION_CANCEL": {
                this.buttonAdd.setEnabled(true);
                this.buttonImport.setEnabled(true);
                break;
            }
            case "ACTION_DELETE": {
                this.buttonAdd.setEnabled(true);
                break;
            }
            case "ACTION_IMPORT": {
                this.buttonCancel.setEnabled(true);
                this.textLibraryPath.setEnabled(true);
                this.buttonSelectLibrary.setEnabled(true);
                this.buttonMergeLibrary.setEnabled(true);
                break;
            }
            case "ACTION_SELECT": {
                this.buttonAdd.setEnabled(true);
                this.buttonImport.setEnabled(true);
                if (this.massSpectrumListUI != null && this.massSpectrumListUI.getTable().getSelectionIndex() >= 0) {
                    this.buttonDelete.setEnabled(true);
                    break;
                }
                this.buttonDelete.setEnabled(false);
                break;
            }
            case "ACTION_ADD": {
                this.buttonCancel.setEnabled(true);
            }
        }
    }

    private void enableFields(boolean enabled) {
        this.buttonCancel.setEnabled(enabled);
        this.buttonDelete.setEnabled(enabled);
        this.buttonAdd.setEnabled(enabled);
        this.buttonImport.setEnabled(enabled);
        this.textLibraryPath.setEnabled(enabled);
        this.buttonSelectLibrary.setEnabled(enabled);
        this.buttonMergeLibrary.setEnabled(enabled);
    }
}

