/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.chromatogram.xxd.edit.supplier.snip.core;

import java.util.List;
import org.eclipse.chemclipse.chromatogram.filter.result.ResultStatus;
import org.eclipse.chemclipse.chromatogram.msd.filter.core.massspectrum.AbstractMassSpectrumFilter;
import org.eclipse.chemclipse.chromatogram.msd.filter.result.IMassSpectrumFilterResult;
import org.eclipse.chemclipse.chromatogram.msd.filter.result.MassSpectrumFilterResult;
import org.eclipse.chemclipse.chromatogram.msd.filter.settings.IMassSpectrumFilterSettings;
import org.eclipse.chemclipse.chromatogram.xxd.edit.supplier.snip.calculator.FilterSupplier;
import org.eclipse.chemclipse.chromatogram.xxd.edit.supplier.snip.preferences.PreferenceSupplier;
import org.eclipse.chemclipse.chromatogram.xxd.edit.supplier.snip.settings.MassSpectrumFilterSettings;
import org.eclipse.chemclipse.msd.model.core.IScanMSD;
import org.eclipse.chemclipse.processing.core.IProcessingInfo;
import org.eclipse.chemclipse.processing.core.IProcessingMessage;
import org.eclipse.chemclipse.processing.core.MessageType;
import org.eclipse.chemclipse.processing.core.ProcessingMessage;
import org.eclipse.core.runtime.IProgressMonitor;

public class MassSpectrumFilter
extends AbstractMassSpectrumFilter {
    private static final String DESCRIPTION = "SNIP Filter Mass Spectra";

    public IProcessingInfo<IMassSpectrumFilterResult> applyFilter(List<IScanMSD> massSpectra, IMassSpectrumFilterSettings filterSettings, IProgressMonitor monitor) {
        IProcessingInfo processingInfo;
        if (filterSettings == null) {
            filterSettings = PreferenceSupplier.getMassSpectrumFilterSettings();
        }
        if (!(processingInfo = this.validate(massSpectra, (IMassSpectrumFilterSettings)filterSettings)).hasErrorMessages()) {
            if (filterSettings instanceof MassSpectrumFilterSettings) {
                MassSpectrumFilterSettings massSpectrumFilterSettings = (MassSpectrumFilterSettings)((Object)filterSettings);
                FilterSupplier filterSupplier = new FilterSupplier();
                int iterations = massSpectrumFilterSettings.getIterations();
                int transitions = massSpectrumFilterSettings.getTransitions();
                double magnificationFactor = massSpectrumFilterSettings.getMagnificationFactor();
                filterSupplier.applySnipFilter(massSpectra, iterations, transitions, magnificationFactor, monitor);
                processingInfo.addMessage((IProcessingMessage)new ProcessingMessage(MessageType.INFO, DESCRIPTION, "The mass spectrum has been optimized successfully."));
                MassSpectrumFilterResult massSpectrumFilterResult = new MassSpectrumFilterResult(ResultStatus.OK, "The SNIP filter has been applied successfully.");
                processingInfo.setProcessingResult((Object)massSpectrumFilterResult);
            } else {
                processingInfo.addErrorMessage(DESCRIPTION, "The filter settings instance is not a type of: " + MassSpectrumFilterSettings.class);
            }
        }
        return processingInfo;
    }
}

