/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.chromatogram.msd.process.supplier.batchprocess.io;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.List;
import javax.xml.stream.XMLEventFactory;
import javax.xml.stream.XMLEventWriter;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Characters;
import javax.xml.stream.events.Comment;
import javax.xml.stream.events.EndElement;
import javax.xml.stream.events.StartElement;
import org.eclipse.chemclipse.chromatogram.msd.process.supplier.batchprocess.model.BatchProcessJob;
import org.eclipse.chemclipse.converter.exceptions.FileIsNotWriteableException;
import org.eclipse.chemclipse.converter.model.IChromatogramInputEntry;
import org.eclipse.chemclipse.processing.methods.IProcessEntry;
import org.eclipse.chemclipse.processing.methods.IProcessMethod;
import org.eclipse.core.runtime.IProgressMonitor;

public class JobWriter {
    public void writeBatchProcessJob(File file, BatchProcessJob batchProcessJob, IProgressMonitor monitor) throws FileNotFoundException, FileIsNotWriteableException, IOException, XMLStreamException {
        XMLOutputFactory xmlOutputFactory = XMLOutputFactory.newInstance();
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file));
        XMLEventWriter eventWriter = xmlOutputFactory.createXMLEventWriter(bufferedOutputStream, "UTF-8");
        XMLEventFactory eventFactory = XMLEventFactory.newInstance();
        eventWriter.add(eventFactory.createStartDocument());
        StartElement chromatogramStart = eventFactory.createStartElement("", "", "BatchProcessJob");
        eventWriter.add(chromatogramStart);
        this.writeBatchProcessJobHeader(eventWriter, eventFactory, batchProcessJob);
        this.writeComment(eventWriter, eventFactory, "Load the following chromatograms.");
        this.writeChromatogramInputEntries(eventWriter, eventFactory, batchProcessJob.getChromatogramInputEntries());
        this.writeComment(eventWriter, eventFactory, "Process each chromatogram with the listed method entries.");
        this.writeChromatogramProcessEntries(eventWriter, eventFactory, batchProcessJob.getProcessMethod());
        EndElement chromatogramEnd = eventFactory.createEndElement("", "", "BatchProcessJob");
        eventWriter.add(chromatogramEnd);
        eventWriter.add(eventFactory.createEndDocument());
        bufferedOutputStream.flush();
        eventWriter.flush();
        bufferedOutputStream.close();
        eventWriter.close();
    }

    private void writeComment(XMLEventWriter eventWriter, XMLEventFactory eventFactory, String comment) throws XMLStreamException {
        Comment batchJobInfo = eventFactory.createComment(comment);
        eventWriter.add(batchJobInfo);
    }

    private void writeBatchProcessJobHeader(XMLEventWriter eventWriter, XMLEventFactory eventFactory, BatchProcessJob batchProcessJob) throws XMLStreamException {
        StartElement headerStart = eventFactory.createStartElement("", "", "Header");
        EndElement headerEnd = eventFactory.createEndElement("", "", "Header");
        eventWriter.add(headerStart);
        eventWriter.add(headerEnd);
    }

    private void writeChromatogramInputEntries(XMLEventWriter eventWriter, XMLEventFactory eventFactory, List<IChromatogramInputEntry> inputEntries) throws XMLStreamException {
        StartElement entriesStart = eventFactory.createStartElement("", "", "InputEntries");
        EndElement entriesEnd = eventFactory.createEndElement("", "", "InputEntries");
        eventWriter.add(entriesStart);
        for (IChromatogramInputEntry inputEntry : inputEntries) {
            this.writeChromatogramInputEntry(eventWriter, eventFactory, inputEntry);
        }
        eventWriter.add(entriesEnd);
    }

    private void writeChromatogramInputEntry(XMLEventWriter eventWriter, XMLEventFactory eventFactory, IChromatogramInputEntry inputEntry) throws XMLStreamException {
        StartElement entryStart = eventFactory.createStartElement("", "", "InputEntry");
        EndElement entryEnd = eventFactory.createEndElement("", "", "InputEntry");
        Characters inputFile = eventFactory.createCData(inputEntry.getInputFile());
        eventWriter.add(entryStart);
        eventWriter.add(inputFile);
        eventWriter.add(entryEnd);
    }

    private void writeChromatogramProcessEntries(XMLEventWriter eventWriter, XMLEventFactory eventFactory, IProcessMethod processMethod) throws XMLStreamException {
        StartElement entriesStart = eventFactory.createStartElement("", "", "ProcessEntries");
        EndElement entriesEnd = eventFactory.createEndElement("", "", "ProcessEntries");
        eventWriter.add(entriesStart);
        for (IProcessEntry processEntry : processMethod) {
            this.writeChromatogramProcessEntry(eventWriter, eventFactory, processEntry);
        }
        eventWriter.add(entriesEnd);
    }

    private void writeChromatogramProcessEntry(XMLEventWriter eventWriter, XMLEventFactory eventFactory, IProcessEntry processEntry) throws XMLStreamException {
        StartElement entryStart = eventFactory.createStartElement("", "", "ProcessEntry");
        EndElement entryEnd = eventFactory.createEndElement("", "", "ProcessEntry");
        eventWriter.add(entryStart);
        eventWriter.add(eventFactory.createAttribute("id", processEntry.getProcessorId()));
        eventWriter.add(eventFactory.createAttribute("name", processEntry.getName()));
        eventWriter.add(eventFactory.createAttribute("description", processEntry.getDescription()));
        eventWriter.add(eventFactory.createAttribute("jsonSettings", processEntry.getSettings()));
        eventWriter.add(eventFactory.createAttribute("symbolicName", ""));
        eventWriter.add(eventFactory.createAttribute("className", ""));
        eventWriter.add(eventFactory.createAttribute("dataTypes", ""));
        eventWriter.add(entryEnd);
    }
}

