/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.chromatogram.msd.peak.detector.supplier.amdis.preferences;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.chemclipse.chromatogram.msd.peak.detector.supplier.amdis.Activator;
import org.eclipse.chemclipse.chromatogram.msd.peak.detector.supplier.amdis.settings.IOnsiteSettings;
import org.eclipse.chemclipse.chromatogram.msd.peak.detector.supplier.amdis.settings.PeakDetectorSettings;
import org.eclipse.chemclipse.support.preferences.IPreferenceSupplier;
import org.eclipse.chemclipse.support.settings.OperatingSystemUtils;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.core.runtime.preferences.InstanceScope;

public class PreferenceSupplier
implements IPreferenceSupplier {
    public static final String WINDOWS_AMDIS = "C:\\Programs\\NIST\\AMDIS32\\AMDIS32$.exe";
    public static final String WINE_AMDIS_LINUX = "drive_c/Programs/NIST/AMDIS32/AMDIS32$.exe";
    public static final String WINE_AMDIS_MAC = "drive_c/NIST/AMDIS32/AMDIS32$.exe";
    public static final String WINE_AMDIS_UNIX = "drive_c/Programs/NIST/AMDIS32/AMDIS32$.exe";
    public static final String WINDOWS_AMDIS_TMP_PATH = "C:\\tmp";
    public static final String WINE_AMDIS_TMP_PATH_LINUX = "drive_c/tmp";
    public static final String WINE_AMDIS_TMP_PATH_MAC = "drive_c/tmp";
    public static final String WINE_AMDIS_TMP_PATH_UNIX = "drive_c/tmp";
    public static final String P_MAC_WINE_BINARY = "macWineBinary";
    public static final String DEF_MAC_WINE_BINARY = "/Applications/Wine.app";
    public static final String P_AMDIS_APPLICATION = "amdisApplication";
    public static final String DEF_AMDIS_APPLICATION = "C:\\Programs\\NIST\\AMDIS32\\AMDIS32$.exe";
    public static final String P_AMDIS_TMP_PATH = "amdisTmpPath";
    public static final String DEF_AMDIS_TMP_PATH = "C:\\tmp";
    public static final String P_LOW_MZ_AUTO = "lowMzAuto";
    public static final boolean DEF_LOW_MZ_AUTO = true;
    public static final String P_START_MZ = "startMz";
    public static final int DEF_START_MZ = 35;
    public static final String P_HIGH_MZ_AUTO = "highMzAuto";
    public static final boolean DEF_HIGH_MZ_AUTO = true;
    public static final String P_STOP_MZ = "stopMz";
    public static final int DEF_STOP_MZ = 600;
    public static final String P_OMIT_MZ = "omitMz";
    public static final boolean DEF_OMIT_MZ = false;
    public static final String P_OMITED_MZ = "omitedMz";
    public static final String DEF_OMITED_MZ = "0 18 28";
    public static final String P_USE_SOLVENT_TAILING = "useSolventTailing";
    public static final boolean DEF_USE_SOLVENT_TAILING = true;
    public static final String P_SOLVENT_TAILING_MZ = "solventTailingMz";
    public static final int DEF_SOLVENT_TAILING_MZ = 84;
    public static final String P_USE_COLUMN_BLEED = "useColumnBleed";
    public static final boolean DEF_USE_COLUMN_BLEED = true;
    public static final String P_COLUMN_BLEED_MZ = "columnBleedMz";
    public static final int DEF_COLUMN_BLEED_MZ = 207;
    public static final String P_THRESHOLD = "threshold";
    public static final String DEF_THRESHOLD = "3";
    public static final String P_PEAK_WIDTH = "peakWidth";
    public static final int DEF_PEAK_WIDTH = 12;
    public static final String P_ADJACENT_PEAK_SUBTRACTION = "adjacentPeakSubtraction";
    public static final String DEF_ADJACENT_PEAK_SUBTRACTION = "2";
    public static final String P_RESOLUTION = "resolution";
    public static final String DEF_RESOLUTION = "1";
    public static final String P_SENSITIVITY = "sensitivity";
    public static final String DEF_SENSITIVITY = "10";
    public static final String P_SHAPE_REQUIREMENTS = "shapeRequirements";
    public static final String DEF_SHAPE_REQUIREMENTS = "2";
    public static final String P_MIN_SN_RATIO = "minSignalToNoiseRatio";
    public static final float DEF_MIN_SN_RATIO = 0.0f;
    public static final String P_MIN_LEADING = "minLeading";
    public static final float DEF_MIN_LEADING = 0.1f;
    public static final String P_MAX_LEADING = "maxLeading";
    public static final float DEF_MAX_LEADING = 2.0f;
    public static final String P_MIN_TAILING = "minTailing";
    public static final float DEF_MIN_TAILING = 0.1f;
    public static final String P_MAX_TAILING = "maxTailing";
    public static final float DEF_MAX_TAILING = 2.0f;
    private static IPreferenceSupplier preferenceSupplier;

    public static IPreferenceSupplier INSTANCE() {
        if (preferenceSupplier == null) {
            preferenceSupplier = new PreferenceSupplier();
        }
        return preferenceSupplier;
    }

    public IScopeContext getScopeContext() {
        return InstanceScope.INSTANCE;
    }

    public String getPreferenceNode() {
        return Activator.getContext().getBundle().getSymbolicName();
    }

    public Map<String, String> getDefaultValues() {
        HashMap<String, String> defaultValues = new HashMap<String, String>();
        if (OperatingSystemUtils.isLinux()) {
            defaultValues.put(P_AMDIS_APPLICATION, "drive_c/Programs/NIST/AMDIS32/AMDIS32$.exe");
            defaultValues.put(P_AMDIS_TMP_PATH, "drive_c/tmp");
        } else if (OperatingSystemUtils.isMac()) {
            defaultValues.put(P_AMDIS_APPLICATION, WINE_AMDIS_MAC);
            defaultValues.put(P_AMDIS_TMP_PATH, "drive_c/tmp");
        } else if (OperatingSystemUtils.isUnix()) {
            defaultValues.put(P_AMDIS_APPLICATION, "drive_c/Programs/NIST/AMDIS32/AMDIS32$.exe");
            defaultValues.put(P_AMDIS_TMP_PATH, "drive_c/tmp");
        } else {
            defaultValues.put(P_AMDIS_APPLICATION, "C:\\Programs\\NIST\\AMDIS32\\AMDIS32$.exe");
            defaultValues.put(P_AMDIS_TMP_PATH, "C:\\tmp");
        }
        defaultValues.put(P_LOW_MZ_AUTO, Boolean.toString(true));
        defaultValues.put(P_START_MZ, Integer.toString(35));
        defaultValues.put(P_HIGH_MZ_AUTO, Boolean.toString(true));
        defaultValues.put(P_STOP_MZ, Integer.toString(600));
        defaultValues.put(P_OMIT_MZ, Boolean.toString(false));
        defaultValues.put(P_OMITED_MZ, DEF_OMITED_MZ);
        defaultValues.put(P_USE_SOLVENT_TAILING, Boolean.toString(true));
        defaultValues.put(P_SOLVENT_TAILING_MZ, Integer.toString(84));
        defaultValues.put(P_USE_COLUMN_BLEED, Boolean.toString(true));
        defaultValues.put(P_COLUMN_BLEED_MZ, Integer.toString(207));
        defaultValues.put(P_THRESHOLD, DEF_THRESHOLD);
        defaultValues.put(P_PEAK_WIDTH, Integer.toString(12));
        defaultValues.put(P_ADJACENT_PEAK_SUBTRACTION, "2");
        defaultValues.put(P_RESOLUTION, DEF_RESOLUTION);
        defaultValues.put(P_SENSITIVITY, DEF_SENSITIVITY);
        defaultValues.put(P_SHAPE_REQUIREMENTS, "2");
        defaultValues.put(P_MIN_SN_RATIO, Float.toString(0.0f));
        defaultValues.put(P_MIN_LEADING, Float.toString(0.1f));
        defaultValues.put(P_MAX_LEADING, Float.toString(2.0f));
        defaultValues.put(P_MIN_TAILING, Float.toString(0.1f));
        defaultValues.put(P_MAX_TAILING, Float.toString(2.0f));
        return defaultValues;
    }

    public IEclipsePreferences getPreferences() {
        return this.getScopeContext().getNode(this.getPreferenceNode());
    }

    public static PeakDetectorSettings getPeakDetectorSettings() {
        IEclipsePreferences preferences = PreferenceSupplier.INSTANCE().getPreferences();
        PeakDetectorSettings peakDetectorSettings = new PeakDetectorSettings();
        peakDetectorSettings.setMinSignalToNoiseRatio(preferences.getFloat(P_MIN_SN_RATIO, 0.0f));
        peakDetectorSettings.setMinLeading(preferences.getFloat(P_MIN_LEADING, 0.1f));
        peakDetectorSettings.setMaxLeading(preferences.getFloat(P_MAX_LEADING, 2.0f));
        peakDetectorSettings.setMinTailing(preferences.getFloat(P_MIN_TAILING, 0.1f));
        peakDetectorSettings.setMaxTailing(preferences.getFloat(P_MAX_TAILING, 2.0f));
        IOnsiteSettings onsiteSettings = peakDetectorSettings.getOnsiteSettings();
        onsiteSettings.setValue("LOWMZAUTO", preferences.getBoolean(P_LOW_MZ_AUTO, true) ? DEF_RESOLUTION : "0");
        onsiteSettings.setValue("LOMASS", Integer.toString(preferences.getInt(P_START_MZ, 35)));
        onsiteSettings.setValue("HIGHMZAUTO", preferences.getBoolean(P_HIGH_MZ_AUTO, true) ? DEF_RESOLUTION : "0");
        onsiteSettings.setValue("MXMASS", Integer.toString(preferences.getInt(P_STOP_MZ, 600)));
        onsiteSettings.setValue("OMITMZ", preferences.getBoolean(P_OMIT_MZ, false) ? DEF_RESOLUTION : "0");
        onsiteSettings.setValue("OMITEDMZ", preferences.get(P_OMITED_MZ, DEF_OMITED_MZ));
        onsiteSettings.setValue("USESTAIL", preferences.getBoolean(P_USE_SOLVENT_TAILING, true) ? DEF_RESOLUTION : "0");
        onsiteSettings.setValue("STAILMZ", Integer.toString(preferences.getInt(P_SOLVENT_TAILING_MZ, 84)));
        onsiteSettings.setValue("USECOLUMNBLEED", preferences.getBoolean(P_USE_COLUMN_BLEED, true) ? DEF_RESOLUTION : "0");
        onsiteSettings.setValue("BLEEDMZ", Integer.toString(preferences.getInt(P_COLUMN_BLEED_MZ, 207)));
        onsiteSettings.setValue("THRESHOLD", preferences.get(P_THRESHOLD, DEF_THRESHOLD));
        onsiteSettings.setValue("PEAKWIDTH", Integer.toString(preferences.getInt(P_PEAK_WIDTH, 12)));
        onsiteSettings.setValue("DECLEVEL", preferences.get(P_ADJACENT_PEAK_SUBTRACTION, "2"));
        onsiteSettings.setValue("RESOLUTION", preferences.get(P_RESOLUTION, DEF_RESOLUTION));
        onsiteSettings.setValue("SENSIT", preferences.get(P_SENSITIVITY, DEF_SENSITIVITY));
        onsiteSettings.setValue("PEAKSHAPE", preferences.get(P_SHAPE_REQUIREMENTS, "2"));
        return peakDetectorSettings;
    }

    public static String getMacWineBinary() {
        IEclipsePreferences preferences = PreferenceSupplier.INSTANCE().getPreferences();
        return preferences.get(P_MAC_WINE_BINARY, DEF_MAC_WINE_BINARY);
    }

    public static String getAmdisApplication() {
        IEclipsePreferences preferences = PreferenceSupplier.INSTANCE().getPreferences();
        return preferences.get(P_AMDIS_APPLICATION, "C:\\Programs\\NIST\\AMDIS32\\AMDIS32$.exe");
    }

    public static String getAmdisTmpPath() {
        IEclipsePreferences preferences = PreferenceSupplier.INSTANCE().getPreferences();
        return preferences.get(P_AMDIS_TMP_PATH, "C:\\tmp");
    }
}

