/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.model.support;

import java.util.Set;
import org.eclipse.chemclipse.model.identifier.ILibraryInformation;

public class LibraryInformationSupport {
    public boolean matchSearchText(ILibraryInformation libraryInformation, String searchText, boolean caseSensitive) {
        if (libraryInformation == null || searchText == null) {
            return false;
        }
        String name = libraryInformation.getName();
        String referenceIdentifier = libraryInformation.getReferenceIdentifier();
        String formula = libraryInformation.getFormula();
        String smiles = libraryInformation.getSmiles();
        String inchi = libraryInformation.getInChI();
        String casNumber = libraryInformation.getCasNumber();
        String comments = libraryInformation.getComments();
        if (!caseSensitive) {
            searchText = searchText.toLowerCase();
            name = name.toLowerCase();
            referenceIdentifier = referenceIdentifier.toLowerCase();
            formula = formula.toLowerCase();
            casNumber = casNumber.toLowerCase();
            smiles = smiles.toLowerCase();
            inchi = inchi.toLowerCase();
            comments = comments.toLowerCase();
        }
        if (name.matches(searchText)) {
            return true;
        }
        if (referenceIdentifier.matches(searchText)) {
            return true;
        }
        if (formula.matches(searchText)) {
            return true;
        }
        if (smiles.matches(searchText)) {
            return true;
        }
        if (inchi.matches(searchText)) {
            return true;
        }
        if (casNumber.matches(searchText)) {
            return true;
        }
        if (comments.matches(searchText)) {
            return true;
        }
        Set<String> synonyms = libraryInformation.getSynonyms();
        for (String synonym : synonyms) {
            if (!caseSensitive) {
                synonym = synonym.toLowerCase();
            }
            if (!synonym.matches(searchText)) continue;
            return true;
        }
        return false;
    }

    public void extractNameAndReferenceIdentifier(String name, ILibraryInformation libraryInformation, String referenceIdentifierMarker, String referenceIdentifierPrefix) {
        if (name != null && libraryInformation != null) {
            String[] values;
            boolean setNameTraditionally = true;
            if (referenceIdentifierMarker != null && !referenceIdentifierMarker.equals("") && name.contains(referenceIdentifierMarker) && (values = name.split(referenceIdentifierMarker)).length >= 2) {
                setNameTraditionally = false;
                libraryInformation.setName(values[0].trim());
                StringBuilder builder = new StringBuilder();
                if (referenceIdentifierPrefix != null) {
                    builder.append(referenceIdentifierPrefix);
                }
                int size = values.length;
                int i = 1;
                while (i < size) {
                    builder.append(values[i]);
                    if (i < size - 1) {
                        builder.append(" ");
                    }
                    ++i;
                }
                libraryInformation.setReferenceIdentifier(builder.toString().trim());
            }
            if (setNameTraditionally) {
                libraryInformation.setName(name);
            }
        }
    }
}

