/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.model.quantitation;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.chemclipse.logging.core.Logger;
import org.eclipse.chemclipse.model.quantitation.IQuantitationPeak;
import org.eclipse.chemclipse.model.quantitation.IQuantitationPeaks;

public class QuantitationPeaks
extends ArrayList<IQuantitationPeak>
implements IQuantitationPeaks {
    private static final long serialVersionUID = -4303659297540195715L;
    private static final Logger logger = Logger.getLogger(QuantitationPeaks.class);
    private String concentrationUnit = "";

    public QuantitationPeaks(String concentrationUnit) {
        this.concentrationUnit = concentrationUnit;
    }

    @Override
    public void add(int index, IQuantitationPeak quantitationPeak) {
        if (this.isValid(quantitationPeak)) {
            super.add(index, quantitationPeak);
        }
    }

    @Override
    public boolean add(IQuantitationPeak quantitationPeak) {
        if (this.isValid(quantitationPeak)) {
            return super.add(quantitationPeak);
        }
        return false;
    }

    @Override
    public boolean addAll(Collection<? extends IQuantitationPeak> quantitationPeaks) {
        logger.warn((Object)"Please use the add() method.");
        return false;
    }

    @Override
    public boolean addAll(int index, Collection<? extends IQuantitationPeak> quantitationPeaks) {
        logger.warn((Object)"Please use the add() method.");
        return false;
    }

    public boolean isValid(IQuantitationPeak quantitationPeak) {
        if (quantitationPeak != null && this.concentrationUnit.equals(quantitationPeak.getConcentrationUnit())) {
            return true;
        }
        logger.warn((Object)"Can't add the IQuantitationPeak, cause it has a different concentration unit.");
        return false;
    }
}

